/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.machinery.oil_processing.distillation_tower.controller;

import com.drmangotea.tfmg.base.TFMGUtils;
import com.drmangotea.tfmg.base.lang.TFMGTexts;
import com.drmangotea.tfmg.content.decoration.tanks.steel.SteelTankBlock;
import com.drmangotea.tfmg.content.decoration.tanks.steel.SteelTankBlockEntity;
import com.drmangotea.tfmg.content.machinery.oil_processing.distillation_tower.controller.DistillationControllerBlock;
import com.drmangotea.tfmg.content.machinery.oil_processing.distillation_tower.output.DistillationOutputBlockEntity;
import com.drmangotea.tfmg.mixin.accessor.FluidTankBlockEntityAccessor;
import com.drmangotea.tfmg.recipes.DistillationRecipe;
import com.drmangotea.tfmg.registry.TFMGBlockEntities;
import com.drmangotea.tfmg.registry.TFMGRecipeTypes;
import com.drmangotea.tfmg.registry.TFMGTags;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.fluid.SmartFluidTank;
import com.simibubi.create.foundation.recipe.RecipeConditions;
import com.simibubi.create.foundation.recipe.RecipeFinder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.createmod.catnip.animation.LerpedFloat;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;

public class DistillationControllerBlockEntity
extends SmartBlockEntity
implements IHaveGoggleInformation {
    private static final Object DistillationRecipesKey = new Object();
    public DistillationRecipe recipe;
    LerpedFloat angle = LerpedFloat.angular();
    protected IFluidHandler fluidCapability;
    public final FluidTank tank = new SmartFluidTank(8000, this::onFluidStackChanged);

    public DistillationControllerBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.fluidCapability = this.tank;
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, (BlockEntityType)TFMGBlockEntities.DISTILLATION_CONTROLLER.get(), (be, context) -> be.fluidCapability);
    }

    public void remove() {
        super.remove();
        SteelTankBlock.updateTowerState(this.level, this.getBlockPos().relative(DistillationControllerBlock.getFacing(this.getBlockState()).getOpposite()), false, false);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    public void manageDialRendering() {
        if (this.level.isClientSide) {
            this.angle.chase((double)(180.0f * ((float)this.tank.getFluidAmount() / (float)this.tank.getCapacity())), (double)0.2f, LerpedFloat.Chaser.EXP);
            this.angle.tickChaser();
        }
    }

    public void findRecipe(ArrayList<DistillationOutputBlockEntity> outputs) {
        DistillationRecipe recipe;
        if (!(this.recipe != null && this.recipe.matches(this.tank, outputs.toArray().length) || (recipe = this.getMatchingRecipes()) == null)) {
            this.recipe = recipe;
            this.sendData();
        }
    }

    public void manageRecipe() {
        ArrayList<DistillationOutputBlockEntity> outputs = this.getOutputs();
        BlockEntity beBehind = this.level.getBlockEntity(this.getBlockPos().relative(DistillationControllerBlock.getFacing(this.getBlockState()).getOpposite()));
        if (!(beBehind instanceof SteelTankBlockEntity)) {
            return;
        }
        SteelTankBlockEntity be = (SteelTankBlockEntity)beBehind;
        if (outputs.isEmpty() || be.activeHeat == 0) {
            return;
        }
        this.findRecipe(outputs);
        if (this.recipe == null) {
            return;
        }
        float speedModifier = (float)be.activeHeat / 2.0f;
        if ((float)this.recipe.getInputFluid().amount() * speedModifier > (float)this.tank.getFluidAmount()) {
            return;
        }
        if (this.recipe.getFluidResults().toArray().length != this.getOutputs().toArray().length) {
            return;
        }
        if (be.isController() ? be.getHeight() < outputs.toArray().length * 2 || ((FluidTankBlockEntityAccessor)((Object)be)).tfmg$getWidth() < 2 && outputs.toArray().length > 3 : be.getControllerBE() != null && (be.getControllerBE().getHeight() < outputs.toArray().length * 2 || ((FluidTankBlockEntityAccessor)((Object)be.getControllerBE())).tfmg$getWidth() < 2)) {
            return;
        }
        for (DistillationOutputBlockEntity be1 : outputs) {
            if (be1.tank.getSpace() != 0 || be1.mode.get() != DistillationOutputBlockEntity.DistillationOutputMode.KEEP_FLUID) continue;
            return;
        }
        int numero = 0;
        for (DistillationOutputBlockEntity output : outputs) {
            FluidStack fluidStack = (FluidStack)this.recipe.getFluidResults().get(numero);
            if (fluidStack.isEmpty() || output.tank.fill(new FluidStack(fluidStack.getFluidHolder(), (int)((float)fluidStack.getAmount() * speedModifier)), IFluidHandler.FluidAction.SIMULATE) > output.tank.getCapacity() && output.mode.get() == DistillationOutputBlockEntity.DistillationOutputMode.KEEP_FLUID) break;
            output.tank.fill(new FluidStack(fluidStack.getFluidHolder(), (int)((float)fluidStack.getAmount() * speedModifier)), IFluidHandler.FluidAction.EXECUTE);
            int consumption = this.recipe.getInputFluid().amount() / 6;
            this.tank.drain((int)((float)consumption * speedModifier), IFluidHandler.FluidAction.EXECUTE);
            ++numero;
        }
    }

    public void tick() {
        super.tick();
        this.manageDialRendering();
        this.manageRecipe();
    }

    protected void onFluidStackChanged(FluidStack newFluidStack) {
        if (!this.hasLevel()) {
            return;
        }
        if (!this.level.isClientSide) {
            this.setChanged();
            this.sendData();
        }
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        BlockEntity beBehind = this.level.getBlockEntity(this.getBlockPos().relative(DistillationControllerBlock.getFacing(this.getBlockState()).getOpposite()));
        if (beBehind instanceof SteelTankBlockEntity) {
            SteelTankBlockEntity be = (SteelTankBlockEntity)beBehind;
            TFMGTexts.header("distillation_tower").style(ChatFormatting.GRAY).forGoggles(tooltip, 1);
            TFMGTexts.Distillation.level(be.getControllerBE().activeHeat).forGoggles(tooltip, 1);
            TFMGTexts.Distillation.outputs(this.getOutputs().toArray().length).forGoggles(tooltip, 1);
        } else {
            TFMGTexts.Distillation.tankNotFound().forGoggles(tooltip, 1);
        }
        TFMGUtils.createFluidTooltip((BlockEntity)this, tooltip);
        return true;
    }

    protected DistillationRecipe getMatchingRecipes() {
        List list = RecipeFinder.get((Object)this.getRecipeCacheKey(), (Level)this.level, (Predicate)RecipeConditions.isOfType((RecipeType[])new RecipeType[]{TFMGRecipeTypes.DISTILLATION.getType()}));
        for (int i = 0; i < list.toArray().length; ++i) {
            DistillationRecipe recipe = (DistillationRecipe)((RecipeHolder)list.get(i)).value();
            if (recipe.getFluidResults().toArray().length != this.getOutputs().toArray().length) continue;
            for (int y = 0; y < ((SizedFluidIngredient)recipe.getFluidIngredients().getFirst()).getFluids().length; ++y) {
                if (this.tank.getFluid().getFluid() != ((SizedFluidIngredient)recipe.getFluidIngredients().getFirst()).getFluids()[y].getFluid() || this.tank.getFluidAmount() < ((SizedFluidIngredient)recipe.getFluidIngredients().getFirst()).amount()) continue;
                return recipe;
            }
        }
        return null;
    }

    protected Object getRecipeCacheKey() {
        return DistillationRecipesKey;
    }

    public ArrayList<DistillationOutputBlockEntity> getOutputs() {
        ArrayList<DistillationOutputBlockEntity> outputs = new ArrayList<DistillationOutputBlockEntity>();
        BlockPos checkedPos = this.getBlockPos().above();
        for (int i = 0; i < 11; ++i) {
            if (i == 0 || i == 2 || i == 4 || i == 6 || i == 8 || i == 10) {
                BlockEntity blockEntity = this.level.getBlockEntity(checkedPos);
                if (!(blockEntity instanceof DistillationOutputBlockEntity)) break;
                DistillationOutputBlockEntity be = (DistillationOutputBlockEntity)blockEntity;
                outputs.add(be);
            } else if (!this.level.getBlockState(checkedPos).is(TFMGTags.TFMGBlockTags.INDUSTRIAL_PIPE.tag)) break;
            checkedPos = checkedPos.above();
        }
        return outputs;
    }

    protected void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(compound, registries, clientPacket);
        this.tank.readFromNBT(registries, compound.getCompound("TankContent"));
    }

    public void write(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        compound.put("TankContent", (Tag)this.tank.writeToNBT(registries, new CompoundTag()));
    }
}

