/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.machinery.misc.air_intake;

import com.drmangotea.tfmg.content.machinery.misc.air_intake.AirIntakeBlockEntity;
import com.drmangotea.tfmg.registry.TFMGBlockEntities;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.kinetics.base.DirectionalKineticBlock;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.foundation.block.IBE;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class AirIntakeBlock
extends DirectionalKineticBlock
implements IBE<AirIntakeBlockEntity>,
IWrenchable {
    public static final BooleanProperty INVISIBLE = BooleanProperty.create((String)"invisible");

    public AirIntakeBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)INVISIBLE, (Comparable)Boolean.valueOf(false)));
    }

    public Direction.Axis getRotationAxis(BlockState state) {
        return ((Direction)state.getValue((Property)FACING)).getAxis();
    }

    public boolean hasShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction face) {
        AirIntakeBlockEntity be = (AirIntakeBlockEntity)world.getBlockEntity(pos);
        if (be.hasShaft) {
            return face == ((Direction)state.getValue((Property)FACING)).getOpposite();
        }
        return false;
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        Direction direction = context.getClickedFace();
        Level level = context.getLevel();
        AirIntakeBlockEntity be = (AirIntakeBlockEntity)level.getBlockEntity(context.getClickedPos());
        if (direction == ((Direction)state.getValue((Property)FACING)).getOpposite()) {
            ((AirIntakeBlockEntity)level.getBlockEntity((BlockPos)context.getClickedPos())).hasShaft = !be.hasShaft;
            BlockPos pos = context.getClickedPos();
            IWrenchable.playRotateSound((Level)level, (BlockPos)pos);
            AirIntakeBlockEntity kineticBlockEntity = (AirIntakeBlockEntity)level.getBlockEntity(pos);
            if (!kineticBlockEntity.hasShaft) {
                if (kineticBlockEntity.hasNetwork()) {
                    kineticBlockEntity.getOrCreateNetwork().remove((KineticBlockEntity)kineticBlockEntity);
                }
                kineticBlockEntity.detachKinetics();
                kineticBlockEntity.removeSource();
                kineticBlockEntity.setSpeed(0.0f);
                kineticBlockEntity.remove();
                kineticBlockEntity.notifyUpdate();
            } else {
                kineticBlockEntity.attachKinetics();
                kineticBlockEntity.notifyUpdate();
            }
        }
        return super.onWrenched(state, context);
    }

    public Class<AirIntakeBlockEntity> getBlockEntityClass() {
        return AirIntakeBlockEntity.class;
    }

    public BlockEntityType<? extends AirIntakeBlockEntity> getBlockEntityType() {
        return (BlockEntityType)TFMGBlockEntities.AIR_INTAKE.get();
    }

    public RenderShape getRenderShape(BlockState pState) {
        return RenderShape.MODEL;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_55125_) {
        p_55125_.add(new Property[]{FACING, INVISIBLE});
    }
}

