/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.items.weapons.flamethrover;

import com.drmangotea.tfmg.TFMG;
import com.drmangotea.tfmg.TFMGRegistries;
import com.drmangotea.tfmg.content.items.weapons.flamethrover.FlamethrowerFuelType;
import com.drmangotea.tfmg.registry.TFMGFlamethrowerFuelTypes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

public record FlamethrowerFuel(@Nullable ResourceKey<FlamethrowerFuelType> fuelType, int amount, int color) {
    public static final Codec<FlamethrowerFuel> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceKey.codec(TFMGRegistries.FLAMETHROWER_FUEL_TYPE).fieldOf("fuel_type").forGetter(FlamethrowerFuel::fuelType), (App)Codec.INT.fieldOf("amount").forGetter(FlamethrowerFuel::amount), (App)Codec.INT.optionalFieldOf("color", (Object)0xFFFFFF).forGetter(fuel -> fuel.color == 0 ? 0xFFFFFF : fuel.color)).apply((Applicative)instance, FlamethrowerFuel::new));
    public static final StreamCodec<ByteBuf, FlamethrowerFuel> STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceKey.streamCodec(TFMGRegistries.FLAMETHROWER_FUEL_TYPE), FlamethrowerFuel::fuelType, (StreamCodec)ByteBufCodecs.INT, FlamethrowerFuel::amount, (StreamCodec)ByteBufCodecs.INT, FlamethrowerFuel::color, FlamethrowerFuel::new);
    public static final FlamethrowerFuel EMPTY = new FlamethrowerFuel(TFMGFlamethrowerFuelTypes.FALLBACK, 0, 0xFFFFFF);

    public FlamethrowerFuel decrement(int amount) {
        if (this.amount <= amount || this.fuelType == TFMGFlamethrowerFuelTypes.FALLBACK) {
            return EMPTY;
        }
        return new FlamethrowerFuel(this.fuelType, this.amount - amount, this.color);
    }

    public FlamethrowerFuel increment(int amount, int capacity) {
        if (this.fuelType == TFMGFlamethrowerFuelTypes.FALLBACK) {
            return EMPTY;
        }
        if (this.amount + amount > capacity) {
            return new FlamethrowerFuel(this.fuelType, capacity, this.color);
        }
        return new FlamethrowerFuel(this.fuelType, this.amount + amount, this.color);
    }

    public static FlamethrowerFuel createForType(RegistryAccess registryAccess, Fluid fluid, int amount) {
        Optional<Holder.Reference<FlamethrowerFuelType>> type = FlamethrowerFuelType.getTypeForFluid(registryAccess, fluid);
        return type.map(typeReference -> new FlamethrowerFuel((ResourceKey<FlamethrowerFuelType>)typeReference.getKey(), amount, ((FlamethrowerFuelType)typeReference.value()).color())).orElse(EMPTY);
    }

    public static FlamethrowerFuel createForType(RegistryAccess registryAccess, FluidStack stack) {
        return FlamethrowerFuel.createForType(registryAccess, stack.getFluid(), stack.getAmount());
    }

    public static FlamethrowerFuel createForLegacy(RegistryAccess registryAccess, String fuelType, int amount) {
        ResourceKey key = ResourceKey.create(TFMGRegistries.FLAMETHROWER_FUEL_TYPE, (ResourceLocation)TFMG.asResource(fuelType));
        Optional type = registryAccess.lookupOrThrow(TFMGRegistries.FLAMETHROWER_FUEL_TYPE).get(key);
        return type.map(typeReference -> new FlamethrowerFuel((ResourceKey<FlamethrowerFuelType>)typeReference.getKey(), amount, ((FlamethrowerFuelType)((Holder.Reference)type.get()).value()).color())).orElse(EMPTY);
    }

    public boolean isEmpty() {
        if (this.fuelType == TFMGFlamethrowerFuelTypes.FALLBACK) {
            return true;
        }
        return this.amount <= 0;
    }

    public boolean hasFuel() {
        return this.fuelType != TFMGFlamethrowerFuelTypes.FALLBACK;
    }

    public Optional<FlamethrowerFuelType> getFuelType(RegistryAccess registryAccess) {
        return registryAccess.registryOrThrow(TFMGRegistries.FLAMETHROWER_FUEL_TYPE).getOptional(this.fuelType);
    }

    public FlamethrowerFuelType getFuelTypeOrThrow(RegistryAccess registryAccess) {
        return this.getFuelType(registryAccess).orElseThrow(() -> new IllegalStateException("No fuel type found for " + String.valueOf(this.fuelType)));
    }
}

