/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.engines.types.large_engine;

import com.drmangotea.tfmg.content.engines.types.large_engine.LargeEngineBlock;
import com.drmangotea.tfmg.content.engines.types.large_engine.LargeEngineBlockEntity;
import com.drmangotea.tfmg.registry.TFMGPartialModels;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import com.simibubi.create.content.kinetics.steamEngine.PoweredShaftBlockEntity;
import com.simibubi.create.foundation.blockEntity.renderer.SafeBlockEntityRenderer;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import net.createmod.catnip.math.AngleHelper;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.state.BlockState;

public class LargeEngineRenderer
extends SafeBlockEntityRenderer<LargeEngineBlockEntity> {
    public LargeEngineRenderer(BlockEntityRendererProvider.Context context) {
    }

    protected void renderSafe(LargeEngineBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        Float angle = be.getTargetAngle();
        if (angle == null) {
            return;
        }
        BlockState blockState = be.getBlockState();
        Direction facing = LargeEngineBlock.getFacing(blockState);
        Direction.Axis facingAxis = facing.getAxis();
        Direction.Axis axis = Direction.Axis.Y;
        PoweredShaftBlockEntity shaft = be.getShaft();
        if (shaft != null) {
            axis = KineticBlockEntityRenderer.getRotationAxisOf((KineticBlockEntity)shaft);
        }
        boolean roll90 = facingAxis.isHorizontal() && axis == Direction.Axis.Y || facingAxis.isVertical() && axis == Direction.Axis.Z;
        float sine = Mth.sin((float)angle.floatValue());
        float sine2 = Mth.sin((float)(angle.floatValue() - 1.5707964f));
        float piston = (1.0f - sine) / 4.0f * 24.0f / 16.0f;
        VertexConsumer vb = buffer.getBuffer(RenderType.solid());
        ((SuperByteBuffer)this.transformed(be.isSimpleEngine() ? TFMGPartialModels.SIMPLE_LARGE_ENGINE_PISTON : TFMGPartialModels.LARGE_ENGINE_PISTON, blockState, facing, roll90).translate(0.0f, piston, 0.0f)).light(light).renderInto(ms, vb);
        ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)this.transformed(be.isSimpleEngine() ? TFMGPartialModels.SIMPLE_LARGE_ENGINE_LINKAGE : TFMGPartialModels.LARGE_ENGINE_LINKAGE, blockState, facing, roll90).center()).translate(0.0f, 1.0f, 0.0f)).uncenter()).translate(0.0f, piston, 0.0f)).translate(0.0f, 0.25f, 0.5f)).rotateXDegrees(sine2 * 23.0f)).translate(0.0f, -0.25f, -0.5f)).light(light).renderInto(ms, vb);
        ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)this.transformed(AllPartialModels.ENGINE_CONNECTOR, blockState, facing, roll90).translate(0.0f, 2.0f, 0.0f)).center()).rotateX(-angle.floatValue() + 1.5707964f)).uncenter()).light(light).renderInto(ms, vb);
    }

    private SuperByteBuffer transformed(PartialModel model, BlockState blockState, Direction facing, boolean roll90) {
        return (SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)CachedBuffers.partial((PartialModel)model, (BlockState)blockState).center()).rotateYDegrees(AngleHelper.horizontalAngle((Direction)facing))).rotateXDegrees(AngleHelper.verticalAngle((Direction)facing) + 90.0f)).rotateYDegrees(roll90 ? -90.0f : 0.0f)).uncenter();
    }

    public int getViewDistance() {
        return 128;
    }
}

