/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.electricity.utilities.electric_pump;

import com.drmangotea.tfmg.content.electricity.base.ElectricBlockValues;
import com.drmangotea.tfmg.content.electricity.base.IElectric;
import com.simibubi.create.content.fluids.FluidPropagator;
import com.simibubi.create.content.fluids.FluidTransportBehaviour;
import com.simibubi.create.content.fluids.PipeConnection;
import com.simibubi.create.content.fluids.pump.PumpBlock;
import com.simibubi.create.content.fluids.pump.PumpBlockEntity;
import com.simibubi.create.content.kinetics.base.DirectionalKineticBlock;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.advancement.CreateAdvancement;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.createmod.catnip.data.Couple;
import net.createmod.catnip.data.Pair;
import net.createmod.catnip.math.BlockFace;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class ElectricPumpBlockEntity
extends PumpBlockEntity
implements IElectric {
    public ElectricBlockValues data = new ElectricBlockValues(this.getPos());

    public ElectricPumpBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
        this.setLazyTickRate(10);
        this.data.connectNextTick = true;
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        behaviours.add((BlockEntityBehaviour)new ElectricPumpTransferBehavior((SmartBlockEntity)this));
        this.registerAwardables(behaviours, FluidPropagator.getSharedTriggers());
        this.registerAwardables(behaviours, new CreateAdvancement[]{AllAdvancements.PUMP});
    }

    protected void distributePressureTo(Direction side) {
        BlockFace start = new BlockFace(this.worldPosition, side);
        boolean pull = this.isPullingOnSide(this.isFront(side));
        HashSet<BlockFace> targets = new HashSet<BlockFace>();
        HashMap<BlockPos, Pair> pipeGraph = new HashMap<BlockPos, Pair>();
        if (!pull) {
            FluidPropagator.resetAffectedFluidNetworks((Level)this.level, (BlockPos)this.worldPosition, (Direction)side.getOpposite());
        }
        if (!this.hasReachedValidEndpoint((LevelAccessor)this.level, start, pull)) {
            ((Map)pipeGraph.computeIfAbsent(this.worldPosition, $ -> Pair.of((Object)0, new IdentityHashMap())).getSecond()).put(side, pull);
            ((Map)pipeGraph.computeIfAbsent(start.getConnectedPos(), $ -> Pair.of((Object)1, new IdentityHashMap())).getSecond()).put(side.getOpposite(), !pull);
            ArrayList<Pair> frontier = new ArrayList<Pair>();
            HashSet<BlockPos> visited = new HashSet<BlockPos>();
            int maxDistance = (int)((double)FluidPropagator.getPumpRange() * Math.min((double)6.7f, (double)this.data.getVoltage() * 0.02));
            frontier.add(Pair.of((Object)1, (Object)start.getConnectedPos()));
            while (!frontier.isEmpty()) {
                Pair entry = (Pair)frontier.remove(0);
                int distance = (Integer)entry.getFirst();
                BlockPos currentPos = (BlockPos)entry.getSecond();
                if (!this.level.isLoaded(currentPos) || visited.contains(currentPos)) continue;
                visited.add(currentPos);
                BlockState currentState = this.level.getBlockState(currentPos);
                FluidTransportBehaviour pipe = FluidPropagator.getPipe((BlockGetter)this.level, (BlockPos)currentPos);
                if (pipe == null) continue;
                for (Direction face : FluidPropagator.getPipeConnections((BlockState)currentState, (FluidTransportBehaviour)pipe)) {
                    BlockFace blockFace = new BlockFace(currentPos, face);
                    BlockPos connectedPos = blockFace.getConnectedPos();
                    if (!this.level.isLoaded(connectedPos) || blockFace.isEquivalent(start)) continue;
                    if (this.hasReachedValidEndpoint((LevelAccessor)this.level, blockFace, pull)) {
                        ((Map)pipeGraph.computeIfAbsent(currentPos, $ -> Pair.of((Object)distance, new IdentityHashMap())).getSecond()).put(face, pull);
                        targets.add(blockFace);
                        continue;
                    }
                    FluidTransportBehaviour pipeBehaviour = FluidPropagator.getPipe((BlockGetter)this.level, (BlockPos)connectedPos);
                    if (pipeBehaviour == null || pipeBehaviour instanceof ElectricPumpTransferBehavior || visited.contains(connectedPos)) continue;
                    if (distance + 1 >= maxDistance) {
                        ((Map)pipeGraph.computeIfAbsent(currentPos, $ -> Pair.of((Object)distance, new IdentityHashMap())).getSecond()).put(face, pull);
                        targets.add(blockFace);
                        continue;
                    }
                    ((Map)pipeGraph.computeIfAbsent(currentPos, $ -> Pair.of((Object)distance, new IdentityHashMap())).getSecond()).put(face, pull);
                    ((Map)pipeGraph.computeIfAbsent(connectedPos, $ -> Pair.of((Object)(distance + 1), new IdentityHashMap())).getSecond()).put(face.getOpposite(), !pull);
                    frontier.add(Pair.of((Object)(distance + 1), (Object)connectedPos));
                }
            }
        }
        HashMap validFaces = new HashMap();
        this.searchForEndpointRecursively(pipeGraph, targets, validFaces, new BlockFace(start.getPos(), start.getOppositeFace()), pull);
        float pressure = this.getPowerUsage() == 0 ? 0.0f : (float)Math.min(1500, this.data.getVoltage() * 2);
        for (Set set : validFaces.values()) {
            int parallelBranches = Math.max(1, set.size() - 1);
            for (BlockFace face : set) {
                BlockPos pipePos = face.getPos();
                Direction pipeSide = face.getFace();
                if (pipePos.equals((Object)this.worldPosition)) continue;
                boolean inbound = (Boolean)((Map)((Pair)pipeGraph.get(pipePos)).getSecond()).get(pipeSide);
                FluidTransportBehaviour pipeBehaviour = FluidPropagator.getPipe((BlockGetter)this.level, (BlockPos)pipePos);
                if (pipeBehaviour == null) continue;
                pipeBehaviour.addPressure(pipeSide, inbound, pressure / (float)parallelBranches);
            }
        }
    }

    private boolean hasReachedValidEndpoint(LevelAccessor world, BlockFace blockFace, boolean pull) {
        IFluidHandler capability;
        BlockPos connectedPos = blockFace.getConnectedPos();
        BlockState connectedState = world.getBlockState(connectedPos);
        BlockEntity blockEntity = world.getBlockEntity(connectedPos);
        Direction face = blockFace.getFace();
        if (PumpBlock.isPump((BlockState)connectedState) && ((Direction)connectedState.getValue((Property)DirectionalKineticBlock.FACING)).getAxis() == face.getAxis() && blockEntity instanceof ElectricPumpBlockEntity) {
            ElectricPumpBlockEntity pumpBE = (ElectricPumpBlockEntity)blockEntity;
            return pumpBE.isPullingOnSide(pumpBE.isFront(blockFace.getOppositeFace())) != pull;
        }
        FluidTransportBehaviour pipe = FluidPropagator.getPipe((BlockGetter)world, (BlockPos)connectedPos);
        if (pipe != null && pipe.canHaveFlowToward(connectedState, blockFace.getOppositeFace())) {
            return false;
        }
        if (blockEntity != null && (capability = (IFluidHandler)blockEntity.getLevel().getCapability(Capabilities.FluidHandler.BLOCK, blockEntity.getBlockPos(), (Object)face.getOpposite())) != null) {
            return true;
        }
        return FluidPropagator.isOpenEnd((BlockGetter)world, (BlockPos)blockFace.getPos(), (Direction)face);
    }

    protected boolean isFront(Direction side) {
        BlockState blockState = this.getBlockState();
        if (!(blockState.getBlock() instanceof PumpBlock)) {
            return false;
        }
        Direction front = (Direction)blockState.getValue((Property)DirectionalKineticBlock.FACING);
        boolean isFront = side == front;
        return isFront;
    }

    @Override
    public LevelAccessor getLevelAccessor() {
        return this.level;
    }

    public void lazyTick() {
        super.lazyTick();
        this.lazyTickElectricity();
    }

    @Override
    public ElectricBlockValues getData() {
        return this.data;
    }

    @Override
    public float resistance() {
        return 100.0f;
    }

    @Override
    public void sendStuff() {
        this.sendData();
    }

    @Override
    public long getPos() {
        return this.getBlockPos().asLong();
    }

    public void remove() {
        super.remove();
        this.onRemoved();
    }

    public void tick() {
        super.tick();
        this.tickElectricity();
    }

    protected void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(compound, registries, clientPacket);
        this.readElectricity(compound, clientPacket);
    }

    class ElectricPumpTransferBehavior
    extends FluidTransportBehaviour {
        public ElectricPumpTransferBehavior(SmartBlockEntity be) {
            super(be);
        }

        public void tick() {
            super.tick();
            for (Map.Entry entry : this.interfaces.entrySet()) {
                boolean pull = ElectricPumpBlockEntity.this.isPullingOnSide(ElectricPumpBlockEntity.this.isFront((Direction)entry.getKey()));
                Couple pressure = ((PipeConnection)entry.getValue()).getPressure();
                pressure.set(pull, (Object)Float.valueOf(ElectricPumpBlockEntity.this.getPowerUsage() == 0 ? 0.0f : Math.min(1500.0f, (float)ElectricPumpBlockEntity.this.data.getVoltage() * 2.0f)));
                pressure.set(!pull, (Object)Float.valueOf(0.0f));
            }
        }

        public boolean canHaveFlowToward(BlockState state, Direction direction) {
            return ElectricPumpBlockEntity.this.isSideAccessible(direction);
        }

        public FluidTransportBehaviour.AttachmentTypes getRenderedRimAttachment(BlockAndTintGetter world, BlockPos pos, BlockState state, Direction direction) {
            FluidTransportBehaviour.AttachmentTypes attachment = super.getRenderedRimAttachment(world, pos, state, direction);
            if (attachment == FluidTransportBehaviour.AttachmentTypes.RIM) {
                return FluidTransportBehaviour.AttachmentTypes.NONE;
            }
            return attachment;
        }
    }
}

