/*
 * Decompiled with CFR 0.152.
 */
package dev.bluephs.createvintageneoforged.infrastructure.ponder.scenes;

import com.google.common.collect.ImmutableList;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.processing.basin.BasinBlockEntity;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.foundation.ponder.CreateSceneBuilder;
import dev.bluephs.createvintageneoforged.content.kinetics.centrifuge.CentrifugeBlockEntity;
import net.createmod.catnip.data.IntAttached;
import net.createmod.catnip.math.Pointing;
import net.createmod.catnip.nbt.NBTHelper;
import net.createmod.ponder.api.scene.SceneBuilder;
import net.createmod.ponder.api.scene.SceneBuildingUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class VintageProcessingScenes {
    public static void centrifuge(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("centrifuge", "Processing Items with the Centrifuge");
        scene.configureBasePlate(0, 0, 5);
        scene.world().setBlock(util.grid().at(1, 1, 2), AllBlocks.ANDESITE_CASING.getDefaultState(), false);
        scene.world().showSection(util.select().layer(0), Direction.UP);
        scene.idle(5);
        scene.world().showSection(util.select().fromTo(1, 4, 3, 1, 1, 5), Direction.DOWN);
        scene.idle(5);
        scene.world().showSection(util.select().position(1, 1, 2), Direction.DOWN);
        scene.idle(5);
        scene.world().showSection(util.select().position(1, 2, 2), Direction.DOWN);
        scene.idle(5);
        scene.world().showSection(util.select().position(1, 4, 2), Direction.SOUTH);
        scene.idle(5);
        scene.world().showSection(util.select().fromTo(3, 1, 1, 1, 1, 1), Direction.SOUTH);
        scene.world().showSection(util.select().fromTo(3, 1, 5, 3, 1, 2), Direction.SOUTH);
        scene.idle(20);
        BlockPos basin = util.grid().at(1, 2, 2);
        BlockPos pressPos = util.grid().at(1, 4, 2);
        Vec3 basinSide = util.vector().blockSurface(basin, Direction.WEST);
        ItemStack blue = new ItemStack((ItemLike)Items.BLUE_DYE);
        ItemStack red = new ItemStack((ItemLike)Items.RED_DYE);
        ItemStack purple = new ItemStack((ItemLike)Items.PURPLE_DYE);
        scene.overlay().showText(60).pointAt(basinSide).placeNearTarget().attachKeyFrame().text("With a Centrifuge and a Basin, some Crafting Recipes can be automated");
        scene.idle(40);
        scene.overlay().showControls(util.vector().topOf(basin), Pointing.LEFT, 30).withItem(blue);
        scene.overlay().showControls(util.vector().topOf(basin), Pointing.RIGHT, 30).withItem(red);
        scene.idle(30);
        Class<CentrifugeBlockEntity> type = CentrifugeBlockEntity.class;
        scene.world().modifyBlockEntity(pressPos, type, pte -> pte.startProcessingBasin());
        scene.world().createItemOnBeltLike(basin, Direction.UP, red);
        scene.world().createItemOnBeltLike(basin, Direction.UP, blue);
        scene.idle(80);
        scene.world().modifyBlockEntityNBT(util.select().position(basin), BasinBlockEntity.class, nbt -> nbt.put("VisualizedItems", (Tag)NBTHelper.writeCompoundList((Iterable)ImmutableList.of((Object)IntAttached.with((int)1, (Object)purple)), ia -> (CompoundTag)((ItemStack)ia.getValue()).saveOptional(scene.world().getHolderLookupProvider()))));
        scene.idle(4);
        scene.world().createItemOnBelt(util.grid().at(1, 1, 1), Direction.UP, purple);
        scene.idle(30);
        scene.rotateCameraY(-30.0f);
        scene.idle(10);
        scene.world().setBlock(util.grid().at(1, 1, 2), (BlockState)AllBlocks.BLAZE_BURNER.getDefaultState().setValue((Property)BlazeBurnerBlock.HEAT_LEVEL, (Comparable)BlazeBurnerBlock.HeatLevel.KINDLED), true);
        scene.idle(10);
        scene.overlay().showText(80).pointAt(basinSide.subtract(0.0, 1.0, 0.0)).placeNearTarget().text("All of those recipes require the heat of a Blaze Burner");
        scene.idle(40);
        scene.rotateCameraY(30.0f);
        scene.idle(60);
        Vec3 filterPos = util.vector().of(1.0, 2.75, 2.5);
        scene.overlay().showFilterSlotInput(filterPos, Direction.WEST, 100);
        scene.overlay().showText(100).pointAt(filterPos).placeNearTarget().attachKeyFrame().text("The filter slot can be used in case two recipes are conflicting.");
        scene.idle(80);
    }
}

