/*
 * Decompiled with CFR 0.152.
 */
package dev.bluephs.createvintageneoforged.content.kinetics.vibration;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import com.simibubi.create.foundation.blockEntity.renderer.SafeBlockEntityRenderer;
import dev.bluephs.createvintageneoforged.content.kinetics.vibration.VibratingTableBlockEntity;
import dev.bluephs.createvintageneoforged.registry.VintagePartialModels;
import dev.engine_room.flywheel.api.visualization.VisualizationManager;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.createmod.catnip.render.SuperByteBufferCache;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class VibratingTableRenderer
extends SafeBlockEntityRenderer<VibratingTableBlockEntity> {
    public VibratingTableRenderer(BlockEntityRendererProvider.Context context) {
    }

    protected void renderSafe(VibratingTableBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        this.renderTable(be, partialTicks, ms, buffer, light);
        this.renderItems(be, partialTicks, ms, buffer, light, overlay);
        if (VisualizationManager.supportsVisualization((LevelAccessor)be.getLevel())) {
            return;
        }
        this.renderShaft(be, ms, buffer, light, overlay);
    }

    protected void renderTable(VibratingTableBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light) {
        BlockState blockState = be.getBlockState();
        float offset = 0.0f;
        if (be.haveRecipe()) {
            offset = be.getRenderedHeadOffset(partialTicks);
        }
        SuperByteBuffer superBuffer = CachedBuffers.partialFacing((PartialModel)VintagePartialModels.VIBRATING_TABLE, (BlockState)blockState, (Direction)((Direction)blockState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)));
        superBuffer.translate(0.0, (double)offset, 0.0);
        superBuffer.color(0xFFFFFF).light(light).renderInto(ms, buffer.getBuffer(RenderType.cutoutMipped()));
    }

    protected void renderShaft(VibratingTableBlockEntity be, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        KineticBlockEntityRenderer.renderRotatingBuffer((KineticBlockEntity)be, (SuperByteBuffer)this.getRotatedModel(be), (PoseStack)ms, (VertexConsumer)buffer.getBuffer(RenderType.solid()), (int)light);
    }

    protected void renderItems(VibratingTableBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        boolean output;
        boolean input = !be.inputInv.getStackInSlot(0).isEmpty();
        boolean bl = output = !be.outputInv.getStackInSlot(0).isEmpty();
        if (!input && !output) {
            return;
        }
        float offset = 0.0f;
        if (be.haveRecipe()) {
            offset = be.getRenderedHeadOffset(partialTicks);
        }
        if (input) {
            if (!output) {
                boolean alongZ = be.getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING) == Direction.NORTH || be.getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING) == Direction.SOUTH;
                ms.pushPose();
                for (int i = 0; i < be.inputInv.getSlots(); ++i) {
                    ItemStack stack = be.inputInv.getStackInSlot(i);
                    if (stack.isEmpty()) continue;
                    ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
                    BakedModel modelWithOverrides = itemRenderer.getModel(stack, be.getLevel(), null, 0);
                    boolean blockItem = modelWithOverrides.isGui3d();
                    ms.translate(0.5, (double)((blockItem ? 0.925f : 0.875f) + offset), 0.5);
                    ms.scale(0.5f, 0.5f, 0.5f);
                    if (alongZ) {
                        ms.mulPose(Axis.YP.rotationDegrees(90.0f));
                    }
                    ms.mulPose(Axis.XP.rotationDegrees(90.0f));
                    itemRenderer.renderStatic(stack, ItemDisplayContext.FIXED, light, overlay, ms, buffer, be.getLevel(), 0);
                    break;
                }
                ms.popPose();
            } else {
                boolean blockItem;
                BakedModel modelWithOverrides;
                ItemRenderer itemRenderer;
                ItemStack stack;
                int i;
                ms.pushPose();
                for (i = 0; i < be.inputInv.getSlots(); ++i) {
                    stack = be.inputInv.getStackInSlot(i);
                    if (stack.isEmpty()) continue;
                    itemRenderer = Minecraft.getInstance().getItemRenderer();
                    modelWithOverrides = itemRenderer.getModel(stack, be.getLevel(), null, 0);
                    blockItem = modelWithOverrides.isGui3d();
                    ms.translate(0.33, (double)((blockItem ? 0.925f : 0.875f) + offset), 0.33);
                    ms.scale(0.5f, 0.5f, 0.5f);
                    ms.mulPose(Axis.XP.rotationDegrees(90.0f));
                    itemRenderer.renderStatic(stack, ItemDisplayContext.FIXED, light, overlay, ms, buffer, be.getLevel(), 0);
                    ms.mulPose(Axis.XP.rotationDegrees(-90.0f));
                    ms.translate(0.0f, blockItem ? -0.925f : -0.875f, 0.0f);
                    break;
                }
                for (i = 0; i < be.outputInv.getSlots(); ++i) {
                    stack = be.outputInv.getStackInSlot(i);
                    if (stack.isEmpty()) continue;
                    itemRenderer = Minecraft.getInstance().getItemRenderer();
                    modelWithOverrides = itemRenderer.getModel(stack, be.getLevel(), null, 0);
                    blockItem = modelWithOverrides.isGui3d();
                    ms.translate(0.66, (double)(blockItem ? 0.925f : 0.875f), 0.66);
                    ms.mulPose(Axis.XP.rotationDegrees(90.0f));
                    itemRenderer.renderStatic(stack, ItemDisplayContext.FIXED, light, overlay, ms, buffer, be.getLevel(), 0);
                    break;
                }
                ms.popPose();
            }
        } else if (output) {
            boolean alongZ = be.getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING) == Direction.NORTH || be.getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING) == Direction.SOUTH;
            ms.pushPose();
            for (int i = 0; i < be.outputInv.getSlots(); ++i) {
                ItemStack stack = be.outputInv.getStackInSlot(i);
                if (stack.isEmpty()) continue;
                ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
                BakedModel modelWithOverrides = itemRenderer.getModel(stack, be.getLevel(), null, 0);
                boolean blockItem = modelWithOverrides.isGui3d();
                ms.translate(0.5, (double)((blockItem ? 0.925f : 0.875f) + offset), 0.5);
                ms.scale(0.5f, 0.5f, 0.5f);
                if (alongZ) {
                    ms.mulPose(Axis.YP.rotationDegrees(90.0f));
                }
                ms.mulPose(Axis.XP.rotationDegrees(90.0f));
                itemRenderer.renderStatic(stack, ItemDisplayContext.FIXED, light, overlay, ms, buffer, be.getLevel(), 0);
                break;
            }
            ms.popPose();
        }
    }

    protected SuperByteBuffer getRotatedModel(KineticBlockEntity be) {
        return CachedBuffers.block((SuperByteBufferCache.Compartment)KineticBlockEntityRenderer.KINETIC_BLOCK, (BlockState)this.getRenderedBlockState(be));
    }

    protected BlockState getRenderedBlockState(KineticBlockEntity be) {
        return KineticBlockEntityRenderer.shaft((Direction.Axis)KineticBlockEntityRenderer.getRotationAxisOf((KineticBlockEntity)be));
    }
}

