/*
 * Decompiled with CFR 0.152.
 */
package dev.bluephs.createvintageneoforged.content.kinetics.vibration;

import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour;
import com.simibubi.create.content.kinetics.belt.transport.TransportedItemStack;
import com.simibubi.create.content.processing.sequenced.SequencedAssemblyRecipe;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.item.ItemHelper;
import dev.bluephs.createvintageneoforged.content.kinetics.vibration.VibratingRecipe;
import dev.bluephs.createvintageneoforged.infrastructure.config.VintageConfig;
import dev.bluephs.createvintageneoforged.registry.VintageBlockEntity;
import dev.bluephs.createvintageneoforged.registry.VintageRecipes;
import java.util.List;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.wrapper.CombinedInvWrapper;
import net.neoforged.neoforge.items.wrapper.RecipeWrapper;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class VibratingTableBlockEntity
extends KineticBlockEntity {
    public ItemStackHandler inputInv = new ItemStackHandler(1);
    public ItemStackHandler outputInv = new ItemStackHandler(9);
    public IItemHandler capability = new VibratingTableInventoryHandler();
    public int timer;
    private VibratingRecipe lastRecipe;
    private ItemStack playEvent = ItemStack.EMPTY;
    boolean lastRecipeIsAssembly;
    public static final TagKey<Item> storageTag = ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"forge", (String)"storage_blocks"));
    public static final TagKey<Item> leavesTag = ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"leaves"));

    public VibratingTableBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)VintageBlockEntity.VIBRATION.get(), (be, context) -> be.capability);
    }

    public float getRenderedHeadOffset(float partialTicks) {
        return partialTicks * 3.0f / 16.0f;
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        behaviours.add((BlockEntityBehaviour)new DirectBeltInputBehaviour((SmartBlockEntity)this).allowingBeltFunnels().setInsertionHandler(this::onBeltInsert));
        super.addBehaviours(behaviours);
    }

    private ItemStack onBeltInsert(TransportedItemStack transported, Direction side, boolean simulate) {
        if (transported == null || transported.stack.isEmpty()) {
            return transported == null ? ItemStack.EMPTY : transported.stack;
        }
        ItemStack offered = transported.stack.copy();
        ItemStack remainder = this.capability.insertItem(0, offered, simulate);
        if (!simulate && remainder.getCount() != offered.getCount()) {
            this.setChanged();
            this.sendData();
        }
        return remainder;
    }

    public void write(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        compound.putInt("Timer", this.timer);
        compound.put("InputInventory", (Tag)this.inputInv.serializeNBT(registries));
        compound.put("OutputInventory", (Tag)this.outputInv.serializeNBT(registries));
        compound.putBoolean("LastRecipeIsAssembly", this.lastRecipeIsAssembly);
        super.write(compound, registries, clientPacket);
        if (!clientPacket || this.playEvent.isEmpty()) {
            return;
        }
        compound.put("PlayEvent", this.playEvent.saveOptional(registries));
        this.playEvent = ItemStack.EMPTY;
    }

    protected void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(compound, registries, clientPacket);
        this.timer = compound.getInt("Timer");
        this.inputInv.deserializeNBT(registries, compound.getCompound("InputInventory"));
        this.outputInv.deserializeNBT(registries, compound.getCompound("OutputInventory"));
        this.lastRecipeIsAssembly = compound.getBoolean("LastRecipeIsAssembly");
        if (compound.contains("PlayEvent")) {
            this.playEvent = ItemStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)compound.getCompound("PlayEvent"));
        }
    }

    protected AABB createRenderBoundingBox() {
        return new AABB(this.worldPosition).inflate(0.125);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void tickAudio() {
        super.tickAudio();
        if (this.getSpeed() == 0.0f) {
            return;
        }
        if (!this.playEvent.isEmpty()) {
            this.playEvent = ItemStack.EMPTY;
            AllSoundEvents.SANDING_SHORT.playAt(this.level, (Vec3i)this.worldPosition, 3.0f, 1.0f, true);
        }
    }

    public void spawnParticles() {
        if (!this.haveRecipe()) {
            return;
        }
        ItemStack stackInSlot = this.inputInv.getStackInSlot(0);
        if (stackInSlot.isEmpty()) {
            return;
        }
        ItemParticleOption data = new ItemParticleOption(ParticleTypes.ITEM, stackInSlot);
        float angle = this.level.random.nextFloat() * 360.0f;
        Vec3 offset = new Vec3(0.0, 0.0, 0.5);
        offset = VecHelper.rotate((Vec3)offset, (double)angle, (Direction.Axis)Direction.Axis.Y);
        Vec3 target = VecHelper.rotate((Vec3)offset, (double)(this.getSpeed() > 0.0f ? 25.0 : -25.0), (Direction.Axis)Direction.Axis.Y);
        Vec3 center = offset.add(VecHelper.getCenterOf((Vec3i)this.worldPosition));
        target = VecHelper.offsetRandomly((Vec3)target.subtract(offset), (RandomSource)this.level.random, (float)0.0078125f);
        this.level.addParticle((ParticleOptions)data, center.x, center.y + 0.5, center.z, target.x, target.y, target.z);
    }

    public void tick() {
        boolean emptied;
        super.tick();
        if (!this.level.isClientSide && this.level.getGameTime() % 5L == 0L) {
            this.ejectOutput();
        }
        if (!this.level.isClientSide && this.getSpeed() != 0.0f && this.level.getGameTime() % 20L == 0L) {
            AABB pickupBox = new AABB(this.worldPosition).inflate(0.75, 0.4, 0.75).move(0.0, 0.6, 0.0);
            List items = this.level.getEntitiesOfClass(ItemEntity.class, pickupBox, e -> e.isAlive() && !e.getItem().isEmpty());
            for (ItemEntity ie : items) {
                ItemStack stack = ie.getItem();
                if (stack.isEmpty()) continue;
                ItemStack remainder = this.capability.insertItem(0, stack.copy(), false);
                if (remainder.isEmpty()) {
                    ie.discard();
                    this.setChanged();
                    this.sendData();
                    continue;
                }
                if (remainder.getCount() == stack.getCount()) continue;
                ie.setItem(remainder);
                this.setChanged();
                this.sendData();
            }
        }
        if (this.getSpeed() == 0.0f) {
            return;
        }
        boolean allOutputSlotsFull = true;
        for (int i = 0; i < this.outputInv.getSlots(); ++i) {
            ItemStack s = this.outputInv.getStackInSlot(i);
            if (!s.isEmpty() && s.getCount() >= this.outputInv.getSlotLimit(i)) continue;
            allOutputSlotsFull = false;
            break;
        }
        if (allOutputSlotsFull && !(emptied = this.ejectOutput())) {
            return;
        }
        if (this.timer > 0) {
            this.timer -= this.getProcessingSpeed();
            if (this.level.isClientSide) {
                this.spawnParticles();
                return;
            }
            if (this.timer <= 0) {
                this.process();
            }
            return;
        }
        if (this.inputInv.getStackInSlot(0).isEmpty()) {
            return;
        }
        RecipeWrapper inventoryIn = new RecipeWrapper((IItemHandler)this.inputInv);
        if (this.lastRecipe == null || !this.lastRecipe.matches(inventoryIn, this.level)) {
            Optional assemblyRecipe = SequencedAssemblyRecipe.getRecipe((Level)this.level, (RecipeInput)inventoryIn, VintageRecipes.VIBRATING.getType(), VibratingRecipe.class);
            if (assemblyRecipe.isPresent()) {
                this.lastRecipe = (VibratingRecipe)((RecipeHolder)assemblyRecipe.get()).value();
                this.timer = this.lastRecipe.getProcessingDuration();
                if (this.timer == 0) {
                    this.timer = 100;
                }
                this.lastRecipeIsAssembly = true;
                this.sendData();
                return;
            }
            this.lastRecipeIsAssembly = false;
            Optional<Object> recipe = VintageRecipes.VIBRATING.find(inventoryIn, this.level);
            if (!recipe.isPresent()) {
                this.timer = 100;
                this.sendData();
            } else {
                this.lastRecipe = (VibratingRecipe)((Object)recipe.get());
                this.timer = this.lastRecipe.getProcessingDuration();
                this.sendData();
            }
            return;
        }
        this.timer = this.lastRecipe.getProcessingDuration();
        if (this.timer == 0) {
            this.timer = 100;
        }
        this.sendData();
    }

    public void invalidate() {
        super.invalidate();
        this.invalidateCapabilities();
    }

    public void destroy() {
        super.destroy();
        ItemHelper.dropContents((Level)this.level, (BlockPos)this.worldPosition, (IItemHandler)this.inputInv);
        ItemHelper.dropContents((Level)this.level, (BlockPos)this.worldPosition, (IItemHandler)this.outputInv);
    }

    public boolean haveRecipe() {
        return this.canProcess(this.inputInv.getStackInSlot(0));
    }

    private boolean ejectOutput() {
        BlockPos targetPos;
        if (this.level == null || this.level.isClientSide) {
            return false;
        }
        boolean success = false;
        boolean hadItems = false;
        for (Direction dir : Direction.values()) {
            targetPos = this.worldPosition.relative(dir);
            DirectBeltInputBehaviour beltBehaviour = (DirectBeltInputBehaviour)BlockEntityBehaviour.get((BlockGetter)this.level, (BlockPos)targetPos, (BehaviourType)DirectBeltInputBehaviour.TYPE);
            if (beltBehaviour == null) continue;
            for (int i = 0; i < this.outputInv.getSlots(); ++i) {
                ItemStack stack = this.outputInv.getStackInSlot(i);
                if (stack.isEmpty()) continue;
                hadItems = true;
                ItemStack remainder = beltBehaviour.handleInsertion(stack.copy(), dir, false);
                if (remainder.getCount() == stack.getCount()) continue;
                this.outputInv.setStackInSlot(i, remainder);
                this.setChanged();
                this.sendData();
                success = true;
            }
        }
        for (Direction dir : Direction.values()) {
            targetPos = this.worldPosition.relative(dir);
            BlockEntity neighbor = this.level.getBlockEntity(targetPos);
            IItemHandler target = (IItemHandler)Capabilities.ItemHandler.BLOCK.getCapability(this.level, targetPos, this.level.getBlockState(targetPos), neighbor, (Object)dir.getOpposite());
            if (target == null) continue;
            for (int i = 0; i < this.outputInv.getSlots(); ++i) {
                ItemStack stack = this.outputInv.getStackInSlot(i);
                if (stack.isEmpty()) continue;
                hadItems = true;
                ItemStack remainder = ItemHandlerHelper.insertItemStacked((IItemHandler)target, (ItemStack)stack.copy(), (boolean)false);
                if (remainder.getCount() == stack.getCount()) continue;
                this.outputInv.setStackInSlot(i, remainder);
                this.setChanged();
                this.sendData();
                success = true;
            }
        }
        if (success) {
            AllSoundEvents.DEPOT_SLIDE.playAt(this.level, (Vec3i)this.worldPosition, 0.5f, 1.0f, false);
        }
        return success;
    }

    private boolean canProcess(ItemStack stack) {
        if (Mth.abs((float)this.getSpeed()) < IRotate.SpeedLevel.MEDIUM.getSpeedValue()) {
            return false;
        }
        Optional assemblyRecipe = SequencedAssemblyRecipe.getRecipe((Level)this.level, (ItemStack)stack, VintageRecipes.VIBRATING.getType(), VibratingRecipe.class);
        if (assemblyRecipe.isPresent()) {
            return true;
        }
        ItemStackHandler tester = new ItemStackHandler(1);
        tester.setStackInSlot(0, stack);
        RecipeWrapper inventoryIn = new RecipeWrapper((IItemHandler)tester);
        if (this.lastRecipe != null && this.lastRecipe.matches(inventoryIn, this.level)) {
            return true;
        }
        if (VintageRecipes.VIBRATING.find(inventoryIn, this.level).isPresent()) {
            return true;
        }
        return (Boolean)VintageConfig.server().recipes.allowVibratingLeaves.get() != false && VintageRecipes.LEAVES_VIBRATING.find(inventoryIn, this.level).isPresent();
    }

    private void process() {
        RecipeWrapper inventoryIn = new RecipeWrapper((IItemHandler)this.inputInv);
        if (this.lastRecipe == null || !this.lastRecipe.matches(inventoryIn, this.level)) {
            Optional<Object> recipe;
            boolean found = false;
            Optional assemblyRecipe = SequencedAssemblyRecipe.getRecipe((Level)this.level, (RecipeInput)inventoryIn, VintageRecipes.VIBRATING.getType(), VibratingRecipe.class);
            if (assemblyRecipe.isPresent()) {
                this.lastRecipe = (VibratingRecipe)((RecipeHolder)assemblyRecipe.get()).value();
                found = true;
            }
            if (!found && (recipe = VintageRecipes.VIBRATING.find(inventoryIn, this.level)).isPresent()) {
                this.lastRecipe = (VibratingRecipe)((Object)recipe.get());
                found = true;
            }
            if (!found && ((Boolean)VintageConfig.server().recipes.allowVibratingLeaves.get()).booleanValue() && this.inputInv.getStackInSlot(0).is(leavesTag)) {
                ItemStack stackInSlot = this.inputInv.getStackInSlot(0);
                if (stackInSlot.getItem() instanceof BlockItem) {
                    Block leaves = Block.byItem((Item)stackInSlot.getItem());
                    ItemStack hoe = Items.DIAMOND_HOE.getDefaultInstance();
                    List list = Block.getDrops((BlockState)leaves.defaultBlockState(), (ServerLevel)((ServerLevel)this.level), (BlockPos)this.worldPosition, null, null, (ItemStack)hoe.copy());
                    for (ItemStack result2 : list) {
                        ItemHandlerHelper.insertItemStacked((IItemHandler)this.outputInv, (ItemStack)result2, (boolean)false);
                    }
                }
                stackInSlot.shrink(1);
                this.inputInv.setStackInSlot(0, stackInSlot);
                this.sendData();
                this.setChanged();
                return;
            }
            if (!found) {
                return;
            }
        }
        if (this.lastRecipeIsAssembly) {
            VibratingRecipe.apply();
            this.lastRecipe = null;
        } else {
            ItemStack stackInSlot = this.inputInv.getStackInSlot(0);
            stackInSlot.shrink(1);
            this.inputInv.setStackInSlot(0, stackInSlot);
            this.lastRecipe.rollResults(this.level.random).forEach(result -> ItemHandlerHelper.insertItemStacked((IItemHandler)this.outputInv, (ItemStack)result.copy(), (boolean)false));
        }
        this.sendData();
        this.setChanged();
        this.ejectOutput();
    }

    public int getProcessingSpeed() {
        return Mth.clamp((int)((int)Math.abs(this.getSpeed() / 16.0f)), (int)1, (int)512);
    }

    private class VibratingTableInventoryHandler
    extends CombinedInvWrapper {
        public VibratingTableInventoryHandler() {
            super(new IItemHandlerModifiable[]{VibratingTableBlockEntity.this.inputInv, VibratingTableBlockEntity.this.outputInv});
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return true;
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (VibratingTableBlockEntity.this.outputInv == this.getHandlerFromIndex(this.getIndexForSlot(slot))) {
                return stack;
            }
            if (!this.isItemValid(slot, stack)) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (VibratingTableBlockEntity.this.inputInv == this.getHandlerFromIndex(this.getIndexForSlot(slot))) {
                return ItemStack.EMPTY;
            }
            return super.extractItem(slot, amount, simulate);
        }
    }
}

