/*
 * Decompiled with CFR 0.152.
 */
package dev.bluephs.createvintageneoforged.content.kinetics.laser_cutting;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import dev.bluephs.createvintageneoforged.content.kinetics.laser_cutting.LaserBlock;
import dev.bluephs.createvintageneoforged.content.kinetics.laser_cutting.LaserBlockEntity;
import dev.bluephs.createvintageneoforged.registry.VintagePartialModels;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.createmod.catnip.render.SuperByteBufferCache;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.wrapper.RecipeWrapper;

public class LaserRenderer
extends KineticBlockEntityRenderer<LaserBlockEntity> {
    public LaserRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    protected void renderSafe(LaserBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        this.renderHead(be, partialTicks, ms, buffer, light);
        this.renderShaft(be, ms, buffer, light, overlay);
    }

    protected void renderHead(LaserBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light) {
        BlockState blockState = be.getBlockState();
        boolean isPowered = (Boolean)blockState.getValue((Property)LaserBlock.POWERED);
        float angle = LaserRenderer.getAngleForBe((KineticBlockEntity)be, (BlockPos)be.getBlockPos(), (Direction.Axis)Direction.Axis.Y);
        float movementOffset = (float)Math.sin(Math.toRadians(angle)) * 0.25f;
        SuperByteBuffer headBuffer = CachedBuffers.partialFacing((PartialModel)VintagePartialModels.LASER_HEAD, (BlockState)blockState, (Direction)Direction.NORTH);
        if (isPowered) {
            headBuffer.translate(movementOffset, 0.0f, 0.0f);
        }
        headBuffer.color(0xFFFFFF).light(light).renderInto(ms, buffer.getBuffer(RenderType.cutoutMipped()));
        if (isPowered) {
            float progress = 0.0f;
            if (be.processingProgress >= 0.0f) {
                int baseDuration = be.find(new RecipeWrapper((IItemHandler)new ItemStackHandler(1)), be.getLevel()).map(r -> r.getProcessingDuration() <= 0 ? 100 : r.getProcessingDuration()).orElse(100);
                progress = Math.min(1.0f, be.processingProgress / (float)baseDuration);
            }
            int r2 = (int)(128.0f + 127.0f * progress);
            int g = (int)(255.0f * progress);
            int b = (int)(255.0f * progress);
            SuperByteBuffer beamBuffer = CachedBuffers.partialFacing((PartialModel)VintagePartialModels.LASER_BEAM, (BlockState)blockState, (Direction)Direction.NORTH);
            beamBuffer.translate(movementOffset, -0.1875f, 0.0f);
            beamBuffer.color(r2, g, b, 255).light(0xF000F0).renderInto(ms, buffer.getBuffer(RenderType.translucent()));
        }
    }

    protected void renderShaft(LaserBlockEntity be, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        KineticBlockEntityRenderer.renderRotatingBuffer((KineticBlockEntity)be, (SuperByteBuffer)this.getRotatedModel(be), (PoseStack)ms, (VertexConsumer)buffer.getBuffer(RenderType.solid()), (int)light);
    }

    protected SuperByteBuffer getRotatedModel(LaserBlockEntity be) {
        return CachedBuffers.block((SuperByteBufferCache.Compartment)KineticBlockEntityRenderer.KINETIC_BLOCK, (BlockState)this.getRenderedBlockState(be));
    }

    protected BlockState getRenderedBlockState(LaserBlockEntity be) {
        return KineticBlockEntityRenderer.shaft((Direction.Axis)KineticBlockEntityRenderer.getRotationAxisOf((KineticBlockEntity)be));
    }
}

