/*
 * Decompiled with CFR 0.152.
 */
package dev.bluephs.createvintageneoforged.content.kinetics.laser_cutting;

import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.belt.behaviour.BeltProcessingBehaviour;
import com.simibubi.create.content.kinetics.belt.behaviour.TransportedItemStackHandlerBehaviour;
import com.simibubi.create.content.kinetics.belt.transport.TransportedItemStack;
import com.simibubi.create.content.processing.sequenced.SequencedAssemblyRecipe;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.recipe.RecipeApplier;
import dev.bluephs.createvintageneoforged.content.kinetics.laser_cutting.LaserBeltCallbacks;
import dev.bluephs.createvintageneoforged.content.kinetics.laser_cutting.LaserBlock;
import dev.bluephs.createvintageneoforged.content.kinetics.laser_cutting.LaserCuttingRecipe;
import dev.bluephs.createvintageneoforged.registry.VintageBlocks;
import dev.bluephs.createvintageneoforged.registry.VintageRecipes;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.wrapper.RecipeWrapper;

public class LaserBlockEntity
extends KineticBlockEntity
implements IHaveGoggleInformation {
    private Optional<LaserCuttingRecipe> recipeCache = Optional.empty();
    private final ItemStackHandler inputInv = new ItemStackHandler(1);
    protected int poweredTimer = 0;
    protected float processingProgress = -1.0f;
    public BeltProcessingBehaviour processingBehaviour;

    public LaserBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.processingBehaviour = new BeltProcessingBehaviour((SmartBlockEntity)this).whenItemEnters((s, i) -> LaserBeltCallbacks.onItemReceived(s, i, this)).whileItemHeld((s, i) -> LaserBeltCallbacks.whenItemHeld(s, i, this));
        behaviours.add((BlockEntityBehaviour)this.processingBehaviour);
    }

    protected BeltProcessingBehaviour.ProcessingResult onLaser(TransportedItemStack transported, TransportedItemStackHandlerBehaviour handler) {
        return this.laserCompundAndStack(transported, handler);
    }

    public void tick() {
        super.tick();
        if (this.level == null) {
            return;
        }
        if (this.level.isClientSide) {
            if (this.isPoweredState()) {
                this.spawnParticles();
            }
            return;
        }
        this.applyInWorld();
        if (this.processingProgress >= 0.0f) {
            this.sendData();
        }
        if (this.poweredTimer > 0) {
            if (!this.isPoweredState()) {
                ((LaserBlock)((Object)VintageBlocks.LASER.get())).setPowered(this.level, this.getBlockPos(), true);
            }
            --this.poweredTimer;
        } else if (this.isPoweredState()) {
            ((LaserBlock)((Object)VintageBlocks.LASER.get())).setPowered(this.level, this.getBlockPos(), false);
        }
    }

    private float getProgressPerTick() {
        float speed = Math.abs(this.getSpeed());
        if (speed >= 100.0f) {
            return 1.0f;
        }
        if (speed >= 30.0f) {
            return 0.25f;
        }
        return 0.125f;
    }

    protected void applyInWorld() {
        if (this.level.isClientSide) {
            return;
        }
        AABB bb = new AABB(this.worldPosition.below(1));
        for (Entity entity : this.level.getEntities(null, bb)) {
            if (!(entity instanceof ItemEntity)) continue;
            ItemEntity itemEntity = (ItemEntity)entity;
            if (!entity.isAlive() || !entity.onGround() || !this.tryProcessInWorld(itemEntity)) continue;
            this.poweredTimer = 10;
            break;
        }
    }

    public boolean isPoweredState() {
        return (Boolean)this.getBlockState().getValue((Property)LaserBlock.POWERED);
    }

    protected BeltProcessingBehaviour.ProcessingResult laserCompundAndStack(TransportedItemStack transported, TransportedItemStackHandlerBehaviour handler) {
        ItemStack stack = transported.stack;
        if (stack == null) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        if (this.laserRecipe(stack, transported, handler)) {
            this.poweredTimer = 10;
            return BeltProcessingBehaviour.ProcessingResult.HOLD;
        }
        return BeltProcessingBehaviour.ProcessingResult.PASS;
    }

    public Optional<LaserCuttingRecipe> find(RecipeWrapper wrapper, Level world) {
        Optional assemblyRecipe = SequencedAssemblyRecipe.getRecipe((Level)this.level, (ItemStack)wrapper.getItem(0), VintageRecipes.LASER_CUTTING.getType(), LaserCuttingRecipe.class);
        if (assemblyRecipe.isPresent()) {
            return Optional.of((LaserCuttingRecipe)((RecipeHolder)assemblyRecipe.get()).value());
        }
        return world.getRecipeManager().getRecipeFor(VintageRecipes.LASER_CUTTING.getType(), (RecipeInput)wrapper, world).map(holder -> (LaserCuttingRecipe)holder.value());
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        if (this.processingProgress >= 0.0f || this.isPoweredState()) {
            tooltip.add((Component)Component.literal((String)" "));
            tooltip.add((Component)Component.literal((String)"     ").append((Component)Component.translatable((String)"createvintageneoforged.gui.goggles.processing").withStyle(ChatFormatting.GREEN)));
            float progress = 0.0f;
            float secondsLeft = 0.0f;
            if (this.recipeCache.isPresent() && this.processingProgress >= 0.0f) {
                int baseDuration = this.recipeCache.get().getProcessingDuration();
                if (baseDuration <= 0) {
                    baseDuration = 1000;
                }
                progress = Math.min(1.0f, this.processingProgress / (float)baseDuration);
                float ppt = this.getProgressPerTick();
                secondsLeft = ppt > 0.0f ? ((float)baseDuration - this.processingProgress) / ppt / 20.0f : 0.0f;
            }
            tooltip.add((Component)Component.literal((String)"     ").append(this.makeColoredProgressBar(progress)));
            tooltip.add((Component)Component.literal((String)"        ").append((Component)Component.literal((String)String.format("%.1fs", Float.valueOf(Math.max(0.0f, secondsLeft)))).withStyle(ChatFormatting.GOLD)));
        }
        return true;
    }

    private Component makeColoredProgressBar(float progress) {
        int bars = 10;
        int filled = Math.round(progress * (float)bars);
        MutableComponent pBar = Component.literal((String)"");
        int r = (int)(128.0f + 127.0f * progress);
        TextColor color = TextColor.fromRgb((int)(r << 16));
        for (int i = 0; i < bars; ++i) {
            if (i < filled) {
                pBar.append((Component)Component.literal((String)"\u25b0").withStyle(Style.EMPTY.withColor(color)));
                continue;
            }
            pBar.append((Component)Component.literal((String)"\u25b1").withStyle(ChatFormatting.GRAY));
        }
        return pBar;
    }

    private boolean laserRecipe(ItemStack stack, TransportedItemStack transported, TransportedItemStackHandlerBehaviour handler) {
        if (this.getLevel() == null || Math.abs(this.getSpeed()) == 0.0f) {
            return false;
        }
        if (!this.inputInv.getStackInSlot(0).is(stack.getItem())) {
            this.inputInv.setStackInSlot(0, stack);
            this.recipeCache = this.find(new RecipeWrapper((IItemHandler)this.inputInv), this.getLevel());
            this.processingProgress = 0.0f;
        }
        if (this.recipeCache.isPresent()) {
            LaserCuttingRecipe recipe = this.recipeCache.get();
            int baseDuration = recipe.getProcessingDuration();
            if (baseDuration <= 0) {
                baseDuration = 1000;
            }
            this.processingProgress += this.getProgressPerTick();
            this.poweredTimer = 10;
            if (this.processingProgress >= (float)baseDuration) {
                this.applyRecipe(recipe, transported, handler);
                this.processingProgress = -1.0f;
                return true;
            }
            return true;
        }
        return false;
    }

    private void applyRecipe(LaserCuttingRecipe recipe, TransportedItemStack transported, TransportedItemStackHandlerBehaviour handler) {
        int inputCount = ((Ingredient)recipe.getIngredients().get(0)).getItems()[0].getCount();
        List outputs = RecipeApplier.applyRecipeOn((Level)this.level, (ItemStack)transported.stack.copyWithCount(inputCount), (Recipe)recipe, (boolean)true);
        ArrayList outList = new ArrayList();
        outputs.forEach(itemStack -> {
            TransportedItemStack tmp = transported.copy();
            tmp.stack = itemStack;
            outList.add(tmp);
        });
        TransportedItemStack remaining = transported.copy();
        remaining.stack.shrink(inputCount);
        handler.handleProcessingOnItem(transported, TransportedItemStackHandlerBehaviour.TransportedResult.convertToAndLeaveHeld(outList, (TransportedItemStack)remaining));
    }

    public boolean tryProcessInWorld(ItemEntity itemEntity) {
        ItemStack item = itemEntity.getItem();
        if (this.getLevel() == null || Math.abs(this.getSpeed()) == 0.0f) {
            return false;
        }
        if (!this.inputInv.getStackInSlot(0).is(item.getItem())) {
            this.inputInv.setStackInSlot(0, item);
            this.recipeCache = this.find(new RecipeWrapper((IItemHandler)this.inputInv), this.getLevel());
            this.processingProgress = 0.0f;
        }
        if (this.recipeCache.isPresent()) {
            LaserCuttingRecipe recipe = this.recipeCache.get();
            int baseDuration = recipe.getProcessingDuration();
            if (baseDuration <= 0) {
                baseDuration = 1000;
            }
            this.processingProgress += this.getProgressPerTick();
            this.poweredTimer = 10;
            itemEntity.setPickUpDelay(20);
            Vec3 target = VecHelper.getCenterOf((Vec3i)this.worldPosition).subtract(0.0, 0.45, 0.0);
            Vec3 move = target.subtract(itemEntity.position()).scale(0.1);
            itemEntity.setDeltaMovement(move);
            if (this.processingProgress >= (float)baseDuration) {
                int inputCount = ((Ingredient)recipe.getIngredients().get(0)).getItems()[0].getCount();
                List outputs = RecipeApplier.applyRecipeOn((Level)this.level, (ItemStack)item.copyWithCount(inputCount), (Recipe)recipe, (boolean)true);
                for (ItemStack result : outputs) {
                    ItemEntity created = new ItemEntity(this.level, itemEntity.getX(), itemEntity.getY(), itemEntity.getZ(), result);
                    created.setDefaultPickUpDelay();
                    created.setDeltaMovement(VecHelper.offsetRandomly((Vec3)Vec3.ZERO, (RandomSource)this.level.random, (float)0.05f));
                    this.level.addFreshEntity((Entity)created);
                }
                item.shrink(inputCount);
                this.processingProgress = -1.0f;
                this.sendData();
                return true;
            }
            return true;
        }
        return false;
    }

    protected void write(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(compound, registries, clientPacket);
        compound.putFloat("ProcessProgress", this.processingProgress);
        compound.put("InputItem", (Tag)this.inputInv.serializeNBT(registries));
    }

    protected void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(compound, registries, clientPacket);
        this.processingProgress = compound.getFloat("ProcessProgress");
        if (compound.contains("InputItem")) {
            this.inputInv.deserializeNBT(registries, compound.getCompound("InputItem"));
        }
        if (clientPacket && this.level != null && this.level.isClientSide) {
            ItemStack stack = this.inputInv.getStackInSlot(0);
            this.recipeCache = !stack.isEmpty() ? this.find(new RecipeWrapper((IItemHandler)this.inputInv), this.level) : Optional.empty();
        }
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag tag = super.getUpdateTag(registries);
        tag.putFloat("ProcessProgress", this.processingProgress);
        tag.put("InputItem", (Tag)this.inputInv.serializeNBT(registries));
        return tag;
    }

    private void spawnParticles() {
        if (this.level.random.nextInt(2) == 0) {
            double x = (double)this.worldPosition.getX() + 0.5 + ((double)this.level.random.nextFloat() - 0.5) * 0.2;
            double y = (double)this.worldPosition.getY() - 0.4;
            double z = (double)this.worldPosition.getZ() + 0.5 + ((double)this.level.random.nextFloat() - 0.5) * 0.2;
            this.level.addParticle((ParticleOptions)ParticleTypes.CRIT, x, y, z, ((double)this.level.random.nextFloat() - 0.5) * 0.1, 0.1, ((double)this.level.random.nextFloat() - 0.5) * 0.1);
            if (this.level.random.nextInt(4) == 0) {
                this.level.addParticle((ParticleOptions)ParticleTypes.LAVA, x, y, z, 0.0, 0.0, 0.0);
            }
        }
    }

    protected AABB createRenderBoundingBox() {
        return new AABB(this.worldPosition).expandTowards(0.0, -1.5, 0.0).expandTowards(0.0, 1.0, 0.0);
    }
}

