/*
 * Decompiled with CFR 0.152.
 */
package dev.bluephs.createvintageneoforged.content.kinetics.grinder;

import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.simibubi.create.compat.jei.category.sequencedAssembly.SequencedAssemblySubCategory;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeParams;
import com.simibubi.create.content.processing.recipe.StandardProcessingRecipe;
import com.simibubi.create.content.processing.sequenced.IAssemblyRecipe;
import com.simibubi.create.foundation.recipe.IRecipeTypeInfo;
import dev.bluephs.createvintageneoforged.compat.jei.assemblies.AssemblyPolishing;
import dev.bluephs.createvintageneoforged.registry.VintageBlocks;
import dev.bluephs.createvintageneoforged.registry.VintageLang;
import dev.bluephs.createvintageneoforged.registry.VintageRecipes;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.items.wrapper.RecipeWrapper;

@ParametersAreNonnullByDefault
public class PolishingRecipe
extends StandardProcessingRecipe<RecipeWrapper>
implements IAssemblyRecipe {
    boolean fragile = false;
    int speedLimits = 0;

    public PolishingRecipe(ProcessingRecipeParams params) {
        super((IRecipeTypeInfo)VintageRecipes.POLISHING, params);
    }

    protected int getMaxInputCount() {
        return 1;
    }

    protected int getMaxOutputCount() {
        return 4;
    }

    protected boolean canSpecifyDuration() {
        return true;
    }

    public boolean isFragile() {
        return this.fragile;
    }

    public int getSpeedLimits() {
        return this.speedLimits;
    }

    public void addAssemblyIngredients(List<Ingredient> list) {
    }

    public Supplier<Supplier<SequencedAssemblySubCategory>> getJEISubCategory() {
        return () -> AssemblyPolishing::new;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Component getDescriptionForAssembly() {
        MutableComponent result = VintageLang.translateDirect("recipe.assembly.polishing", new Object[0]);
        result.append(" ").append((Component)VintageLang.translateDirect("recipe.assembly.on", new Object[0])).append(" ");
        result.append(" ").append((Component)VintageLang.translateDirect("recipe.assembly.speed", new Object[0]));
        return result;
    }

    public void addRequiredMachines(Set<ItemLike> list) {
        list.add((ItemLike)VintageBlocks.BELT_GRINDER.get());
    }

    public boolean matches(RecipeWrapper smartInventory, Level level) {
        if (smartInventory.isEmpty()) {
            return false;
        }
        return ((Ingredient)this.ingredients.get(0)).test(smartInventory.getItem(0));
    }

    public void readAdditional(JsonObject json) {
        this.speedLimits = json.has("speedLimits") ? json.get("speedLimits").getAsInt() : (json.has("speed_limits") ? json.get("speed_limits").getAsInt() : 0);
        this.fragile = json.has("fragile") ? json.get("fragile").getAsBoolean() : false;
    }

    public void writeAdditional(JsonObject json) {
        json.addProperty("speedLimits", (Number)this.speedLimits);
        json.addProperty("fragile", Boolean.valueOf(this.fragile));
    }

    public void readAdditional(FriendlyByteBuf buffer) {
        this.speedLimits = buffer.readInt();
        this.fragile = buffer.readBoolean();
    }

    public void writeAdditional(FriendlyByteBuf buffer) {
        buffer.writeInt(this.speedLimits);
        buffer.writeBoolean(this.fragile);
    }

    public static class Serializer
    extends StandardProcessingRecipe.Serializer<PolishingRecipe> {
        private final MapCodec<PolishingRecipe> codec = RecordCodecBuilder.mapCodec(instance -> instance.group((App)super.codec().forGetter(r -> r), (App)Codec.INT.optionalFieldOf("speedLimits", (Object)0).forGetter(PolishingRecipe::getSpeedLimits), (App)Codec.BOOL.optionalFieldOf("fragile", (Object)false).forGetter(PolishingRecipe::isFragile)).apply((Applicative)instance, (recipe, speed, isFragile) -> {
            recipe.speedLimits = speed;
            recipe.fragile = isFragile;
            return recipe;
        }));
        private final StreamCodec<RegistryFriendlyByteBuf, PolishingRecipe> streamCodec = StreamCodec.composite((StreamCodec)super.streamCodec(), r -> r, (StreamCodec)ByteBufCodecs.VAR_INT, PolishingRecipe::getSpeedLimits, (StreamCodec)ByteBufCodecs.BOOL, PolishingRecipe::isFragile, (recipe, speed, isFragile) -> {
            recipe.speedLimits = speed;
            recipe.fragile = isFragile;
            return recipe;
        });

        public Serializer(StandardProcessingRecipe.Factory<PolishingRecipe> factory) {
            super(factory);
        }

        public MapCodec<PolishingRecipe> codec() {
            return this.codec;
        }

        public StreamCodec<RegistryFriendlyByteBuf, PolishingRecipe> streamCodec() {
            return this.streamCodec;
        }
    }
}

