/*
 * Decompiled with CFR 0.152.
 */
package dev.bluephs.createvintageneoforged.content.kinetics.grinder;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringRenderer;
import com.simibubi.create.foundation.blockEntity.renderer.SafeBlockEntityRenderer;
import dev.bluephs.createvintageneoforged.content.kinetics.grinder.GrinderBlockEntity;
import dev.bluephs.createvintageneoforged.registry.VintagePartialModels;
import dev.engine_room.flywheel.api.visualization.VisualizationManager;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.createmod.catnip.render.SuperByteBufferCache;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class GrinderRenderer
extends SafeBlockEntityRenderer<GrinderBlockEntity> {
    public GrinderRenderer(BlockEntityRendererProvider.Context context) {
    }

    protected void renderSafe(GrinderBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        this.renderBelt(be, ms, buffer, light);
        this.renderItems(be, partialTicks, ms, buffer, light, overlay);
        FilteringRenderer.renderOnBlockEntity((SmartBlockEntity)be, (float)partialTicks, (PoseStack)ms, (MultiBufferSource)buffer, (int)light, (int)overlay);
        if (VisualizationManager.supportsVisualization((LevelAccessor)be.getLevel())) {
            return;
        }
        this.renderShaft(be, ms, buffer, light, overlay);
    }

    protected void renderBelt(GrinderBlockEntity be, PoseStack ms, MultiBufferSource buffer, int light) {
        PartialModel partial;
        BlockState blockState = be.getBlockState();
        float speed = be.getSpeed();
        if (speed > 0.0f) {
            partial = switch (be.getTextureType()) {
                case 1 -> VintagePartialModels.GRINDER_BELT_ACTIVE_RED;
                case 2 -> VintagePartialModels.GRINDER_BELT_ACTIVE_DIAMOND;
                case 3 -> VintagePartialModels.GRINDER_BELT_ACTIVE_IRON;
                case 4 -> VintagePartialModels.GRINDER_BELT_ACTIVE_OBSIDIAN;
                default -> VintagePartialModels.GRINDER_BELT_ACTIVE;
            };
        } else if (speed < 0.0f) {
            partial = switch (be.getTextureType()) {
                case 1 -> VintagePartialModels.GRINDER_BELT_REVERSED_RED;
                case 2 -> VintagePartialModels.GRINDER_BELT_REVERSED_DIAMOND;
                case 3 -> VintagePartialModels.GRINDER_BELT_REVERSED_IRON;
                case 4 -> VintagePartialModels.GRINDER_BELT_REVERSED_OBSIDIAN;
                default -> VintagePartialModels.GRINDER_BELT_REVERSED;
            };
        } else {
            partial = switch (be.getTextureType()) {
                case 1 -> VintagePartialModels.GRINDER_BELT_INACTIVE_RED;
                case 2 -> VintagePartialModels.GRINDER_BELT_INACTIVE_DIAMOND;
                case 3 -> VintagePartialModels.GRINDER_BELT_INACTIVE_IRON;
                case 4 -> VintagePartialModels.GRINDER_BELT_INACTIVE_OBSIDIAN;
                default -> VintagePartialModels.GRINDER_BELT_INACTIVE;
            };
        }
        SuperByteBuffer superBuffer = (SuperByteBuffer)CachedBuffers.partialFacing((PartialModel)partial, (BlockState)blockState, (Direction)((Direction)blockState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING))).rotateCentered(blockState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING) == Direction.WEST || blockState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING) == Direction.NORTH ? 0.0f : (float)Math.PI, Direction.UP);
        superBuffer.color(0xFFFFFF).light(light).renderInto(ms, buffer.getBuffer(RenderType.cutoutMipped()));
    }

    protected void renderShaft(GrinderBlockEntity be, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        KineticBlockEntityRenderer.renderRotatingBuffer((KineticBlockEntity)be, (SuperByteBuffer)this.getRotatedModel(be), (PoseStack)ms, (VertexConsumer)buffer.getBuffer(RenderType.solid()), (int)light);
    }

    protected void renderItems(GrinderBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        if (!be.inventory.isEmpty()) {
            boolean alongZ = be.getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING) == Direction.NORTH || be.getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING) == Direction.SOUTH;
            ms.pushPose();
            boolean moving = be.inventory.recipeDuration != 0.0f;
            float offset = moving ? be.inventory.remainingTime / be.inventory.recipeDuration : 0.0f;
            float processingSpeed = Mth.clamp((float)(Math.abs(be.getSpeed()) / 32.0f), (float)1.0f, (float)128.0f);
            if (moving) {
                offset = Mth.clamp((float)(offset + (-partialTicks + 0.5f) * processingSpeed / be.inventory.recipeDuration), (float)0.125f, (float)1.0f);
                if (!be.inventory.appliedRecipe) {
                    offset += 1.0f;
                }
                offset /= 2.0f;
            }
            if (be.getSpeed() == 0.0f) {
                offset = 0.5f;
            }
            if (be.getSpeed() < 0.0f ^ alongZ) {
                offset = 1.0f - offset;
            }
            for (int i = 0; i < be.inventory.getSlots(); ++i) {
                ItemStack stack = be.inventory.getStackInSlot(i);
                if (stack.isEmpty()) continue;
                ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
                BakedModel modelWithOverrides = itemRenderer.getModel(stack, be.getLevel(), null, 0);
                boolean blockItem = modelWithOverrides.isGui3d();
                ms.translate(alongZ ? (double)offset : 0.5, blockItem ? (double)0.925f : 0.8125, alongZ ? 0.5 : (double)offset);
                ms.scale(0.5f, 0.5f, 0.5f);
                if (alongZ) {
                    ms.mulPose(Axis.YP.rotationDegrees(90.0f));
                }
                ms.mulPose(Axis.XP.rotationDegrees(90.0f));
                itemRenderer.renderStatic(stack, ItemDisplayContext.FIXED, light, overlay, ms, buffer, be.getLevel(), 0);
                break;
            }
            ms.popPose();
        }
    }

    protected SuperByteBuffer getRotatedModel(KineticBlockEntity be) {
        return CachedBuffers.block((SuperByteBufferCache.Compartment)KineticBlockEntityRenderer.KINETIC_BLOCK, (BlockState)this.getRenderedBlockState(be));
    }

    protected BlockState getRenderedBlockState(KineticBlockEntity be) {
        return KineticBlockEntityRenderer.shaft((Direction.Axis)KineticBlockEntityRenderer.getRotationAxisOf((KineticBlockEntity)be));
    }
}

