/*
 * Decompiled with CFR 0.152.
 */
package dev.bluephs.createvintageneoforged.content.kinetics.grinder;

import com.google.common.collect.ImmutableList;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.equipment.sandPaper.SandPaperItem;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour;
import com.simibubi.create.content.processing.recipe.ProcessingInventory;
import com.simibubi.create.content.processing.sequenced.SequencedAssemblyRecipe;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.recipe.RecipeFinder;
import com.simibubi.create.infrastructure.config.AllConfigs;
import dev.bluephs.createvintageneoforged.content.kinetics.grinder.GrinderFilterSlot;
import dev.bluephs.createvintageneoforged.content.kinetics.grinder.PolishingRecipe;
import dev.bluephs.createvintageneoforged.foundation.recipe.RecipeConditions;
import dev.bluephs.createvintageneoforged.infrastructure.config.VintageConfig;
import dev.bluephs.createvintageneoforged.registry.VintageBlockEntity;
import dev.bluephs.createvintageneoforged.registry.VintageRecipes;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.ParametersAreNonnullByDefault;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.items.IItemHandler;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class GrinderBlockEntity
extends KineticBlockEntity
implements IHaveGoggleInformation {
    private static final Object polishingRecipesKey = new Object();
    public ProcessingInventory inventory;
    private int recipeIndex;
    private FilteringBehaviour filtering;
    private ItemStack playEvent;
    private int textureType;

    public GrinderBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.inventory = new ProcessingInventory(this::start).withSlotLimit((Boolean)AllConfigs.server().recipes.bulkCutting.get() == false);
        this.inventory.remainingTime = -1.0f;
        this.recipeIndex = 0;
        this.playEvent = ItemStack.EMPTY;
        this.textureType = (Integer)VintageConfig.common().defaultBeltGrinderSkin.get();
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)VintageBlockEntity.GRINDER.get(), (be, context) -> be.inventory);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.filtering = new FilteringBehaviour((SmartBlockEntity)this, (ValueBoxTransform)new GrinderFilterSlot()).forRecipes();
        behaviours.add((BlockEntityBehaviour)this.filtering);
        behaviours.add((BlockEntityBehaviour)new DirectBeltInputBehaviour((SmartBlockEntity)this).setInsertionHandler((transportedStack, side, simulate) -> {
            ItemStack stack = transportedStack.stack;
            Direction facing = (Direction)this.getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
            if (side == facing) {
                return stack;
            }
            if (Math.abs(this.getSpeed()) <= 0.0f) {
                return stack;
            }
            if (!this.inventory.isEmpty()) {
                return stack;
            }
            ItemStack remainder = this.inventory.insertItem(0, stack, simulate);
            if (!simulate && remainder.isEmpty()) {
                this.start(stack);
            }
            return remainder;
        }));
        super.addBehaviours(behaviours);
    }

    public void write(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        compound.put("Inventory", (Tag)this.inventory.serializeNBT(registries));
        compound.putInt("RecipeIndex", this.recipeIndex);
        compound.putInt("TextureType", this.textureType);
        super.write(compound, registries, clientPacket);
        if (!clientPacket || this.playEvent.isEmpty()) {
            return;
        }
        compound.put("PlayEvent", this.playEvent.saveOptional(registries));
        this.playEvent = ItemStack.EMPTY;
    }

    protected void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(compound, registries, clientPacket);
        this.inventory.deserializeNBT(registries, compound.getCompound("Inventory"));
        this.recipeIndex = compound.getInt("RecipeIndex");
        this.textureType = compound.getInt("TextureType");
        if (compound.contains("PlayEvent")) {
            this.playEvent = ItemStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)compound.getCompound("PlayEvent"));
        }
    }

    protected AABB createRenderBoundingBox() {
        return new AABB(this.worldPosition).inflate(0.125);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void tickAudio() {
        super.tickAudio();
        if (this.getSpeed() == 0.0f) {
            return;
        }
        if (!this.playEvent.isEmpty()) {
            this.spawnEventParticles(this.playEvent);
            this.playEvent = ItemStack.EMPTY;
            AllSoundEvents.SANDING_SHORT.playAt(this.level, (Vec3i)this.worldPosition, 3.0f, 1.0f, true);
        }
    }

    private void findEntities() {
        if (!this.inventory.isEmpty()) {
            return;
        }
        Vec3 center = VecHelper.getCenterOf((Vec3i)this.worldPosition);
        AABB searchArea = new AABB(center.add(0.0, 0.5, 0.0), center.add(0.0, -0.5, 0.0)).inflate((double)0.45f);
        assert (this.level != null);
        for (ItemEntity itemEntity : this.level.getEntitiesOfClass(ItemEntity.class, searchArea)) {
            this.insertItem(itemEntity);
        }
    }

    public void tick() {
        super.tick();
        assert (this.level != null);
        if (this.getSpeed() == 0.0f) {
            return;
        }
        if (this.inventory.remainingTime == -1.0f) {
            if (!this.inventory.isEmpty() && !this.inventory.appliedRecipe) {
                this.start(this.inventory.getStackInSlot(0));
            }
            return;
        }
        if (this.inventory.isEmpty()) {
            this.findEntities();
        }
        float processingSpeed = Mth.clamp((float)(Math.abs(this.getSpeed()) / 24.0f), (float)1.0f, (float)128.0f);
        this.inventory.remainingTime -= processingSpeed;
        if (this.inventory.remainingTime > 0.0f) {
            this.spawnParticles(this.inventory.getStackInSlot(0));
        }
        if (this.inventory.remainingTime < 5.0f && !this.inventory.appliedRecipe) {
            if (this.level.isClientSide && !this.isVirtual()) {
                return;
            }
            this.playEvent = this.inventory.getStackInSlot(0);
            this.applyRecipe();
            this.inventory.appliedRecipe = true;
            this.inventory.recipeDuration = 20.0f;
            this.inventory.remainingTime = 20.0f;
            this.sendData();
            return;
        }
        Vec3 itemMovement = this.getItemMovementVec();
        Direction itemMovementFacing = Direction.getNearest((double)itemMovement.x, (double)itemMovement.y, (double)itemMovement.z);
        if (this.inventory.remainingTime > 0.0f) {
            return;
        }
        this.inventory.remainingTime = 0.0f;
        for (int slot = 0; slot < this.inventory.getSlots(); ++slot) {
            ItemStack tryExportingToBeltFunnel;
            ItemStack stack = this.inventory.getStackInSlot(slot);
            if (stack.isEmpty() || (tryExportingToBeltFunnel = ((DirectBeltInputBehaviour)this.getBehaviour(DirectBeltInputBehaviour.TYPE)).tryExportingToBeltFunnel(stack, itemMovementFacing.getOpposite(), false)) == null) continue;
            if (tryExportingToBeltFunnel.getCount() != stack.getCount()) {
                this.inventory.setStackInSlot(slot, tryExportingToBeltFunnel);
                this.notifyUpdate();
                return;
            }
            if (tryExportingToBeltFunnel.isEmpty()) continue;
            return;
        }
        BlockPos nextPos = this.worldPosition.offset((Vec3i)BlockPos.containing((Position)itemMovement));
        DirectBeltInputBehaviour behaviour = (DirectBeltInputBehaviour)BlockEntityBehaviour.get((BlockGetter)this.level, (BlockPos)nextPos, (BehaviourType)DirectBeltInputBehaviour.TYPE);
        if (behaviour != null) {
            boolean changed = false;
            if (!behaviour.canInsertFromSide(itemMovementFacing)) {
                return;
            }
            if (this.level.isClientSide && !this.isVirtual()) {
                return;
            }
            for (int slot = 0; slot < this.inventory.getSlots(); ++slot) {
                ItemStack remainder;
                ItemStack stack = this.inventory.getStackInSlot(slot);
                if (stack.isEmpty() || (remainder = behaviour.handleInsertion(stack, itemMovementFacing, false)).equals(stack)) continue;
                this.inventory.setStackInSlot(slot, remainder);
                changed = true;
            }
            if (changed) {
                this.setChanged();
                this.sendData();
            }
            return;
        }
        Vec3 outPos = VecHelper.getCenterOf((Vec3i)this.worldPosition).add(itemMovement.scale(0.5).add(0.0, 0.5, 0.0));
        Vec3 outMotion = itemMovement.scale(0.0625).add(0.0, 0.125, 0.0);
        for (int slot = 0; slot < this.inventory.getSlots(); ++slot) {
            ItemStack stack = this.inventory.getStackInSlot(slot);
            if (stack.isEmpty()) continue;
            ItemEntity entityIn = new ItemEntity(this.level, outPos.x, outPos.y, outPos.z, stack);
            entityIn.setDeltaMovement(outMotion);
            this.level.addFreshEntity((Entity)entityIn);
        }
        this.inventory.clear();
        this.level.updateNeighbourForOutputSignal(this.worldPosition, this.getBlockState().getBlock());
        this.inventory.remainingTime = -1.0f;
        this.setChanged();
        this.sendData();
    }

    public void invalidate() {
        super.invalidate();
        this.invalidateCapabilities();
    }

    public void destroy() {
        super.destroy();
        ItemHelper.dropContents((Level)this.level, (BlockPos)this.worldPosition, (IItemHandler)this.inventory);
    }

    protected void spawnEventParticles(ItemStack stack) {
        if (stack == null || stack.isEmpty()) {
            return;
        }
        Object particleData = null;
        particleData = stack.getItem() instanceof BlockItem ? new BlockParticleOption(ParticleTypes.BLOCK, ((BlockItem)stack.getItem()).getBlock().defaultBlockState()) : new ItemParticleOption(ParticleTypes.ITEM, stack);
        RandomSource r = this.level.random;
        Vec3 v = VecHelper.getCenterOf((Vec3i)this.worldPosition).add(0.0, 0.3125, 0.0);
        for (int i = 0; i < 10; ++i) {
            Vec3 m = VecHelper.offsetRandomly((Vec3)new Vec3(0.0, 0.25, 0.0), (RandomSource)r, (float)0.125f);
            this.level.addParticle((ParticleOptions)particleData, v.x, v.y, v.z, m.x, m.y, m.y);
        }
    }

    protected void spawnParticles(ItemStack stack) {
        if (stack == null || stack.isEmpty()) {
            return;
        }
        ItemParticleOption particleData = null;
        float speed = 1.0f;
        if (stack.getItem() instanceof BlockItem) {
            particleData = new BlockParticleOption(ParticleTypes.BLOCK, ((BlockItem)stack.getItem()).getBlock().defaultBlockState());
        } else {
            particleData = new ItemParticleOption(ParticleTypes.ITEM, stack);
            speed = 0.125f;
        }
        RandomSource r = this.level.random;
        Vec3 vec = this.getItemMovementVec();
        Vec3 pos = VecHelper.getCenterOf((Vec3i)this.worldPosition);
        float offset = this.inventory.recipeDuration != 0.0f ? this.inventory.remainingTime / this.inventory.recipeDuration : 0.0f;
        offset /= 2.0f;
        if (this.inventory.appliedRecipe) {
            offset -= 0.5f;
        }
        this.level.addParticle((ParticleOptions)particleData, pos.x() + -vec.x * (double)offset, pos.y() + (double)0.45f, pos.z() + -vec.z * (double)offset, -vec.x * (double)speed, (double)(r.nextFloat() * speed), -vec.z * (double)speed);
    }

    public Vec3 getItemMovementVec() {
        boolean alongX = this.getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING) == Direction.WEST || this.getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING) == Direction.EAST;
        int offset = this.getSpeed() < 0.0f ? -1 : 1;
        return new Vec3((double)(offset * (alongX ? 0 : 1)), 0.0, (double)(offset * (alongX ? -1 : 0)));
    }

    private void applyRecipe() {
        Recipe recipe;
        List<RecipeHolder<Recipe<?>>> recipes = this.getRecipes();
        if (recipes.isEmpty()) {
            return;
        }
        if (this.recipeIndex >= recipes.size()) {
            this.recipeIndex = 0;
        }
        if ((recipe = recipes.get(this.recipeIndex).value()) instanceof PolishingRecipe) {
            boolean speedRequirementMet;
            PolishingRecipe polishingRecipe = (PolishingRecipe)recipe;
            int rolls = this.inventory.getStackInSlot(0).getCount();
            float currentSpeed = Math.abs(this.getSpeed());
            int reqLevel = polishingRecipe.getSpeedLimits();
            switch (reqLevel) {
                case 1: {
                    boolean bl;
                    if (currentSpeed >= 1.0f && currentSpeed <= 32.0f) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case 2: {
                    boolean bl;
                    if (currentSpeed > 32.0f && currentSpeed <= 128.0f) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case 3: {
                    boolean bl;
                    if (currentSpeed > 128.0f) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                default: {
                    boolean bl = speedRequirementMet = true;
                }
            }
            if (polishingRecipe.isFragile() && !speedRequirementMet) {
                this.inventory.clear();
                if (this.level != null) {
                    this.level.levelEvent(2001, this.worldPosition, Block.getId((BlockState)this.level.getBlockState(this.worldPosition).getBlock().defaultBlockState()));
                    this.level.playSound(null, this.worldPosition, SoundEvents.ITEM_BREAK, SoundSource.BLOCKS, 1.0f, 1.0f);
                    AllSoundEvents.SANDING_SHORT.playAt(this.level, (Vec3i)this.worldPosition, 3.0f, 0.5f, true);
                }
                this.inventory.appliedRecipe = true;
                this.sendData();
                return;
            }
            this.inventory.clear();
            ArrayList list = new ArrayList();
            for (int roll = 0; roll < rolls; ++roll) {
                List results = polishingRecipe.rollResults(this.level.random);
                for (ItemStack stack : results) {
                    ItemHelper.addToList((ItemStack)stack, list);
                }
            }
            for (int slot = 0; slot < list.size() && slot + 1 < this.inventory.getSlots(); ++slot) {
                this.inventory.setStackInSlot(slot + 1, (ItemStack)list.get(slot));
            }
        }
    }

    private List<RecipeHolder<? extends Recipe<?>>> getRecipes() {
        Optional assemblyRecipe = SequencedAssemblyRecipe.getRecipe((Level)this.level, (ItemStack)this.inventory.getStackInSlot(0), VintageRecipes.POLISHING.getType(), PolishingRecipe.class);
        if (assemblyRecipe.isPresent() && this.filtering.test(((PolishingRecipe)((RecipeHolder)assemblyRecipe.get()).value()).getResultItem((HolderLookup.Provider)this.level.registryAccess()))) {
            return ImmutableList.of((Object)((RecipeHolder)assemblyRecipe.get()));
        }
        Predicate<Recipe<?>> types = RecipeConditions.isOfType(VintageRecipes.POLISHING.getType());
        Predicate<RecipeHolder> holderTypes = holder -> types.test(holder.value());
        List startedSearch = RecipeFinder.get((Object)polishingRecipesKey, (Level)this.level, holderTypes);
        List<RecipeHolder> filtered = startedSearch.stream().filter(RecipeConditions.outputMatchesFilter(this.filtering)).filter(RecipeConditions.firstIngredientMatches(this.inventory.getStackInSlot(0))).filter(r -> !VintageRecipes.shouldIgnoreInAutomation(r)).toList();
        ArrayList matchingSpeed = new ArrayList();
        ArrayList wrongSpeed = new ArrayList();
        ArrayList others = new ArrayList();
        float currentSpeed = Math.abs(this.getSpeed());
        for (RecipeHolder holder2 : filtered) {
            Recipe recipe = holder2.value();
            if (recipe instanceof PolishingRecipe) {
                boolean speedRequirementMet;
                PolishingRecipe polishingRecipe = (PolishingRecipe)recipe;
                int reqLevel = polishingRecipe.getSpeedLimits();
                switch (reqLevel) {
                    case 1: {
                        boolean bl;
                        if (currentSpeed >= 1.0f && currentSpeed <= 32.0f) {
                            bl = true;
                            break;
                        }
                        bl = false;
                        break;
                    }
                    case 2: {
                        boolean bl;
                        if (currentSpeed > 32.0f && currentSpeed <= 128.0f) {
                            bl = true;
                            break;
                        }
                        bl = false;
                        break;
                    }
                    case 3: {
                        boolean bl;
                        if (currentSpeed > 128.0f) {
                            bl = true;
                            break;
                        }
                        bl = false;
                        break;
                    }
                    default: {
                        boolean bl = speedRequirementMet = true;
                    }
                }
                if (speedRequirementMet) {
                    matchingSpeed.add(holder2);
                    continue;
                }
                wrongSpeed.add(holder2);
                continue;
            }
            others.add(holder2);
        }
        if (!matchingSpeed.isEmpty()) {
            return matchingSpeed;
        }
        if (!wrongSpeed.isEmpty()) {
            return wrongSpeed;
        }
        return others;
    }

    public void insertItem(ItemEntity entity) {
        if (!this.inventory.isEmpty()) {
            return;
        }
        if (!entity.isAlive()) {
            return;
        }
        if (this.level.isClientSide) {
            return;
        }
        this.inventory.clear();
        ItemStack remainder = this.inventory.insertItem(0, entity.getItem().copy(), false);
        if (remainder.isEmpty()) {
            entity.discard();
        } else {
            entity.setItem(remainder);
        }
    }

    public void start(ItemStack inserted) {
        Recipe recipe;
        if (this.inventory.isEmpty()) {
            return;
        }
        if (this.level.isClientSide && !this.isVirtual()) {
            return;
        }
        List<RecipeHolder<Recipe<?>>> recipes = this.getRecipes();
        boolean valid = !recipes.isEmpty();
        int time = 50;
        if (recipes.isEmpty()) {
            this.inventory.recipeDuration = 10.0f;
            this.inventory.remainingTime = 10.0f;
            this.inventory.appliedRecipe = false;
            this.sendData();
            return;
        }
        if (valid) {
            ++this.recipeIndex;
            if (this.recipeIndex >= recipes.size()) {
                this.recipeIndex = 0;
            }
        }
        if ((recipe = recipes.get(this.recipeIndex).value()) instanceof PolishingRecipe) {
            time = ((PolishingRecipe)recipe).getProcessingDuration();
        }
        this.inventory.recipeDuration = this.inventory.remainingTime = (float)(time * Math.max(1, inserted.getCount() / 5));
        this.inventory.appliedRecipe = false;
        this.sendData();
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        if (this.inventory.isEmpty()) {
            return true;
        }
        List<RecipeHolder<Recipe<?>>> recipes = this.getRecipes();
        if (recipes.isEmpty()) {
            return true;
        }
        Recipe recipe = recipes.get(this.recipeIndex).value();
        if (recipe instanceof PolishingRecipe) {
            PolishingRecipe polishingRecipe = (PolishingRecipe)recipe;
            int reqLevel = polishingRecipe.getSpeedLimits();
            float currentSpeed = Math.abs(this.getSpeed());
            boolean speedRequirementMet = switch (reqLevel) {
                case 1 -> {
                    if (currentSpeed >= 1.0f && currentSpeed <= 32.0f) {
                        yield true;
                    }
                    yield false;
                }
                case 2 -> {
                    if (currentSpeed > 32.0f && currentSpeed <= 128.0f) {
                        yield true;
                    }
                    yield false;
                }
                case 3 -> {
                    if (currentSpeed > 128.0f) {
                        yield true;
                    }
                    yield false;
                }
                default -> true;
            };
            tooltip.add((Component)Component.literal((String)"   "));
            tooltip.add((Component)Component.translatable((String)"createvintageneoforged.recipe.required_speed_level").append((Component)Component.literal((String)(": " + reqLevel))).withStyle(ChatFormatting.GRAY));
            tooltip.add((Component)Component.translatable((String)("createvintageneoforged.recipe.speed_range_" + reqLevel)).withStyle(ChatFormatting.DARK_GRAY));
            if (currentSpeed > 0.0f) {
                if (!speedRequirementMet) {
                    tooltip.add((Component)Component.translatable((String)"createvintageneoforged.recipe.wrong_speed").withStyle(ChatFormatting.RED));
                } else {
                    tooltip.add((Component)Component.translatable((String)"createvintageneoforged.recipe.speed_ok").withStyle(ChatFormatting.GREEN));
                }
            }
        }
        return true;
    }

    public int getTextureType() {
        return this.textureType;
    }

    public boolean addTexture(ItemStack items) {
        if (items.isEmpty()) {
            return false;
        }
        if (!(items.getItem() instanceof SandPaperItem)) {
            return false;
        }
        return switch (items.getItem().getDescriptionId()) {
            case "item.create.sand_paper" -> {
                this.textureType = 0;
                yield true;
            }
            case "item.create.red_sand_paper" -> {
                this.textureType = 1;
                yield true;
            }
            case "item.createaddition.diamond_grit_sandpaper", "item.create_so.diamond_sandpaper" -> {
                this.textureType = 2;
                yield true;
            }
            case "item.create_so.iron_sandpaper" -> {
                this.textureType = 3;
                yield true;
            }
            case "item.create_so.obsidian_sandpaper" -> {
                this.textureType = 4;
                yield true;
            }
            default -> false;
        };
    }
}

