/*
 * Decompiled with CFR 0.152.
 */
package dev.bluephs.createvintageneoforged.content.kinetics.curving_press;

import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.simibubi.create.compat.jei.category.sequencedAssembly.SequencedAssemblySubCategory;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeParams;
import com.simibubi.create.content.processing.recipe.StandardProcessingRecipe;
import com.simibubi.create.content.processing.sequenced.IAssemblyRecipe;
import com.simibubi.create.foundation.recipe.IRecipeTypeInfo;
import dev.bluephs.createvintageneoforged.content.equipment.CurvingHeadItem;
import dev.bluephs.createvintageneoforged.registry.VintageBlocks;
import dev.bluephs.createvintageneoforged.registry.VintageItems;
import dev.bluephs.createvintageneoforged.registry.VintageLang;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.items.wrapper.RecipeWrapper;

@ParametersAreNonnullByDefault
public class CurvingRecipe
extends StandardProcessingRecipe<RecipeWrapper>
implements IAssemblyRecipe {
    int headDamage = 1;
    int requiredBonks = 1;
    private static final StreamCodec<RegistryFriendlyByteBuf, ItemStack> ITEM_STACK_CODEC = ItemStack.OPTIONAL_STREAM_CODEC;
    private ResourceLocation id;

    public CurvingRecipe(IRecipeTypeInfo type, ProcessingRecipeParams params) {
        super(type, params);
    }

    public int getHeadDamage() {
        return this.headDamage;
    }

    public int getCorrespondingMode() {
        ResourceLocation typeId = BuiltInRegistries.RECIPE_TYPE.getKey((Object)this.getType());
        if (typeId == null) {
            return 1;
        }
        String path = typeId.getPath();
        if (path.contains("concave")) {
            return 2;
        }
        if (path.contains("w_shaped")) {
            return 3;
        }
        if (path.contains("v_shaped")) {
            return 4;
        }
        return 1;
    }

    public boolean matches(RecipeWrapper inv, Level worldIn) {
        if (inv.isEmpty()) {
            return false;
        }
        return ((Ingredient)this.ingredients.get(0)).test(inv.getItem(0));
    }

    protected int getMaxInputCount() {
        return 1;
    }

    protected int getMaxOutputCount() {
        return 2;
    }

    public int getRequiredBonks() {
        return this.requiredBonks;
    }

    public void addAssemblyIngredients(List<Ingredient> list) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public Component getDescriptionForAssembly() {
        MutableComponent result = VintageLang.translateDirect("recipe.assembly.curving", new Object[0]);
        result.append(" ").append((Component)VintageLang.translateDirect("recipe.assembly.with_head", new Object[0])).append(" ");
        int mode = this.getCorrespondingMode();
        switch (mode) {
            case 2: {
                result.append((Component)Component.translatable((String)((CurvingHeadItem)((Object)VintageItems.CONCAVE_CURVING_HEAD.get())).getDescriptionId()));
                break;
            }
            case 3: {
                result.append((Component)Component.translatable((String)((CurvingHeadItem)((Object)VintageItems.W_SHAPED_CURVING_HEAD.get())).getDescriptionId()));
                break;
            }
            case 4: {
                result.append((Component)Component.translatable((String)((CurvingHeadItem)((Object)VintageItems.V_SHAPED_CURVING_HEAD.get())).getDescriptionId()));
                break;
            }
            default: {
                result.append((Component)Component.translatable((String)((CurvingHeadItem)((Object)VintageItems.CONVEX_CURVING_HEAD.get())).getDescriptionId()));
            }
        }
        return result;
    }

    public void addRequiredMachines(Set<ItemLike> list) {
        list.add((ItemLike)VintageBlocks.CURVING_PRESS.get());
    }

    public Supplier<Supplier<SequencedAssemblySubCategory>> getJEISubCategory() {
        return null;
    }

    public void readAdditional(JsonObject json) {
        this.headDamage = json.has("headDamage") ? json.get("headDamage").getAsInt() : 1;
    }

    public void readAdditional(FriendlyByteBuf buffer) {
        this.headDamage = buffer.readInt();
    }

    public void writeAdditional(JsonObject json) {
        if (this.headDamage >= 0) {
            json.addProperty("headDamage", (Number)this.headDamage);
        }
    }

    public void writeAdditional(FriendlyByteBuf buffer) {
        buffer.writeInt(this.headDamage);
    }

    public ResourceLocation id() {
        return this.id;
    }

    public static class Serializer
    extends StandardProcessingRecipe.Serializer<CurvingRecipe> {
        private final MapCodec<CurvingRecipe> codec = RecordCodecBuilder.mapCodec(instance -> instance.group((App)super.codec().forGetter(r -> r), (App)Codec.INT.optionalFieldOf("headDamage", (Object)1).forGetter(CurvingRecipe::getHeadDamage), (App)Codec.INT.optionalFieldOf("requiredBonks", (Object)1).forGetter(CurvingRecipe::getRequiredBonks)).apply((Applicative)instance, (recipe, damage, bonks) -> {
            recipe.headDamage = damage;
            recipe.requiredBonks = bonks;
            return recipe;
        }));
        private final StreamCodec<RegistryFriendlyByteBuf, CurvingRecipe> streamCodec = StreamCodec.composite((StreamCodec)super.streamCodec(), r -> r, (StreamCodec)ByteBufCodecs.VAR_INT, CurvingRecipe::getHeadDamage, (StreamCodec)ByteBufCodecs.VAR_INT, CurvingRecipe::getRequiredBonks, (recipe, damage, bonks) -> {
            recipe.headDamage = damage;
            recipe.requiredBonks = bonks;
            return recipe;
        });

        public Serializer(IRecipeTypeInfo type, StandardProcessingRecipe.Factory<CurvingRecipe> factory) {
            super(factory);
        }

        public MapCodec<CurvingRecipe> codec() {
            return this.codec;
        }

        public StreamCodec<RegistryFriendlyByteBuf, CurvingRecipe> streamCodec() {
            return this.streamCodec;
        }
    }
}

