/*
 * Decompiled with CFR 0.152.
 */
package dev.bluephs.createvintageneoforged.content.kinetics.curving_press;

import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.belt.transport.TransportedItemStack;
import com.simibubi.create.foundation.blockEntity.SyncedBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.item.SmartInventory;
import com.simibubi.create.foundation.recipe.RecipeApplier;
import dev.bluephs.createvintageneoforged.content.equipment.CurvingHeadItem;
import dev.bluephs.createvintageneoforged.content.kinetics.curving_press.CurvingBehaviour;
import dev.bluephs.createvintageneoforged.content.kinetics.curving_press.CurvingRecipe;
import dev.bluephs.createvintageneoforged.registry.VintageItems;
import dev.bluephs.createvintageneoforged.registry.VintageLang;
import dev.bluephs.createvintageneoforged.registry.VintageRecipes;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.wrapper.RecipeWrapper;

public class CurvingPressBlockEntity
extends KineticBlockEntity
implements CurvingBehaviour.CurvingBehaviourSpecifics {
    private static final Object curvingRecipesKey = new Object();
    public int mode = 0;
    public SmartInventory itemAsHead = new SmartInventory(1, (SyncedBlockEntity)this);
    public int durability = 0;
    public CurvingBehaviour pressingBehaviour;
    private static final ItemStackHandler pressingInvHandler = new ItemStackHandler(1);
    private static final RecipeWrapper pressingInv = new RecipeWrapper((IItemHandler)pressingInvHandler);

    public CurvingPressBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    private Item getHeadItemForMode(int mode) {
        return switch (mode) {
            case 2 -> (CurvingHeadItem)((Object)VintageItems.CONCAVE_CURVING_HEAD.get());
            case 3 -> (CurvingHeadItem)((Object)VintageItems.W_SHAPED_CURVING_HEAD.get());
            case 4 -> (CurvingHeadItem)((Object)VintageItems.V_SHAPED_CURVING_HEAD.get());
            default -> (CurvingHeadItem)((Object)VintageItems.CONVEX_CURVING_HEAD.get());
        };
    }

    public void applyDamage(CurvingRecipe recipe) {
        int recipeDamage = recipe.getHeadDamage();
        if (recipeDamage <= 0) {
            return;
        }
        if (this.mode >= 1 && this.mode <= 4) {
            this.durability -= recipeDamage;
            if (this.durability <= 0) {
                this.mode = 0;
            }
        } else if (this.mode == 5) {
            ItemStack headStack = this.itemAsHead.getItem(0);
            if (headStack.isEmpty()) {
                return;
            }
            if (headStack.isDamageableItem()) {
                int newDamage = headStack.getDamageValue() + recipeDamage;
                headStack.setDamageValue(newDamage);
                this.durability = newDamage;
                if (newDamage >= headStack.getMaxDamage()) {
                    this.itemAsHead.clearContent();
                    this.mode = 0;
                }
            } else {
                this.itemAsHead.clearContent();
                this.mode = 0;
            }
        }
        this.setChanged();
        this.sendData();
    }

    protected AABB createRenderBoundingBox() {
        return new AABB(this.worldPosition).expandTowards(0.0, -1.5, 0.0).expandTowards(0.0, 1.0, 0.0);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.pressingBehaviour = new CurvingBehaviour(this);
        behaviours.add((BlockEntityBehaviour)this.pressingBehaviour);
    }

    public void onItemPressed(ItemStack result, int damage) {
        if (damage < 0) {
            damage = 0;
        }
        if (damage > 0) {
            ItemStack headStack;
            if (this.mode < 5 && this.mode > 0) {
                this.durability -= damage;
                if (this.durability <= 0) {
                    this.mode = 0;
                }
            }
            if (this.mode == 5 && !(headStack = this.itemAsHead.getItem(0)).isEmpty() && headStack.isDamageableItem()) {
                headStack.hurtAndBreak(damage, (ServerLevel)this.level, null, stack -> {});
                if (headStack.getDamageValue() >= headStack.getMaxDamage()) {
                    this.itemAsHead.getItem(0).shrink(1);
                    this.mode = 0;
                }
            }
        }
        this.setChanged();
        this.sendData();
    }

    public void destroy() {
        super.destroy();
        if (this.mode > 0) {
            SmartInventory headInv = new SmartInventory(1, (SyncedBlockEntity)this);
            if (this.mode < 5) {
                ItemStack stack = switch (this.mode) {
                    case 2 -> new ItemStack((ItemLike)VintageItems.CONCAVE_CURVING_HEAD.get());
                    case 3 -> new ItemStack((ItemLike)VintageItems.W_SHAPED_CURVING_HEAD.get());
                    case 4 -> new ItemStack((ItemLike)VintageItems.V_SHAPED_CURVING_HEAD.get());
                    default -> new ItemStack((ItemLike)VintageItems.CONVEX_CURVING_HEAD.get());
                };
                stack.setDamageValue(stack.getMaxDamage() - this.durability);
                ItemHandlerHelper.insertItemStacked((IItemHandler)headInv, (ItemStack)stack, (boolean)false);
            } else if (!this.itemAsHead.isEmpty()) {
                ItemHandlerHelper.insertItemStacked((IItemHandler)headInv, (ItemStack)this.itemAsHead.getItem(0), (boolean)false);
            } else {
                ItemHandlerHelper.insertItemStacked((IItemHandler)headInv, (ItemStack)ItemStack.EMPTY, (boolean)false);
            }
            ItemHelper.dropContents((Level)this.level, (BlockPos)this.worldPosition, (IItemHandler)headInv);
        }
    }

    public CurvingBehaviour getPressingBehaviour() {
        return this.pressingBehaviour;
    }

    protected void write(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        compound.putInt("HeadMode", this.mode);
        compound.putInt("Durability", this.durability);
        if (!this.itemAsHead.isEmpty()) {
            compound.put("ItemAsHead", (Tag)this.itemAsHead.serializeNBT(registries));
        }
        super.write(compound, registries, clientPacket);
    }

    protected void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        this.mode = compound.getInt("HeadMode");
        this.durability = compound.getInt("Durability");
        if (compound.contains("ItemAsHead")) {
            this.itemAsHead.deserializeNBT(registries, compound.getCompound("ItemAsHead"));
            if (this.itemAsHead.getItem(0).isDamageableItem()) {
                this.itemAsHead.getItem(0).setDamageValue(this.durability);
            }
        } else {
            this.itemAsHead.clearContent();
        }
        super.read(compound, registries, clientPacket);
    }

    public static boolean canCurve(Recipe recipe) {
        return CurvingPressBlockEntity.canCurve(recipe, 1);
    }

    public static boolean canCurve(Recipe recipe, int mode) {
        if (!(recipe instanceof CraftingRecipe)) {
            return false;
        }
        if (mode == 1 || mode == 2) {
            ItemStack item = null;
            NonNullList in = recipe.getIngredients();
            if (((Ingredient)in.get(mode - 1)).isEmpty()) {
                return false;
            }
            int matches = 0;
            boolean it = mode == 2;
            for (Ingredient i : in) {
                boolean bl = it = !it;
                if (it) {
                    if (!i.isEmpty()) {
                        if (item == null) {
                            item = i.getItems()[0];
                        }
                    } else {
                        return false;
                    }
                    if (i.test(item)) {
                        ++matches;
                        continue;
                    }
                }
                if (i.isEmpty()) continue;
                return false;
            }
            return matches == 3;
        }
        if (mode == 3 || mode == 4) {
            ItemStack item = null;
            NonNullList in = recipe.getIngredients();
            if (mode == 4) {
                if (((Ingredient)in.get(2)).isEmpty() || ((Ingredient)in.get(3)).isEmpty()) {
                    return false;
                }
                int matches = 0;
                int empty = 0;
                for (Ingredient i : in) {
                    if (!i.isEmpty()) {
                        if (item == null) {
                            if (i.getItems().length <= 0) {
                                return false;
                            }
                            item = i.getItems()[0];
                        }
                        if (i.test(item)) {
                            ++matches;
                            continue;
                        }
                        return false;
                    }
                    if (++empty <= 1) continue;
                    return false;
                }
                return matches == 3 && empty == 1;
            }
            if (!((Ingredient)in.get(2)).isEmpty() && !((Ingredient)in.get(3)).isEmpty()) {
                return false;
            }
            int matches = 0;
            int empty = 0;
            for (Ingredient i : in) {
                if (!i.isEmpty()) {
                    if (item == null) {
                        if (i.getItems().length <= 0) {
                            return false;
                        }
                        item = i.getItems()[0];
                    }
                    if (i.test(item)) {
                        ++matches;
                        continue;
                    }
                    return false;
                }
                if (++empty <= 1) continue;
                return false;
            }
            return matches == 3 && empty == 1;
        }
        return false;
    }

    @Override
    public boolean tryProcessInWorld(ItemEntity itemEntity, boolean simulate) {
        ItemStack item = itemEntity.getItem();
        Optional<CurvingRecipe> recipe = this.getRecipe(item);
        if (recipe.isEmpty() || this.mode <= 0) {
            return false;
        }
        if (recipe.get().getCorrespondingMode() != this.mode) {
            return false;
        }
        if (simulate) {
            return true;
        }
        this.pressingBehaviour.start(CurvingBehaviour.Mode.WORLD, recipe.get().getRequiredBonks());
        return true;
    }

    @Override
    public boolean tryProcessOnBelt(TransportedItemStack input, List<ItemStack> outputList, boolean simulate) {
        Optional<CurvingRecipe> recipe = this.getRecipe(input.stack);
        if (recipe.isEmpty() || this.mode <= 0) {
            return false;
        }
        if (recipe.get().getCorrespondingMode() != this.mode) {
            return false;
        }
        if (simulate) {
            return true;
        }
        if (!this.isHeadStillValidOrAbort(recipe.get())) {
            return false;
        }
        this.pressingBehaviour.start(CurvingBehaviour.Mode.BELT, recipe.get().getRequiredBonks());
        return true;
    }

    public void applyDamageAfterProcess(int damage) {
        ItemStack headStack;
        if (damage <= 0 || this.level == null || this.level.isClientSide) {
            return;
        }
        if (this.mode >= 1 && this.mode <= 4) {
            this.durability -= damage;
            if (this.durability <= 0) {
                this.mode = 0;
            }
        } else if (this.mode == 5 && !(headStack = this.itemAsHead.getItem(0)).isEmpty()) {
            if (headStack.isDamageableItem()) {
                headStack.setDamageValue(headStack.getDamageValue() + damage);
                if (headStack.getDamageValue() >= headStack.getMaxDamage()) {
                    this.itemAsHead.clearContent();
                    this.mode = 0;
                }
            } else {
                headStack.shrink(1);
                if (headStack.isEmpty()) {
                    this.mode = 0;
                }
            }
        }
        this.setChanged();
        this.sendData();
    }

    public void applyFinishedRecipe(CurvingBehaviour behaviour) {
        if (this.level == null || this.level.isClientSide || behaviour.mode != CurvingBehaviour.Mode.WORLD) {
            return;
        }
        BlockPos targetPos = this.worldPosition.below(1);
        for (ItemEntity itemEntity : this.level.getEntitiesOfClass(ItemEntity.class, new AABB(targetPos).deflate(0.125))) {
            if (!itemEntity.isAlive() || !itemEntity.onGround()) continue;
            ItemStack stack = itemEntity.getItem();
            this.getRecipe(stack).ifPresent(recipe -> {
                List results = RecipeApplier.applyRecipeOn((Level)this.level, (ItemStack)stack.copyWithCount(1), (Recipe)recipe, (boolean)true);
                for (ItemStack res : results) {
                    ItemEntity created = new ItemEntity(this.level, itemEntity.getX(), itemEntity.getY(), itemEntity.getZ(), res);
                    this.level.addFreshEntity((Entity)created);
                }
                stack.shrink(1);
                if (stack.isEmpty()) {
                    itemEntity.discard();
                }
                this.applyDamageAfterProcess(recipe.getHeadDamage());
            });
            break;
        }
    }

    public Optional<CurvingRecipe> getRecipe(ItemStack item) {
        Level level = this.level;
        if (level == null || this.mode <= 0) {
            return Optional.empty();
        }
        RecipeType recipeType = switch (this.mode) {
            case 2 -> VintageRecipes.CURVING_CONCAVE.getType();
            case 3 -> VintageRecipes.CURVING_W_SHAPED.getType();
            case 4 -> VintageRecipes.CURVING_V_SHAPED.getType();
            default -> VintageRecipes.CURVING_CONVEX.getType();
        };
        pressingInvHandler.setStackInSlot(0, item.copy());
        return level.getRecipeManager().getRecipeFor(recipeType, (RecipeInput)pressingInv, level).map(RecipeHolder::value);
    }

    @Override
    public float getKineticSpeed() {
        return this.getSpeed();
    }

    @Override
    public boolean canProcessInBulk() {
        return false;
    }

    @Override
    public int getParticleAmount() {
        return 15;
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        Item headItem;
        int maxDamage;
        super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        if (this.pressingBehaviour.running) {
            VintageLang.translate("gui.goggles.curving_progress", new Object[0]).add(Component.literal((String)(": " + this.pressingBehaviour.bonksDone + " / " + this.pressingBehaviour.bonksRequired)).withStyle(ChatFormatting.AQUA)).forGoggles(tooltip);
        }
        if (this.mode <= 0 || this.mode > 5) {
            return true;
        }
        switch (this.mode) {
            case 2: {
                VintageLang.translate("gui.goggles.curving_head", new Object[0]).add(Component.translatable((String)((CurvingHeadItem)((Object)VintageItems.CONCAVE_CURVING_HEAD.get())).getDescriptionId()).withStyle(ChatFormatting.BLUE)).forGoggles(tooltip);
                break;
            }
            case 3: {
                VintageLang.translate("gui.goggles.curving_head", new Object[0]).add(Component.translatable((String)((CurvingHeadItem)((Object)VintageItems.W_SHAPED_CURVING_HEAD.get())).getDescriptionId()).withStyle(ChatFormatting.DARK_GREEN)).forGoggles(tooltip);
                break;
            }
            case 4: {
                VintageLang.translate("gui.goggles.curving_head", new Object[0]).add(Component.translatable((String)((CurvingHeadItem)((Object)VintageItems.V_SHAPED_CURVING_HEAD.get())).getDescriptionId()).withStyle(ChatFormatting.YELLOW)).forGoggles(tooltip);
                break;
            }
            case 5: {
                if (this.itemAsHead.isEmpty()) break;
                VintageLang.translate("gui.goggles.curving_head", new Object[0]).add(Component.translatable((String)this.itemAsHead.getItem(0).getDescriptionId()).withStyle(ChatFormatting.LIGHT_PURPLE)).forGoggles(tooltip);
                break;
            }
            default: {
                VintageLang.translate("gui.goggles.curving_head", new Object[0]).add(Component.translatable((String)((CurvingHeadItem)((Object)VintageItems.CONVEX_CURVING_HEAD.get())).getDescriptionId()).withStyle(ChatFormatting.GREEN)).forGoggles(tooltip);
            }
        }
        if (this.mode == 5) {
            ItemStack headStack = this.itemAsHead.getItem(0);
            if (!headStack.isEmpty()) {
                if (headStack.isDamageableItem()) {
                    int currentDamage = headStack.getDamageValue();
                    int maxDamage2 = headStack.getMaxDamage();
                    VintageLang.translate("gui.goggles.durability", new Object[0]).add(Component.literal((String)(": " + (maxDamage2 - currentDamage) + "/" + maxDamage2))).forGoggles(tooltip);
                } else {
                    VintageLang.translate("gui.goggles.curving_head_consumable", new Object[0]).color(0xFF5555).forGoggles(tooltip);
                }
            }
        } else if (this.mode > 0 && (maxDamage = (headItem = this.getHeadItemForMode(this.mode)).getDefaultInstance().getMaxDamage()) > 0) {
            VintageLang.translate("gui.goggles.durability", new Object[0]).add(Component.literal((String)(": " + this.durability + "/" + maxDamage))).forGoggles(tooltip);
        }
        return true;
    }

    private boolean isHeadStillValidOrAbort(CurvingRecipe recipe) {
        if (this.mode <= 0) {
            return false;
        }
        return recipe.getCorrespondingMode() == this.mode;
    }
}

