/*
 * Decompiled with CFR 0.152.
 */
package dev.bluephs.createvintageneoforged.content.kinetics.curving_press;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.AllShapes;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.kinetics.base.HorizontalKineticBlock;
import com.simibubi.create.foundation.block.IBE;
import dev.bluephs.createvintageneoforged.content.kinetics.curving_press.CurvingPressBlockEntity;
import dev.bluephs.createvintageneoforged.registry.VintageBlockEntity;
import dev.bluephs.createvintageneoforged.registry.VintageItems;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CurvingPressBlock
extends HorizontalKineticBlock
implements IBE<CurvingPressBlockEntity> {
    public static final TagKey<Item> headTag = ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"createvintageneoforged", (String)"curving_heads"));

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.setPlacedBy(level, pos, state, placer, stack);
    }

    public CurvingPressBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        if (context instanceof EntityCollisionContext && ((EntityCollisionContext)context).getEntity() instanceof Player) {
            return AllShapes.CASING_14PX.get(Direction.DOWN);
        }
        return AllShapes.MECHANICAL_PROCESSOR_SHAPE;
    }

    public boolean canSurvive(BlockState state, LevelReader worldIn, BlockPos pos) {
        return !AllBlocks.BASIN.has(worldIn.getBlockState(pos.below()));
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction prefferedSide = this.getPreferredHorizontalFacing(context);
        if (prefferedSide != null) {
            return (BlockState)this.defaultBlockState().setValue(HORIZONTAL_FACING, (Comparable)prefferedSide);
        }
        return super.getStateForPlacement(context);
    }

    public Direction.Axis getRotationAxis(BlockState state) {
        return ((Direction)state.getValue(HORIZONTAL_FACING)).getAxis();
    }

    public boolean hasShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction face) {
        return face.getAxis() == ((Direction)state.getValue(HORIZONTAL_FACING)).getAxis();
    }

    public Class<CurvingPressBlockEntity> getBlockEntityClass() {
        return CurvingPressBlockEntity.class;
    }

    public BlockEntityType<? extends CurvingPressBlockEntity> getBlockEntityType() {
        return (BlockEntityType)VintageBlockEntity.CURVING_PRESS.get();
    }

    public boolean isPathfindable(BlockState state, BlockGetter reader, BlockPos pos, PathComputationType type) {
        return false;
    }

    public ItemInteractionResult useItemOn(ItemStack heldItem, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        InteractionResult result = this.onBlockEntityUse((BlockGetter)level, pos, be -> {
            if (be.mode == 0) {
                if (heldItem.is((Item)VintageItems.CONVEX_CURVING_HEAD.get())) {
                    be.mode = 1;
                } else if (heldItem.is((Item)VintageItems.CONCAVE_CURVING_HEAD.get())) {
                    be.mode = 2;
                } else if (heldItem.is((Item)VintageItems.W_SHAPED_CURVING_HEAD.get())) {
                    be.mode = 3;
                } else if (heldItem.is((Item)VintageItems.V_SHAPED_CURVING_HEAD.get())) {
                    be.mode = 4;
                }
                if (be.mode > 0) {
                    be.durability = heldItem.getMaxDamage() - heldItem.getDamageValue();
                    if (!player.isCreative()) {
                        heldItem.shrink(1);
                    }
                    if (level.isClientSide()) {
                        AllSoundEvents.WRENCH_ROTATE.playAt(level, (Vec3i)pos, 3.0f, 1.0f, true);
                    }
                    be.setChanged();
                    return InteractionResult.SUCCESS;
                }
            } else if (heldItem.is(AllItems.WRENCH.asItem())) {
                Item headItem;
                switch (be.mode) {
                    case 2: {
                        headItem = (Item)VintageItems.CONCAVE_CURVING_HEAD.get();
                        break;
                    }
                    case 3: {
                        headItem = (Item)VintageItems.W_SHAPED_CURVING_HEAD.get();
                        break;
                    }
                    case 4: {
                        headItem = (Item)VintageItems.V_SHAPED_CURVING_HEAD.get();
                        break;
                    }
                    case 5: {
                        ItemStack stack = be.itemAsHead != null ? be.itemAsHead.getItem(0).copy() : ItemStack.EMPTY;
                        be.itemAsHead.clearContent();
                        player.getInventory().placeItemBackInInventory(stack);
                        be.mode = 0;
                        if (level.isClientSide()) {
                            AllSoundEvents.WRENCH_ROTATE.playAt(level, (Vec3i)pos, 3.0f, 1.0f, true);
                        }
                        be.setChanged();
                        return InteractionResult.SUCCESS;
                    }
                    default: {
                        headItem = (Item)VintageItems.CONVEX_CURVING_HEAD.get();
                    }
                }
                ItemStack stack = new ItemStack((ItemLike)headItem);
                stack.setDamageValue(stack.getMaxDamage() - be.durability);
                player.getInventory().placeItemBackInInventory(stack);
                be.mode = 0;
                if (level.isClientSide()) {
                    AllSoundEvents.WRENCH_ROTATE.playAt(level, (Vec3i)pos, 3.0f, 1.0f, true);
                }
                be.setChanged();
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        });
        return switch (result) {
            case InteractionResult.SUCCESS -> ItemInteractionResult.sidedSuccess((boolean)level.isClientSide());
            case InteractionResult.CONSUME -> ItemInteractionResult.CONSUME;
            case InteractionResult.FAIL -> ItemInteractionResult.FAIL;
            default -> ItemInteractionResult.SKIP_DEFAULT_BLOCK_INTERACTION;
        };
    }
}

