/*
 * Decompiled with CFR 0.152.
 */
package dev.bluephs.createvintageneoforged.content.kinetics.curving_press;

import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.kinetics.belt.behaviour.BeltProcessingBehaviour;
import com.simibubi.create.content.kinetics.belt.transport.TransportedItemStack;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import dev.bluephs.createvintageneoforged.content.kinetics.curving_press.BeltCurvingCallbacks;
import dev.bluephs.createvintageneoforged.content.kinetics.curving_press.CurvingPressBlockEntity;
import java.util.ArrayList;
import java.util.List;
import net.createmod.catnip.math.VecHelper;
import net.createmod.catnip.nbt.NBTHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class CurvingBehaviour
extends BeltProcessingBehaviour {
    public static final int CYCLE = 240;
    public static final int ENTITY_SCAN = 10;
    public List<ItemStack> particleItems = new ArrayList<ItemStack>();
    public CurvingBehaviourSpecifics specifics;
    public float prevRunningTicks;
    public float runningTicks;
    public boolean running;
    public boolean finished;
    public Mode mode;
    int entityScanCooldown;
    public int bonksDone;
    public int bonksRequired;

    public <T extends SmartBlockEntity> CurvingBehaviour(T be) {
        super(be);
        this.specifics = (CurvingBehaviourSpecifics)be;
        this.mode = Mode.WORLD;
        this.entityScanCooldown = 10;
        this.bonksRequired = 1;
        this.bonksDone = 0;
        this.whenItemEnters((s, i) -> BeltCurvingCallbacks.onItemReceived(s, i, this));
        this.whileItemHeld((s, i) -> BeltCurvingCallbacks.whenItemHeld(s, i, this));
    }

    public void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        this.running = compound.getBoolean("Running");
        this.mode = Mode.values()[compound.getInt("Mode")];
        this.finished = compound.getBoolean("Finished");
        this.prevRunningTicks = this.runningTicks = compound.getFloat("Ticks");
        this.bonksDone = compound.getInt("BonksDone");
        this.bonksRequired = compound.getInt("BonksRequired");
        super.read(compound, registries, clientPacket);
        if (clientPacket) {
            NBTHelper.iterateCompoundList((ListTag)compound.getList("ParticleItems", 10), c -> this.particleItems.add(ItemStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)c)));
            this.spawnParticles();
        }
    }

    public void write(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        compound.putBoolean("Running", this.running);
        compound.putInt("Mode", this.mode.ordinal());
        compound.putBoolean("Finished", this.finished);
        compound.putFloat("Ticks", this.runningTicks);
        compound.putInt("BonksDone", this.bonksDone);
        compound.putInt("BonksRequired", this.bonksRequired);
        super.write(compound, registries, clientPacket);
        if (clientPacket) {
            compound.put("ParticleItems", (Tag)NBTHelper.writeCompoundList(this.particleItems, s -> (CompoundTag)s.save(registries)));
            this.particleItems.clear();
        }
    }

    public float getRenderedHeadOffset(float partialTicks) {
        if (!this.running && !this.finished) {
            return 0.0f;
        }
        float interpedTicks = Mth.lerp((float)partialTicks, (float)this.prevRunningTicks, (float)this.runningTicks);
        float progress = interpedTicks % 240.0f / 240.0f;
        float sin = Mth.sin((float)(progress * (float)Math.PI));
        return Math.max(0.0f, sin);
    }

    public void start(Mode mode, int requiredBonks) {
        this.running = true;
        this.finished = false;
        this.mode = mode;
        this.runningTicks = 0.0f;
        this.bonksDone = 0;
        this.bonksRequired = requiredBonks;
        this.blockEntity.sendData();
    }

    public void tick() {
        super.tick();
        Level level = this.getWorld();
        if (level == null) {
            return;
        }
        this.prevRunningTicks = this.runningTicks;
        if (!this.running) {
            if (this.finished) {
                if (this.runningTicks % 240.0f != 0.0f) {
                    float speed = Math.max(Math.abs(this.specifics.getKineticSpeed()) / 32.0f, 1.0f);
                    this.runningTicks += speed;
                    if (this.prevRunningTicks % 240.0f > this.runningTicks % 240.0f) {
                        this.runningTicks = 0.0f;
                        this.prevRunningTicks = 0.0f;
                    }
                }
            } else if (level.isClientSide) {
                this.runningTicks = 0.0f;
                this.prevRunningTicks = 0.0f;
            }
            return;
        }
        float speed = Math.abs(this.specifics.getKineticSpeed());
        if (speed == 0.0f) {
            if (!level.isClientSide) {
                this.running = false;
                this.blockEntity.sendData();
            }
            return;
        }
        float progress = Math.max(1.0f, speed / 32.0f);
        this.runningTicks += progress;
        if (this.prevRunningTicks % 240.0f < 120.0f && this.runningTicks % 240.0f >= 120.0f) {
            if (level.isClientSide) {
                SmartBlockEntity smartBlockEntity = this.blockEntity;
                if (smartBlockEntity instanceof CurvingPressBlockEntity) {
                    CurvingPressBlockEntity press = (CurvingPressBlockEntity)smartBlockEntity;
                    press.getRecipe(this.particleItems.isEmpty() ? ItemStack.EMPTY : this.particleItems.get(0)).ifPresent(recipe -> this.spawnParticles());
                }
            } else {
                ++this.bonksDone;
                level.playSound(null, this.getPos(), SoundType.STONE.getHitSound(), SoundSource.BLOCKS, 0.5f, 0.8f);
                level.playSound(null, this.getPos(), AllSoundEvents.MECHANICAL_PRESS_ACTIVATION.getMainEvent(), SoundSource.BLOCKS, 0.2f, 1.1f);
                if (this.bonksDone >= this.bonksRequired) {
                    SmartBlockEntity smartBlockEntity;
                    this.running = false;
                    this.finished = true;
                    if (this.mode == Mode.WORLD && (smartBlockEntity = this.blockEntity) instanceof CurvingPressBlockEntity) {
                        CurvingPressBlockEntity press = (CurvingPressBlockEntity)smartBlockEntity;
                        press.applyFinishedRecipe(this);
                    }
                    this.blockEntity.sendData();
                } else {
                    this.blockEntity.sendData();
                }
            }
        }
    }

    protected void applyInWorld() {
        Level level = this.getWorld();
        BlockPos worldPosition = this.getPos();
        AABB bb = new AABB(worldPosition.below(1));
        boolean bulk = this.specifics.canProcessInBulk();
        if (level.isClientSide) {
            return;
        }
        for (Entity entity : level.getEntities(null, bb)) {
            if (!(entity instanceof ItemEntity)) continue;
            ItemEntity itemEntity = (ItemEntity)entity;
            if (!entity.isAlive() || !entity.onGround()) continue;
            if (this.specifics.tryProcessInWorld(itemEntity, false)) {
                this.blockEntity.sendData();
            }
            if (bulk) continue;
            break;
        }
    }

    public int getRunningTickSpeed() {
        float speed = this.specifics.getKineticSpeed();
        if (speed == 0.0f) {
            return 0;
        }
        return (int)Mth.lerp((float)Mth.clamp((float)(Math.abs(speed) / 512.0f), (float)0.0f, (float)1.0f), (float)1.0f, (float)60.0f);
    }

    protected void spawnParticles() {
        if (this.particleItems.isEmpty()) {
            return;
        }
        BlockPos worldPosition = this.getPos();
        if (this.mode == Mode.BASIN) {
            this.particleItems.forEach(stack -> this.makeCompactingParticleEffect(VecHelper.getCenterOf((Vec3i)worldPosition.below(2)), (ItemStack)stack));
        }
        if (this.mode == Mode.BELT) {
            this.particleItems.forEach(stack -> this.makePressingParticleEffect(VecHelper.getCenterOf((Vec3i)worldPosition.below(2)).add(0.0, 0.5, 0.0), (ItemStack)stack));
        }
        if (this.mode == Mode.WORLD) {
            this.particleItems.forEach(stack -> this.makePressingParticleEffect(VecHelper.getCenterOf((Vec3i)worldPosition.below(1)).add(0.0, -0.25, 0.0), (ItemStack)stack));
        }
        this.particleItems.clear();
    }

    public void makePressingParticleEffect(Vec3 pos, ItemStack stack) {
        this.makePressingParticleEffect(pos, stack, this.specifics.getParticleAmount());
    }

    public void makePressingParticleEffect(Vec3 pos, ItemStack stack, int amount) {
        Level level = this.getWorld();
        if (level == null || !level.isClientSide) {
            return;
        }
        for (int i = 0; i < amount; ++i) {
            Vec3 motion = VecHelper.offsetRandomly((Vec3)Vec3.ZERO, (RandomSource)level.random, (float)0.125f).multiply(1.0, 0.0, 1.0);
            motion = motion.add(0.0, amount != 1 ? 0.125 : 0.0625, 0.0);
            level.addParticle((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, stack), pos.x, pos.y - 0.25, pos.z, motion.x, motion.y, motion.z);
        }
    }

    public void makeCompactingParticleEffect(Vec3 pos, ItemStack stack) {
        Level level = this.getWorld();
        if (level == null || !level.isClientSide) {
            return;
        }
        for (int i = 0; i < 20; ++i) {
            Vec3 motion = VecHelper.offsetRandomly((Vec3)Vec3.ZERO, (RandomSource)level.random, (float)0.175f).multiply(1.0, 0.0, 1.0);
            level.addParticle((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, stack), pos.x, pos.y, pos.z, motion.x, motion.y + 0.25, motion.z);
        }
    }

    public static interface CurvingBehaviourSpecifics {
        public boolean tryProcessOnBelt(TransportedItemStack var1, List<ItemStack> var2, boolean var3);

        public boolean tryProcessInWorld(ItemEntity var1, boolean var2);

        public boolean canProcessInBulk();

        public int getParticleAmount();

        public float getKineticSpeed();
    }

    public static enum Mode {
        WORLD(1.0f),
        BELT(1.1875f),
        BASIN(1.375f);

        public float headOffset;

        private Mode(float headOffset) {
            this.headOffset = headOffset;
        }
    }
}

