/*
 * Decompiled with CFR 0.152.
 */
package dev.bluephs.createvintageneoforged.content.kinetics.curving_press;

import com.simibubi.create.content.kinetics.belt.behaviour.BeltProcessingBehaviour;
import com.simibubi.create.content.kinetics.belt.behaviour.TransportedItemStackHandlerBehaviour;
import com.simibubi.create.content.kinetics.belt.transport.TransportedItemStack;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.recipe.RecipeApplier;
import dev.bluephs.createvintageneoforged.content.kinetics.curving_press.CurvingBehaviour;
import dev.bluephs.createvintageneoforged.content.kinetics.curving_press.CurvingPressBlockEntity;
import dev.bluephs.createvintageneoforged.content.kinetics.curving_press.CurvingRecipe;
import java.util.List;
import java.util.Optional;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;

public class BeltCurvingCallbacks {
    static BeltProcessingBehaviour.ProcessingResult onItemReceived(TransportedItemStack transported, TransportedItemStackHandlerBehaviour handler, CurvingBehaviour behaviour) {
        if (behaviour.specifics.getKineticSpeed() == 0.0f) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        if (behaviour.running) {
            return BeltProcessingBehaviour.ProcessingResult.HOLD;
        }
        SmartBlockEntity smartBlockEntity = behaviour.blockEntity;
        if (smartBlockEntity instanceof CurvingPressBlockEntity) {
            CurvingPressBlockEntity press = (CurvingPressBlockEntity)smartBlockEntity;
            Optional<CurvingRecipe> recipe = press.getRecipe(transported.stack);
            if (recipe.isEmpty()) {
                return BeltProcessingBehaviour.ProcessingResult.PASS;
            }
            behaviour.start(CurvingBehaviour.Mode.BELT, recipe.get().getRequiredBonks());
            return BeltProcessingBehaviour.ProcessingResult.HOLD;
        }
        return BeltProcessingBehaviour.ProcessingResult.PASS;
    }

    static BeltProcessingBehaviour.ProcessingResult whenItemHeld(TransportedItemStack transported, TransportedItemStackHandlerBehaviour handler, CurvingBehaviour behaviour) {
        CurvingPressBlockEntity press;
        Optional<CurvingRecipe> recipeOpt;
        if (behaviour.specifics.getKineticSpeed() == 0.0f) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        if (!behaviour.running && !behaviour.finished) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        if (!behaviour.finished) {
            return BeltProcessingBehaviour.ProcessingResult.HOLD;
        }
        SmartBlockEntity smartBlockEntity = behaviour.blockEntity;
        if (smartBlockEntity instanceof CurvingPressBlockEntity && (recipeOpt = (press = (CurvingPressBlockEntity)smartBlockEntity).getRecipe(transported.stack)).isPresent()) {
            CurvingRecipe recipe = recipeOpt.get();
            List results = RecipeApplier.applyRecipeOn((Level)press.getLevel(), (ItemStack)transported.stack.copyWithCount(1), (Recipe)recipe, (boolean)true);
            List<TransportedItemStack> transportedResults = results.stream().map(stack -> {
                TransportedItemStack copy = transported.copy();
                copy.stack = stack;
                return copy;
            }).toList();
            TransportedItemStack left = transported.copy();
            left.stack.shrink(1);
            if (left.stack.isEmpty()) {
                handler.handleProcessingOnItem(transported, TransportedItemStackHandlerBehaviour.TransportedResult.convertTo(transportedResults));
            } else {
                handler.handleProcessingOnItem(transported, TransportedItemStackHandlerBehaviour.TransportedResult.convertToAndLeaveHeld(transportedResults, (TransportedItemStack)left));
            }
            press.applyDamageAfterProcess(recipe.getHeadDamage());
            behaviour.finished = false;
            return BeltProcessingBehaviour.ProcessingResult.HOLD;
        }
        return BeltProcessingBehaviour.ProcessingResult.PASS;
    }
}

