/*
 * Decompiled with CFR 0.152.
 */
package dev.bluephs.createvintageneoforged.compat.jei.categories;

import com.simibubi.create.compat.jei.category.CreateRecipeCategory;
import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import dev.bluephs.createvintageneoforged.compat.jei.animated.AnimatedGrinder;
import dev.bluephs.createvintageneoforged.content.kinetics.grinder.PolishingRecipe;
import dev.bluephs.createvintageneoforged.foundation.gui.VintageGuiTextures;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.crafting.Ingredient;

public class PolishingRecipeCategory
extends CreateRecipeCategory<PolishingRecipe> {
    private final AnimatedGrinder grinder = new AnimatedGrinder();

    public PolishingRecipeCategory(CreateRecipeCategory.Info<PolishingRecipe> info) {
        super(info);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, PolishingRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 44, 5).setBackground(PolishingRecipeCategory.getRenderedSlot(), -1, -1).addIngredients((Ingredient)recipe.getIngredients().get(0));
        List results = recipe.getRollableResults();
        int i = 0;
        for (ProcessingOutput output : results) {
            int xOffset = i % 2 == 0 ? 0 : 19;
            int yOffset = i / 2 * -19;
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 118 + xOffset, 48 + yOffset).setBackground(PolishingRecipeCategory.getRenderedSlot((ProcessingOutput)output), -1, -1).addItemStack(output.getStack())).addRichTooltipCallback(PolishingRecipeCategory.addStochasticTooltip((ProcessingOutput)output));
            ++i;
        }
    }

    public void draw(PolishingRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics gui, double mouseX, double mouseY) {
        AllGuiTextures.JEI_DOWN_ARROW.render(gui, 70, 6);
        AllGuiTextures.JEI_SHADOW.render(gui, 55, 55);
        this.grinder.draw(gui, 72, 42);
        int speedLimits = recipe.getSpeedLimits();
        switch (speedLimits) {
            case 1: {
                gui.drawCenteredString(Minecraft.getInstance().font, (Component)Component.translatable((String)"createvintageneoforged.jei.text.required_speed").append(" ").append((Component)Component.translatable((String)"createvintageneoforged.jei.text.low")), 88, 75, 65280);
                break;
            }
            case 2: {
                gui.drawCenteredString(Minecraft.getInstance().font, (Component)Component.translatable((String)"createvintageneoforged.jei.text.required_speed").append(" ").append((Component)Component.translatable((String)"createvintageneoforged.jei.text.medium")), 88, 75, 0xFFFF00);
                break;
            }
            case 3: {
                gui.drawCenteredString(Minecraft.getInstance().font, (Component)Component.translatable((String)"createvintageneoforged.jei.text.required_speed").append(" ").append((Component)Component.translatable((String)"createvintageneoforged.jei.text.high")), 88, 75, 0xFF0000);
                break;
            }
            default: {
                gui.drawCenteredString(Minecraft.getInstance().font, (Component)Component.translatable((String)"createvintageneoforged.jei.text.required_speed").append(" ").append((Component)Component.translatable((String)"createvintageneoforged.jei.text.any")), 88, 75, 0xFFFFFF);
            }
        }
        if (recipe.isFragile()) {
            VintageGuiTextures.JEI_FRAGILE.render(gui, 2, 62);
        }
    }

    public List<Component> getTooltipStrings(PolishingRecipe recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        ArrayList<Component> tooltips = new ArrayList<Component>();
        if (recipe.isFragile() && mouseX >= 2.0 && mouseX <= 15.0 && mouseY >= 62.0 && mouseY <= 85.0) {
            tooltips.add((Component)Component.translatable((String)"createvintageneoforged.jei.text.fragile"));
        }
        if (mouseX >= 50.0 && mouseX <= 120.0 && mouseY >= 70.0 && mouseY <= 85.0) {
            tooltips.add((Component)Component.translatable((String)("vintageneo.recipe.speed_range_" + recipe.getSpeedLimits())));
        }
        return tooltips;
    }
}

