/*
 * Decompiled with CFR 0.152.
 */
package dev.bluephs.createvintageneoforged.compat.jei.categories;

import com.simibubi.create.compat.jei.category.CreateRecipeCategory;
import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.item.ItemHelper;
import dev.bluephs.createvintageneoforged.compat.jei.animated.AnimatedCurvingPress;
import dev.bluephs.createvintageneoforged.content.kinetics.curving_press.CurvingRecipe;
import dev.bluephs.createvintageneoforged.registry.VintageItems;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.createmod.catnip.data.Pair;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.apache.commons.lang3.mutable.MutableInt;

@ParametersAreNonnullByDefault
public class CurvingCategory
extends CreateRecipeCategory<CurvingRecipe> {
    private final AnimatedCurvingPress press = new AnimatedCurvingPress();

    public CurvingCategory(CreateRecipeCategory.Info<CurvingRecipe> info) {
        super(info);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, CurvingRecipe recipe, IFocusGroup focuses) {
        ItemStack headStack = ItemStack.EMPTY;
        int mode = recipe.getCorrespondingMode();
        switch (mode) {
            case 2: {
                headStack = new ItemStack((ItemLike)VintageItems.CONCAVE_CURVING_HEAD.get());
                break;
            }
            case 3: {
                headStack = new ItemStack((ItemLike)VintageItems.W_SHAPED_CURVING_HEAD.get());
                break;
            }
            case 4: {
                headStack = new ItemStack((ItemLike)VintageItems.V_SHAPED_CURVING_HEAD.get());
                break;
            }
            default: {
                headStack = new ItemStack((ItemLike)VintageItems.CONVEX_CURVING_HEAD.get());
            }
        }
        builder.addSlot(RecipeIngredientRole.CATALYST, 4, 28).setBackground(CurvingCategory.getRenderedSlot(), -1, -1).addItemStack(headStack);
        List condensedIngredients = ItemHelper.condenseIngredients((NonNullList)recipe.getIngredients());
        Iterator iterator = condensedIngredients.iterator();
        if (iterator.hasNext()) {
            Pair pair = (Pair)iterator.next();
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            for (ItemStack itemStack : ((Ingredient)pair.getFirst()).getItems()) {
                ItemStack copy = itemStack.copy();
                copy.setCount(((MutableInt)pair.getSecond()).getValue().intValue());
                stacks.add(copy);
            }
            builder.addSlot(RecipeIngredientRole.INPUT, 27, 51).setBackground(CurvingCategory.getRenderedSlot(), -1, -1).addItemStacks(stacks);
        }
        List results = recipe.getRollableResults();
        int i = 0;
        for (ProcessingOutput output : results) {
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 131 + 19 * i, 50).setBackground(CurvingCategory.getRenderedSlot((ProcessingOutput)output), -1, -1).addItemStack(output.getStack())).addRichTooltipCallback(CurvingCategory.addStochasticTooltip((ProcessingOutput)output));
            ++i;
        }
    }

    public void draw(CurvingRecipe recipe, IRecipeSlotsView iRecipeSlotsView, GuiGraphics graphics, double mouseX, double mouseY) {
        int bonks;
        AllGuiTextures.JEI_SHADOW.render(graphics, 61, 41);
        AllGuiTextures.JEI_LONG_ARROW.render(graphics, 52, 54);
        AllGuiTextures.JEI_DOWN_ARROW.render(graphics, 23, 32);
        this.press.draw(graphics, this.getBackground().getWidth() / 2 - 17, 30, recipe.getCorrespondingMode());
        int textY = 65;
        int textX = 88;
        if (recipe.getHeadDamage() != 0) {
            graphics.drawCenteredString(Minecraft.getInstance().font, (Component)Component.translatable((String)"createvintageneoforged.jei.text.curving_head_damage").append(": " + recipe.getHeadDamage()), textX, textY, -7829368);
            textY += 10;
        }
        String bonkText = bonks + ((bonks = recipe.getRequiredBonks()) == 1 ? "x Bonk" : "x Bonks");
        graphics.drawCenteredString(Minecraft.getInstance().font, (Component)Component.literal((String)bonkText).withStyle(ChatFormatting.ITALIC), textX, textY, -12276993);
    }
}

