/*
 * Decompiled with CFR 0.152.
 */
package dev.bluephs.createvintageneoforged.compat.jei.animated;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.simibubi.create.compat.jei.category.animations.AnimatedKinetics;
import dev.bluephs.createvintageneoforged.registry.VintageBlocks;
import dev.bluephs.createvintageneoforged.registry.VintagePartialModels;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.Direction;

public class AnimatedCurvingPress
extends AnimatedKinetics {
    public void draw(GuiGraphics graphics, int xOffset, int yOffset, int mode) {
        this.draw(graphics, xOffset, yOffset);
        PoseStack matrixStack = graphics.pose();
        matrixStack.pushPose();
        matrixStack.translate((float)xOffset, (float)yOffset, 200.0f);
        matrixStack.mulPose(Axis.XP.rotationDegrees(-15.5f));
        matrixStack.mulPose(Axis.YP.rotationDegrees(22.5f));
        int scale = 24;
        switch (mode) {
            case 2: {
                this.blockElement(VintagePartialModels.CURVING_HEAD_2).atLocal(0.0, (double)(-this.getAnimatedHeadOffset()), 0.0).scale((double)scale).render(graphics);
                break;
            }
            case 3: {
                this.blockElement(VintagePartialModels.CURVING_HEAD_3).atLocal(0.0, (double)(-this.getAnimatedHeadOffset()), 0.0).scale((double)scale).render(graphics);
                break;
            }
            case 4: {
                this.blockElement(VintagePartialModels.CURVING_HEAD_4).atLocal(0.0, (double)(-this.getAnimatedHeadOffset()), 0.0).scale((double)scale).render(graphics);
                break;
            }
            case 5: {
                this.blockElement(VintagePartialModels.CURVING_HEAD_5).atLocal(0.0, (double)(-this.getAnimatedHeadOffset()), 0.0).scale((double)scale).render(graphics);
                break;
            }
            default: {
                this.blockElement(VintagePartialModels.CURVING_HEAD).atLocal(0.0, (double)(-this.getAnimatedHeadOffset()), 0.0).scale((double)scale).render(graphics);
            }
        }
        matrixStack.popPose();
    }

    public void draw(GuiGraphics graphics, int xOffset, int yOffset) {
        PoseStack matrixStack = graphics.pose();
        matrixStack.pushPose();
        matrixStack.translate((float)xOffset, (float)yOffset, 200.0f);
        matrixStack.mulPose(Axis.XP.rotationDegrees(-15.5f));
        matrixStack.mulPose(Axis.YP.rotationDegrees(22.5f));
        int scale = 24;
        this.blockElement(this.shaft(Direction.Axis.Z)).rotateBlock(0.0, 0.0, (double)AnimatedCurvingPress.getCurrentAngle()).scale((double)scale).render(graphics);
        this.blockElement(VintageBlocks.CURVING_PRESS.getDefaultState()).scale((double)scale).render(graphics);
        this.blockElement(VintagePartialModels.CURVING_POLE).atLocal(0.0, (double)(-this.getAnimatedHeadOffset()), 0.0).scale((double)scale).render(graphics);
        matrixStack.popPose();
    }

    private float getAnimatedHeadOffset() {
        float cycle = (AnimationTickHolder.getRenderTime() - (float)(this.offset * 8)) % 30.0f;
        if (cycle < 10.0f) {
            float progress = cycle / 10.0f;
            return -(progress * progress * progress);
        }
        if (cycle < 15.0f) {
            return -1.0f;
        }
        if (cycle < 20.0f) {
            return -1.0f + (1.0f - (20.0f - cycle) / 5.0f);
        }
        return 0.0f;
    }
}

