/*
 * Decompiled with CFR 0.152.
 */
package dev.bluephs.createvintageneoforged.compat.jei;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.compat.jei.CreateJEI;
import com.simibubi.create.compat.jei.DoubleItemIcon;
import com.simibubi.create.compat.jei.EmptyBackground;
import com.simibubi.create.compat.jei.ItemIcon;
import com.simibubi.create.compat.jei.SlotMover;
import com.simibubi.create.compat.jei.category.CreateRecipeCategory;
import com.simibubi.create.content.processing.basin.BasinRecipe;
import com.simibubi.create.foundation.gui.menu.AbstractSimiContainerScreen;
import com.simibubi.create.foundation.recipe.IRecipeTypeInfo;
import dev.bluephs.createvintageneoforged.CreateVintageneoForged;
import dev.bluephs.createvintageneoforged.compat.jei.categories.CentrifugationCategory;
import dev.bluephs.createvintageneoforged.compat.jei.categories.CoilingCategory;
import dev.bluephs.createvintageneoforged.compat.jei.categories.CurvingCategory;
import dev.bluephs.createvintageneoforged.compat.jei.categories.LaserCuttingCategory;
import dev.bluephs.createvintageneoforged.compat.jei.categories.LeavesVibratingCategory;
import dev.bluephs.createvintageneoforged.compat.jei.categories.PolishingRecipeCategory;
import dev.bluephs.createvintageneoforged.compat.jei.categories.PressurizingCategory;
import dev.bluephs.createvintageneoforged.compat.jei.categories.VacuumizingCategory;
import dev.bluephs.createvintageneoforged.compat.jei.categories.VibratingCategory;
import dev.bluephs.createvintageneoforged.content.kinetics.centrifuge.CentrifugationRecipe;
import dev.bluephs.createvintageneoforged.content.kinetics.coiling.CoilingRecipe;
import dev.bluephs.createvintageneoforged.content.kinetics.curving_press.CurvingRecipe;
import dev.bluephs.createvintageneoforged.content.kinetics.grinder.PolishingRecipe;
import dev.bluephs.createvintageneoforged.content.kinetics.laser_cutting.LaserCuttingRecipe;
import dev.bluephs.createvintageneoforged.content.kinetics.vacuum_chamber.PressurizingRecipe;
import dev.bluephs.createvintageneoforged.content.kinetics.vacuum_chamber.VacuumizingRecipe;
import dev.bluephs.createvintageneoforged.content.kinetics.vibration.LeavesVibratingRecipe;
import dev.bluephs.createvintageneoforged.content.kinetics.vibration.VibratingRecipe;
import dev.bluephs.createvintageneoforged.infrastructure.config.VCRecipes;
import dev.bluephs.createvintageneoforged.infrastructure.config.VintageConfig;
import dev.bluephs.createvintageneoforged.registry.VintageBlocks;
import dev.bluephs.createvintageneoforged.registry.VintageRecipes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.runtime.IIngredientManager;
import net.createmod.catnip.config.ConfigBase;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;

@JeiPlugin
public class VGJEI
implements IModPlugin {
    private static final ResourceLocation ID = CreateVintageneoForged.asResource("jei_plugin");
    public IIngredientManager ingredientManager;
    private final List<CreateRecipeCategory<?>> allCategories = new ArrayList();

    public ResourceLocation getPluginUid() {
        return ID;
    }

    public void loadCategories() {
        this.allCategories.clear();
        CreateRecipeCategory<PolishingRecipe> polishing = this.builder(PolishingRecipe.class).addTypedRecipes(VintageRecipes.POLISHING::getType).catalyst(() -> VintageBlocks.BELT_GRINDER.get()).itemIcon((ItemLike)VintageBlocks.BELT_GRINDER.get()).emptyBackground(177, 85).build("polishing", (CreateRecipeCategory.Factory<PolishingRecipe>)((CreateRecipeCategory.Factory)PolishingRecipeCategory::new));
        CreateRecipeCategory<CoilingRecipe> coiling = this.builder(CoilingRecipe.class).addTypedRecipes(VintageRecipes.COILING::getType).catalyst(() -> VintageBlocks.COILING_BLOCK.get()).itemIcon((ItemLike)VintageBlocks.COILING_BLOCK.get()).emptyBackground(177, 70).build("coiling", (CreateRecipeCategory.Factory<CoilingRecipe>)((CreateRecipeCategory.Factory)CoilingCategory::new));
        CreateRecipeCategory<VacuumizingRecipe> vacuumizing = this.builder(VacuumizingRecipe.class).addTypedRecipes(VintageRecipes.VACUUMIZING::getType).catalyst(() -> VintageBlocks.VACUUM_CHAMBER.get()).itemIcon((ItemLike)VintageBlocks.VACUUM_CHAMBER.get()).doubleItemIcon((ItemLike)VintageBlocks.VACUUM_CHAMBER.get(), (ItemLike)AllBlocks.BASIN.get()).emptyBackground(177, 70).build("vacuumizing", (CreateRecipeCategory.Factory<VacuumizingRecipe>)((CreateRecipeCategory.Factory)VacuumizingCategory::new));
        CreateRecipeCategory<PressurizingRecipe> pressurizing = this.builder(PressurizingRecipe.class).addTypedRecipes(VintageRecipes.PRESSURIZING::getType).catalyst(() -> VintageBlocks.VACUUM_CHAMBER.get()).itemIcon((ItemLike)VintageBlocks.VACUUM_CHAMBER.get()).doubleItemIcon((ItemLike)VintageBlocks.VACUUM_CHAMBER.get(), (ItemLike)AllBlocks.BASIN.get()).emptyBackground(177, 70).build("pressurizing", (CreateRecipeCategory.Factory<PressurizingRecipe>)((CreateRecipeCategory.Factory)PressurizingCategory::new));
        CreateRecipeCategory<VibratingRecipe> vibrating = this.builder(VibratingRecipe.class).addTypedRecipes(VintageRecipes.VIBRATING::getType).catalyst(() -> VintageBlocks.VIBRATING_TABLE.get()).itemIcon((ItemLike)VintageBlocks.VIBRATING_TABLE.get()).emptyBackground(177, 70).build("vibrating", (CreateRecipeCategory.Factory<VibratingRecipe>)((CreateRecipeCategory.Factory)VibratingCategory::new));
        CreateRecipeCategory<CentrifugationRecipe> centrifugation = this.builder(CentrifugationRecipe.class).addTypedRecipes(VintageRecipes.CENTRIFUGATION::getType).catalyst(() -> VintageBlocks.CENTRIFUGE.get()).itemIcon((ItemLike)VintageBlocks.CENTRIFUGE.get()).emptyBackground(177, 70).build("centrifugating", (CreateRecipeCategory.Factory<CentrifugationRecipe>)((CreateRecipeCategory.Factory)info -> CentrifugationCategory.standard((CreateRecipeCategory.Info<BasinRecipe>)info)));
        CreateRecipeCategory<LeavesVibratingRecipe> leaves_vibrating = this.builder(LeavesVibratingRecipe.class).enableWhen(c -> c.allowVibratingLeaves).addTypedRecipes(VintageRecipes.LEAVES_VIBRATING::getType).catalyst(() -> VintageBlocks.VIBRATING_TABLE.get()).doubleItemIcon((ItemLike)VintageBlocks.VIBRATING_TABLE.get(), (ItemLike)Blocks.OAK_LEAVES).emptyBackground(177, 70).build("leaves_vibrating", (CreateRecipeCategory.Factory<LeavesVibratingRecipe>)((CreateRecipeCategory.Factory)LeavesVibratingCategory::new));
        CreateRecipeCategory<CurvingRecipe> curving_convex = this.builder(CurvingRecipe.class).addTypedRecipes(VintageRecipes.CURVING_CONVEX::getType).catalyst(() -> VintageBlocks.CURVING_PRESS.get()).itemIcon((ItemLike)VintageBlocks.CURVING_PRESS.get()).emptyBackground(177, 85).build("curving_convex", (CreateRecipeCategory.Factory<CurvingRecipe>)((CreateRecipeCategory.Factory)CurvingCategory::new));
        CreateRecipeCategory<CurvingRecipe> curving_concave = this.builder(CurvingRecipe.class).addTypedRecipes(VintageRecipes.CURVING_CONCAVE::getType).catalyst(() -> VintageBlocks.CURVING_PRESS.get()).itemIcon((ItemLike)VintageBlocks.CURVING_PRESS.get()).emptyBackground(177, 85).build("curving_concave", (CreateRecipeCategory.Factory<CurvingRecipe>)((CreateRecipeCategory.Factory)CurvingCategory::new));
        CreateRecipeCategory<CurvingRecipe> curving_w_shaped = this.builder(CurvingRecipe.class).addTypedRecipes(VintageRecipes.CURVING_W_SHAPED::getType).catalyst(() -> VintageBlocks.CURVING_PRESS.get()).itemIcon((ItemLike)VintageBlocks.CURVING_PRESS.get()).emptyBackground(177, 85).build("curving_w_shaped", (CreateRecipeCategory.Factory<CurvingRecipe>)((CreateRecipeCategory.Factory)CurvingCategory::new));
        CreateRecipeCategory<CurvingRecipe> curving_v_shaped = this.builder(CurvingRecipe.class).addTypedRecipes(VintageRecipes.CURVING_V_SHAPED::getType).catalyst(() -> VintageBlocks.CURVING_PRESS.get()).itemIcon((ItemLike)VintageBlocks.CURVING_PRESS.get()).emptyBackground(177, 85).build("curving_v_shaped", (CreateRecipeCategory.Factory<CurvingRecipe>)((CreateRecipeCategory.Factory)CurvingCategory::new));
        CreateRecipeCategory<LaserCuttingRecipe> laser_cutting = this.builder(LaserCuttingRecipe.class).addTypedRecipes(VintageRecipes.LASER_CUTTING::getType).catalyst(() -> VintageBlocks.LASER.get()).itemIcon((ItemLike)VintageBlocks.LASER.get()).emptyBackground(177, 85).build("laser_cutting", (CreateRecipeCategory.Factory<LaserCuttingRecipe>)((CreateRecipeCategory.Factory)LaserCuttingCategory::new));
    }

    private <T extends Recipe<?>> CategoryBuilder<T> builder(Class<? extends T> recipeClass) {
        return new CategoryBuilder<T>(recipeClass);
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        this.loadCategories();
        registration.addRecipeCategories((IRecipeCategory[])this.allCategories.toArray(IRecipeCategory[]::new));
    }

    public void registerRecipes(IRecipeRegistration registration) {
        this.ingredientManager = registration.getIngredientManager();
        this.allCategories.forEach(c -> c.registerRecipes(registration));
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        this.allCategories.forEach(c -> c.registerCatalysts(registration));
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addGenericGuiContainerHandler(AbstractSimiContainerScreen.class, (IGuiContainerHandler)new SlotMover());
    }

    private class CategoryBuilder<T extends Recipe<?>> {
        private final Class<? extends T> recipeClass;
        private Predicate<VCRecipes> predicate = cRecipes -> true;
        private IDrawable background;
        private IDrawable icon;
        private final List<Consumer<List<RecipeHolder<T>>>> recipeListConsumers = new ArrayList<Consumer<List<RecipeHolder<T>>>>();
        private final List<Supplier<? extends ItemStack>> catalysts = new ArrayList<Supplier<? extends ItemStack>>();

        public CategoryBuilder(Class<? extends T> recipeClass) {
            this.recipeClass = recipeClass;
        }

        public CategoryBuilder<T> addRecipeListConsumer(Consumer<List<RecipeHolder<T>>> consumer) {
            this.recipeListConsumers.add(consumer);
            return this;
        }

        public CategoryBuilder<T> enableWhen(Function<VCRecipes, ConfigBase.ConfigBool> configValue) {
            this.predicate = c -> (Boolean)((ConfigBase.ConfigBool)configValue.apply((VCRecipes)((Object)c))).get();
            return this;
        }

        public CategoryBuilder<T> addTypedRecipes(IRecipeTypeInfo recipeTypeEntry) {
            return this.addTypedRecipes(() -> ((IRecipeTypeInfo)recipeTypeEntry).getType());
        }

        public <I extends RecipeInput, R extends Recipe<I>> CategoryBuilder<T> addTypedRecipes(Supplier<net.minecraft.world.item.crafting.RecipeType<R>> recipeType) {
            return this.addRecipeListConsumer(recipes -> CreateJEI.consumeTypedRecipes(recipe -> {
                if (this.recipeClass.isInstance(recipe.value())) {
                    recipes.add(recipe);
                }
            }, (net.minecraft.world.item.crafting.RecipeType)((net.minecraft.world.item.crafting.RecipeType)recipeType.get())));
        }

        public CategoryBuilder<T> catalystStack(Supplier<ItemStack> supplier) {
            this.catalysts.add(supplier);
            return this;
        }

        public CategoryBuilder<T> catalyst(Supplier<ItemLike> supplier) {
            return this.catalystStack(() -> new ItemStack((ItemLike)((ItemLike)supplier.get()).asItem()));
        }

        public CategoryBuilder<T> icon(IDrawable icon) {
            this.icon = icon;
            return this;
        }

        public CategoryBuilder<T> itemIcon(ItemLike item) {
            this.icon((IDrawable)new ItemIcon(() -> new ItemStack(item)));
            return this;
        }

        public CategoryBuilder<T> doubleItemIcon(ItemLike item1, ItemLike item2) {
            this.icon((IDrawable)new DoubleItemIcon(() -> new ItemStack(item1), () -> new ItemStack(item2)));
            return this;
        }

        public CategoryBuilder<T> background(IDrawable background) {
            this.background = background;
            return this;
        }

        public CategoryBuilder<T> emptyBackground(int width, int height) {
            this.background((IDrawable)new EmptyBackground(width, height));
            return this;
        }

        public CategoryBuilder<T> addAllRecipesIf(Predicate<RecipeHolder<?>> predicate) {
            return this.addRecipeListConsumer(recipes -> CreateJEI.consumeTypedRecipes(holder -> {
                if (!this.recipeClass.isInstance(holder.value())) {
                    return;
                }
                if (predicate.test((RecipeHolder<?>)holder)) {
                    recipes.add(holder);
                }
            }, (net.minecraft.world.item.crafting.RecipeType)net.minecraft.world.item.crafting.RecipeType.CRAFTING));
        }

        public CreateRecipeCategory<T> build(String name, CreateRecipeCategory.Factory<T> factory) {
            Supplier<List> recipesSupplier = this.predicate.test(VintageConfig.server().recipes) ? () -> {
                ArrayList recipes = new ArrayList();
                for (Consumer consumer : this.recipeListConsumers) {
                    consumer.accept(recipes);
                }
                return recipes;
            } : Collections::emptyList;
            CreateRecipeCategory.Info info = new CreateRecipeCategory.Info(RecipeType.createRecipeHolderType((ResourceLocation)CreateVintageneoForged.rl(name)), (Component)Component.translatable((String)("createvintageneoforged.recipe." + name)), this.background, this.icon, recipesSupplier, this.catalysts);
            CreateRecipeCategory category = factory.create(info);
            VGJEI.this.allCategories.add(category);
            return category;
        }
    }
}

