/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.script;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Either;
import dev.latvian.mods.kubejs.KubeJS;
import dev.latvian.mods.kubejs.holder.HolderWrapper;
import dev.latvian.mods.kubejs.plugin.KubeJSPlugin;
import dev.latvian.mods.kubejs.plugin.KubeJSPlugins;
import dev.latvian.mods.kubejs.registry.RegistryType;
import dev.latvian.mods.kubejs.script.BindingRegistry;
import dev.latvian.mods.kubejs.script.ConsoleJS;
import dev.latvian.mods.kubejs.script.KubeJSContextFactory;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.kubejs.util.ID;
import dev.latvian.mods.kubejs.util.JsonUtils;
import dev.latvian.mods.kubejs.util.RegistryAccessContainer;
import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.ContextFactory;
import dev.latvian.mods.rhino.NativeJavaClass;
import dev.latvian.mods.rhino.Scriptable;
import dev.latvian.mods.rhino.Undefined;
import dev.latvian.mods.rhino.type.TypeInfo;
import dev.latvian.mods.rhino.util.ClassVisibilityContext;
import java.lang.reflect.AccessibleObject;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import org.jetbrains.annotations.Nullable;

public class KubeJSContext
extends Context {
    public final KubeJSContextFactory kjsFactory;
    public final Scriptable topLevelScope;
    private Map<String, Either<NativeJavaClass, Boolean>> javaClassCache;

    public KubeJSContext(KubeJSContextFactory factory) {
        super((ContextFactory)factory);
        this.kjsFactory = factory;
        this.setApplicationClassLoader(KubeJS.class.getClassLoader());
        this.topLevelScope = this.initSafeStandardObjects();
        BindingRegistry bindingsEvent = new BindingRegistry(this, this.topLevelScope);
        for (KubeJSPlugin plugin : KubeJSPlugins.getAll()) {
            plugin.registerBindings(bindingsEvent);
        }
        KubeJSPlugins.addSidedBindings(bindingsEvent);
    }

    public boolean visibleToScripts(String fullClassName, ClassVisibilityContext type) {
        if (type == ClassVisibilityContext.CLASS_IN_PACKAGE || type == ClassVisibilityContext.ARGUMENT) {
            return this.kjsFactory.manager.isClassAllowed(fullClassName);
        }
        return true;
    }

    public ScriptType getType() {
        return this.kjsFactory.manager.scriptType;
    }

    public ConsoleJS getConsole() {
        return this.kjsFactory.manager.scriptType.console;
    }

    public RegistryAccessContainer getRegistries() {
        return this.kjsFactory.manager.getRegistries();
    }

    public Scriptable wrapAsJavaObject(Scriptable scope, Object javaObject, TypeInfo target) {
        if (javaObject instanceof AccessibleObject) {
            this.getConsole().error("Reflection access denied");
            return Undefined.SCRIPTABLE_INSTANCE;
        }
        if (javaObject instanceof ClassLoader) {
            this.getConsole().error("ClassLoader access denied");
            return Undefined.SCRIPTABLE_INSTANCE;
        }
        return super.wrapAsJavaObject(scope, javaObject, target);
    }

    public int internalConversionWeightLast(Object fromObj, TypeInfo target) {
        List<RegistryType<?>> reg;
        Class c = target.asClass();
        if (c == Optional.class || c == ResourceKey.class || c == Holder.class || c == HolderSet.class || c == TagKey.class) {
            return 1;
        }
        if (c != Object.class && !(reg = RegistryType.allOfClass(target.asClass())).isEmpty()) {
            return 1;
        }
        return super.internalConversionWeightLast(fromObj, target);
    }

    public RegistryType<?> lookupRegistryType(TypeInfo type, Object from) {
        RegistryType<?> registryType = RegistryType.lookup(type);
        if (registryType == null) {
            throw KubeJSContext.reportRuntimeError((String)("Can't interpret '" + String.valueOf(from) + "': no registries for type '" + String.valueOf(type) + "' found"), (Context)this);
        }
        return registryType;
    }

    public Registry<?> lookupRegistry(TypeInfo type, Object from) {
        RegistryType<?> registryType = this.lookupRegistryType(type, from);
        Registry registry = this.getRegistries().access().registry(registryType.key()).orElse(null);
        if (registry == null) {
            throw KubeJSContext.reportRuntimeError((String)("Can't interpret '" + String.valueOf(from) + "' as '" + String.valueOf(registryType.key().location()) + "': registry not found"), (Context)this);
        }
        return registry;
    }

    protected Object internalJsToJavaLast(Object from, TypeInfo target) {
        RegistryType<?> reg;
        Holder holder;
        Class c = target.asClass();
        if (c == Optional.class) {
            if (from instanceof Optional) {
                Optional o = (Optional)from;
                return o;
            }
            return Optional.ofNullable(this.jsToJava(from, target.param(0)));
        }
        if (c == ResourceKey.class) {
            if (from instanceof ResourceKey) {
                ResourceKey k = (ResourceKey)from;
                return k;
            }
            RegistryType<?> registryType = this.lookupRegistryType(target.param(0), from);
            ResourceLocation id = ID.mc(from);
            return ResourceKey.create(registryType.key(), (ResourceLocation)id);
        }
        if (c == Holder.class) {
            return HolderWrapper.wrap(this, from, target.param(0));
        }
        if (c == HolderSet.class) {
            return HolderWrapper.wrapSet(this, from, target.param(0));
        }
        if (c == TagKey.class) {
            if (from instanceof TagKey) {
                TagKey k = (TagKey)from;
                return k;
            }
            RegistryType<?> registryType = this.lookupRegistryType(target.param(0), from);
            ResourceLocation id = ID.mc(from);
            return TagKey.create(registryType.key(), (ResourceLocation)id);
        }
        if (AccessibleObject.class.isAssignableFrom(c)) {
            throw KubeJSContext.throwAsScriptRuntimeEx((Throwable)new IllegalAccessException("Reflection access denied"), (Context)this);
        }
        if (ClassLoader.class.isAssignableFrom(c)) {
            throw KubeJSContext.throwAsScriptRuntimeEx((Throwable)new IllegalAccessException("ClassLoader access denied"), (Context)this);
        }
        if (from instanceof Holder && c.isInstance((holder = (Holder)from).value())) {
            return holder.value();
        }
        if (ID.isKey(from) && (reg = RegistryType.lookup(target)) != null) {
            Registry registry = this.getRegistries().access().registry(reg.key()).orElse(null);
            if (registry == null) {
                throw KubeJSContext.reportRuntimeError((String)("Can't interpret '" + String.valueOf(from) + "' as '" + String.valueOf(reg.key().location()) + "': registry not found"), (Context)this);
            }
            Object value = registry.get(ID.mc(from));
            if (value != null) {
                return value;
            }
            throw KubeJSContext.reportRuntimeError((String)("Can't interpret '" + String.valueOf(from) + "' as '" + String.valueOf(reg.key().location()) + "': entry not found"), (Context)this);
        }
        return super.internalJsToJavaLast(from, target);
    }

    public NativeJavaClass loadJavaClass(String name, boolean error) {
        NativeJavaClass l;
        Either either;
        if (name == null || name.equals("null") || name.isEmpty()) {
            if (error) {
                throw KubeJSContext.reportRuntimeError((String)"Class name can't be empty!", (Context)this);
            }
            return null;
        }
        if (this.javaClassCache == null) {
            this.javaClassCache = new HashMap<String, Either<NativeJavaClass, Boolean>>();
        }
        if ((either = this.javaClassCache.get(name)) == null) {
            either = Either.right((Object)false);
            if (!this.kjsFactory.manager.isClassAllowed(name)) {
                either = Either.right((Object)true);
            } else {
                try {
                    either = Either.left((Object)new NativeJavaClass((Context)this, this.topLevelScope, Class.forName(name)));
                    this.getConsole().info("Loaded Java class '%s'".formatted(name));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.javaClassCache.put(name, (Either<NativeJavaClass, Boolean>)either);
        }
        if ((l = (NativeJavaClass)either.left().orElse(null)) != null) {
            return l;
        }
        if (error) {
            Boolean found = either.right().orElse(false);
            throw KubeJSContext.reportRuntimeError((String)(found != false ? "Failed to load Java class '%s': Class is not allowed by class filter!" : "Failed to load Java class '%s': Class could not be found!").formatted(name), (Context)this);
        }
        return null;
    }

    public Object classOf(Object from) {
        if (from instanceof Class) {
            Class c = (Class)from;
            return c;
        }
        if (from instanceof NativeJavaClass) {
            NativeJavaClass c = (NativeJavaClass)from;
            return c.getClassObject();
        }
        return this.loadJavaClass(String.valueOf(from), true).getClassObject();
    }

    public Map<String, Either<NativeJavaClass, Boolean>> getJavaClassCache() {
        return this.javaClassCache == null ? Map.of() : Collections.unmodifiableMap(this.javaClassCache);
    }

    public boolean isMapLike(Object from) {
        return super.isMapLike(from) || from instanceof CompoundTag || from instanceof JsonObject;
    }

    public Object mapOf(@Nullable Object from, TypeInfo kTarget, TypeInfo vTarget) {
        if (from instanceof CompoundTag) {
            CompoundTag tag = (CompoundTag)from;
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            for (String key : tag.getAllKeys()) {
                map.put(kTarget == TypeInfo.STRING ? key : String.valueOf(this.jsToJava(key, kTarget)), this.jsToJava(tag.get(key), vTarget));
            }
            return map;
        }
        if (from instanceof JsonObject) {
            JsonObject json = (JsonObject)from;
            LinkedHashMap map = new LinkedHashMap();
            for (Map.Entry entry : json.entrySet()) {
                map.put(kTarget == TypeInfo.STRING ? entry.getKey() : this.jsToJava(entry.getKey(), kTarget), this.jsToJava(JsonUtils.toObject((JsonElement)entry.getValue()), vTarget));
            }
            return map;
        }
        return super.mapOf(from, kTarget, vTarget);
    }
}

