/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.parts.anim.menu;

import com.tom.cpl.config.ConfigEntry;
import com.tom.cpm.shared.io.IOHelper;
import com.tom.cpm.shared.parts.anim.AnimLoaderState;
import com.tom.cpm.shared.parts.anim.menu.AbstractGestureButtonData;
import com.tom.cpm.shared.parts.anim.menu.GestureButtonType;
import com.tom.cpm.shared.parts.anim.menu.ValueParameterValueAction;
import java.io.IOException;

public class ValueParameterButtonData
extends AbstractGestureButtonData.AbstractCommandTriggerableData {
    public int parameter;
    public int maxValue;
    private ValueParameterValueAction action;

    @Override
    protected void parseData(IOHelper block, AnimLoaderState state) throws IOException {
        super.parseData(block, state);
        this.parameter = block.readVarInt();
        this.maxValue = block.read();
    }

    @Override
    public void onRegistered() {
        super.onRegistered();
        this.action = new ValueParameterValueAction(this.name, this.parameter, this.command, this.maxValue);
        this.commandActions.add(this.action);
    }

    @Override
    public GestureButtonType getType() {
        return GestureButtonType.VALUE_PARAMETER_SLIDER;
    }

    @Override
    public void write(IOHelper block) throws IOException {
        super.write(block);
        block.writeVarInt(this.parameter);
        block.writeByte(this.maxValue);
    }

    public void setValue(float value) {
        this.action.setValue((int)(value * (float)this.maxValue));
    }

    public float getValue() {
        return (float)this.action.getValue() / (float)this.maxValue;
    }

    public float getDefaultValue() {
        return (float)Byte.toUnsignedInt(this.def.getAnimations().getParams().getDefaultParam(this.parameter)) / 255.0f;
    }

    @Override
    public void storeTo(ConfigEntry ce) {
        ce.setFloat(this.name, (float)this.action.getValue() / (float)this.maxValue);
    }

    @Override
    public void loadFrom(ConfigEntry ce) {
        this.setValue(ce.getFloat(this.name, this.getDefaultValue()));
    }
}

