/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.parts;

import com.tom.cpl.math.Vec2i;
import com.tom.cpm.shared.animation.AnimatedTexture;
import com.tom.cpm.shared.config.ConfigKeys;
import com.tom.cpm.shared.definition.ModelDefinition;
import com.tom.cpm.shared.editor.anim.AnimatedTex;
import com.tom.cpm.shared.io.IOHelper;
import com.tom.cpm.shared.model.TextureSheetType;
import com.tom.cpm.shared.parts.IModelPart;
import com.tom.cpm.shared.parts.IResolvedModelPart;
import com.tom.cpm.shared.parts.ModelPartType;
import java.io.IOException;

public class ModelPartAnimatedTexture
implements IModelPart,
IResolvedModelPart {
    private TextureSheetType sheet;
    private Vec2i uvStart;
    private Vec2i uvSize;
    private Vec2i animStart;
    private int frameTime;
    private int frameCount;
    private boolean anX;
    private boolean interpolate;

    public ModelPartAnimatedTexture(IOHelper in, ModelDefinition def) throws IOException {
        this.sheet = (TextureSheetType)in.readEnum(TextureSheetType.VALUES);
        this.uvStart = in.read2v();
        this.uvSize = in.read2v();
        this.animStart = in.read2v();
        this.frameCount = in.readVarInt();
        this.frameTime = in.readVarInt();
        byte flags = in.readByte();
        this.anX = (flags & 1) != 0;
        this.interpolate = (flags & 2) != 0;
    }

    public ModelPartAnimatedTexture(TextureSheetType sheet, AnimatedTex tex) {
        this.sheet = sheet;
        this.uvStart = tex.uvStart;
        this.uvSize = tex.uvSize;
        this.animStart = tex.animStart;
        this.frameCount = tex.frameCount;
        this.frameTime = tex.frameTime;
        this.anX = tex.anX;
        this.interpolate = tex.interpolate;
    }

    @Override
    public IResolvedModelPart resolve() throws IOException {
        return this;
    }

    @Override
    public void write(IOHelper dout) throws IOException {
        dout.writeEnum(this.sheet);
        dout.write2v(this.uvStart);
        dout.write2v(this.uvSize);
        dout.write2v(this.animStart);
        dout.writeVarInt(this.frameCount);
        dout.writeVarInt(this.frameTime);
        int flags = 0;
        if (this.anX) {
            flags |= 1;
        }
        if (this.interpolate) {
            flags |= 2;
        }
        dout.writeByte(flags);
    }

    @Override
    public ModelPartType getType() {
        return ModelPartType.ANIMATED_TEX;
    }

    @Override
    public void apply(ModelDefinition def) {
        if (def.getPlayerObj().isClientPlayer() || ConfigKeys.ENABLE_ANIMATED_TEXTURES.getValueFor(def.getPlayerObj()).booleanValue()) {
            def.getAnimations().addAnimatedTexture(new AnimatedTexture(def, this.sheet, this.uvStart, this.uvSize, this.animStart, this.frameCount, this.frameTime, this.anX, this.interpolate));
        }
    }
}

