/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.io;

import com.tom.cpl.util.Image;
import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;

public class SkinDataOutputStream
extends OutputStream {
    private Image img;
    private Image template;
    private int block;
    private int channel;
    private int x;
    private int y;

    public SkinDataOutputStream(Image img, Image template, int channel) {
        this.img = img;
        this.template = template;
        this.channel = channel;
        this.block = -1;
        this.x = -1;
        int shift = 8 * (2 - channel);
        for (int y = 0; y < img.getHeight(); ++y) {
            for (int x = 0; x < img.getWidth(); ++x) {
                int t = template.getRGB(x, y);
                if (((t & 255 << shift) >>> shift & 0xFF) != 255) continue;
                if ((t & 0xFF) == 255) {
                    img.setRGB(x, y, -16777216);
                    continue;
                }
                img.setRGB(x, y, 0);
            }
        }
    }

    @Override
    public void write(int b) throws IOException {
        if (this.block == -1 || this.block > 3) {
            if (!this.findNextBlock()) {
                throw new EOFException();
            }
            this.block = 0;
        }
        int dt = this.img.getRGB(this.x, this.y);
        int shift = this.block++ * 8;
        dt &= ~(255 << shift);
        dt |= b << shift;
        if ((this.template.getRGB(this.x, this.y) & 0xFF) == 255 && this.block > 2) {
            ++this.block;
            dt |= 0xFF000000;
        }
        this.img.setRGB(this.x, this.y, dt);
    }

    private boolean findNextBlock() {
        int shift = 8 * (2 - this.channel);
        for (int y = this.y; y < this.img.getHeight(); ++y) {
            for (int x = this.x + 1; x < this.img.getWidth(); ++x) {
                int t = this.template.getRGB(x, y);
                if (((t & 255 << shift) >>> shift & 0xFF) != 255) continue;
                this.x = x;
                this.y = y;
                return true;
            }
            this.x = -1;
        }
        return false;
    }
}

