/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.io;

import com.tom.cpl.util.Util;
import com.tom.cpm.shared.MinecraftClientAccess;
import com.tom.cpm.shared.MinecraftCommonAccess;
import com.tom.cpm.shared.util.Log;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class HTTPIO {
    private static final String userAgent = "CPM " + MinecraftCommonAccess.get().getPlatformVersionString() + " Java/" + System.getProperty("java.version");

    public static HttpURLConnection createUrlConnection(URL url, boolean noCache) throws IOException {
        Log.debug("Opening connection to " + String.valueOf(url));
        MinecraftClientAccess mca = MinecraftClientAccess.get();
        HttpURLConnection connection = (HttpURLConnection)url.openConnection(mca != null ? mca.getProxy() : Proxy.NO_PROXY);
        connection.setConnectTimeout(15000);
        connection.setReadTimeout(15000);
        connection.setRequestProperty("User-Agent", userAgent.replace('$', '?'));
        if (noCache) {
            connection.setUseCaches(false);
        }
        return connection;
    }

    public static String getResponse(HttpURLConnection connection, URL url) throws IOException {
        InputStream inputStream = null;
        try {
            inputStream = connection.getInputStream();
            String result = HTTPIO.toString(inputStream, StandardCharsets.UTF_8);
            Log.debug("Successful read, server response was " + connection.getResponseCode());
            Log.debug("Response: " + result);
            String string = result;
            return string;
        }
        catch (IOException e) {
            Util.closeQuietly(inputStream);
            inputStream = connection.getErrorStream();
            if (inputStream != null) {
                Log.debug("Reading error page from " + String.valueOf(url));
                String result = HTTPIO.toString(inputStream, StandardCharsets.UTF_8);
                Log.debug("Successful read, server response was " + connection.getResponseCode());
                Log.debug("Response: " + result);
                String string = result;
                return string;
            }
            Log.debug("Request failed", e);
            throw e;
        }
        finally {
            Util.closeQuietly(inputStream);
        }
    }

    public static String toString(InputStream input, Charset encoding) throws IOException {
        StringBuilderWriter sw = new StringBuilderWriter();
        HTTPIO.copyChars(new InputStreamReader(input, encoding), sw);
        return sw.toString();
    }

    public static long copyChars(Reader input, Writer output) throws IOException {
        int n;
        char[] buffer = new char[4096];
        long count = 0L;
        while ((n = input.read(buffer)) != -1) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    public static class StringBuilderWriter
    extends Writer
    implements Serializable {
        private static final long serialVersionUID = -146927496096066153L;
        private final StringBuilder builder;

        public StringBuilderWriter() {
            this.builder = new StringBuilder();
        }

        public StringBuilderWriter(int capacity) {
            this.builder = new StringBuilder(capacity);
        }

        public StringBuilderWriter(StringBuilder builder) {
            this.builder = builder != null ? builder : new StringBuilder();
        }

        @Override
        public Writer append(char value) {
            this.builder.append(value);
            return this;
        }

        @Override
        public Writer append(CharSequence value) {
            this.builder.append(value);
            return this;
        }

        @Override
        public Writer append(CharSequence value, int start, int end) {
            this.builder.append(value, start, end);
            return this;
        }

        @Override
        public void close() {
        }

        @Override
        public void flush() {
        }

        @Override
        public void write(String value) {
            if (value != null) {
                this.builder.append(value);
            }
        }

        @Override
        public void write(char[] value, int offset, int length) {
            if (value != null) {
                this.builder.append(value, offset, length);
            }
        }

        public StringBuilder getBuilder() {
            return this.builder;
        }

        public String toString() {
            return this.builder.toString();
        }
    }
}

