/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.definition;

import com.tom.cpm.shared.io.IOHelper;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class Link {
    protected String loader;
    protected String path;

    public Link(IOHelper in) throws IOException {
        int pathLen = in.read();
        byte[] path = new byte[pathLen];
        in.readFully(path);
        String[] sp = new String(path).split(":");
        this.loader = sp[0];
        this.path = sp[1];
    }

    public Link(String loader, String path) {
        this.loader = loader;
        this.path = path;
    }

    public Link(String fullPath) {
        String[] sp = fullPath.split(":", 2);
        this.loader = sp[0];
        this.path = sp[1];
    }

    public void write(IOHelper dout) throws IOException {
        byte[] path = (this.loader + ":" + this.path).getBytes();
        dout.write(path.length);
        dout.write(path);
    }

    public String toString() {
        return this.loader + ":" + this.path;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.loader == null ? 0 : this.loader.hashCode());
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Link other = (Link)obj;
        if (this.loader == null ? other.loader != null : !this.loader.equals(other.loader)) {
            return false;
        }
        return !(this.path == null ? other.path != null : !this.path.equals(other.path));
    }

    public String getLoader() {
        return this.loader;
    }

    public String getPath() {
        return this.path;
    }

    public static class ResolvedLink {
        private byte[] data;
        private IOException error;

        public ResolvedLink(IOException error) {
            this.error = error;
        }

        public ResolvedLink(byte[] data) {
            this.data = data;
        }

        public InputStream getData() throws IOException {
            if (this.error != null) {
                throw this.error;
            }
            return new ByteArrayInputStream(this.data);
        }
    }
}

