/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpl.nbt;

import com.tom.cpl.nbt.NBTTag;
import com.tom.cpm.shared.io.IOHelper;
import java.io.IOException;

public class NBTTagInt
extends NBTTag.NBTPrimitive {
    private int data;

    NBTTagInt() {
    }

    public NBTTagInt(int data) {
        this.data = data;
    }

    @Override
    public void write(IOHelper output) throws IOException {
        output.writeInt(this.data);
    }

    @Override
    public void read(IOHelper input) throws IOException {
        this.data = input.readInt();
    }

    @Override
    public byte getId() {
        return 3;
    }

    public String toString() {
        return String.valueOf(this.data);
    }

    @Override
    public NBTTagInt copy() {
        return new NBTTagInt(this.data);
    }

    @Override
    public boolean equals(Object other) {
        if (super.equals(other)) {
            NBTTagInt nbttagint = (NBTTagInt)other;
            return this.data == nbttagint.data;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.data;
    }

    @Override
    public long getLong() {
        return this.data;
    }

    @Override
    public int getInt() {
        return this.data;
    }

    @Override
    public short getShort() {
        return (short)(this.data & 0xFFFF);
    }

    @Override
    public byte getByte() {
        return (byte)(this.data & 0xFF);
    }

    @Override
    public double getDouble() {
        return this.data;
    }

    @Override
    public float getFloat() {
        return this.data;
    }
}

