/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.integration;

import dan200.computercraft.api.media.IMedia;
import dan200.computercraft.api.pocket.IPocketUpgrade;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.api.upgrades.UpgradeBase;
import dan200.computercraft.api.upgrades.UpgradeData;
import dan200.computercraft.shared.ModRegistry;
import dan200.computercraft.shared.integration.RecipeModHelpers;
import dan200.computercraft.shared.pocket.items.PocketComputerItem;
import dan200.computercraft.shared.turtle.items.TurtleItem;
import dan200.computercraft.shared.util.DataComponentUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.minecraft.world.level.ItemLike;

public class UpgradeRecipeGenerator<T> {
    private final Function<ShapedRecipe, T> wrap;
    private final HolderLookup.Provider registries;
    private final Map<Item, List<UpgradeInfo>> upgradeItemLookup = new HashMap<Item, List<UpgradeInfo>>();
    private final List<UpgradeInfo> pocketUpgrades = new ArrayList<UpgradeInfo>();
    private final List<UpgradeInfo> turtleUpgrades = new ArrayList<UpgradeInfo>();
    private boolean initialised = false;

    public UpgradeRecipeGenerator(Function<ShapedRecipe, T> wrap, HolderLookup.Provider registries) {
        this.wrap = wrap;
        this.registries = registries;
    }

    private void setupCache() {
        if (this.initialised) {
            return;
        }
        this.initialised = true;
        RecipeModHelpers.forEachRegistry(this.registries, ITurtleUpgrade.REGISTRY, holder -> {
            ITurtleUpgrade upgrade = (ITurtleUpgrade)holder.value();
            ItemStack stack = upgrade.getCraftingItem();
            if (stack.isEmpty()) {
                return;
            }
            UpgradeInfo info = new UpgradeInfo(stack, upgrade, (Holder.Reference<ITurtleUpgrade>)holder, null);
            this.upgradeItemLookup.computeIfAbsent(stack.getItem(), k -> new ArrayList(1)).add(info);
            this.turtleUpgrades.add(info);
        });
        RecipeModHelpers.forEachRegistry(this.registries, IPocketUpgrade.REGISTRY, holder -> {
            IPocketUpgrade upgrade = (IPocketUpgrade)holder.value();
            ItemStack stack = upgrade.getCraftingItem();
            if (stack.isEmpty()) {
                return;
            }
            UpgradeInfo info = new UpgradeInfo(stack, upgrade, null, (Holder.Reference<IPocketUpgrade>)holder);
            this.upgradeItemLookup.computeIfAbsent(stack.getItem(), k -> new ArrayList(1)).add(info);
            this.pocketUpgrades.add(info);
        });
    }

    public boolean isUpgrade(ItemStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        this.setupCache();
        List<UpgradeInfo> upgrades = this.upgradeItemLookup.get(stack.getItem());
        if (upgrades == null) {
            return false;
        }
        for (UpgradeInfo upgrade : upgrades) {
            ItemStack craftingStack = upgrade.stack;
            if (craftingStack.isEmpty() || craftingStack.getItem() != stack.getItem() || !upgrade.upgrade.isItemSuitable(stack)) continue;
            return true;
        }
        return false;
    }

    public List<T> findRecipesWithInput(ItemStack stack) {
        this.setupCache();
        if (stack.getItem() instanceof TurtleItem) {
            UpgradeData<ITurtleUpgrade> left = TurtleItem.getUpgradeWithData(stack, TurtleSide.LEFT);
            UpgradeData<ITurtleUpgrade> right = TurtleItem.getUpgradeWithData(stack, TurtleSide.RIGHT);
            if (left != null && right != null) {
                return List.of();
            }
            ArrayList<T> recipes = new ArrayList<T>();
            Ingredient ingredient = Ingredient.of((ItemStack[])new ItemStack[]{stack});
            for (UpgradeInfo upgrade : this.turtleUpgrades) {
                if (upgrade.turtle == null) {
                    throw new NullPointerException();
                }
                if (left == null) {
                    recipes.add(this.turtle(ingredient, upgrade.ingredient, UpgradeRecipeGenerator.turtleWith(stack, UpgradeData.ofDefault(upgrade.turtle), right)));
                }
                if (right != null) continue;
                recipes.add(this.turtle(upgrade.ingredient, ingredient, UpgradeRecipeGenerator.turtleWith(stack, left, UpgradeData.ofDefault(upgrade.turtle))));
            }
            return Collections.unmodifiableList(recipes);
        }
        if (stack.getItem() instanceof PocketComputerItem) {
            IPocketUpgrade back = PocketComputerItem.getUpgrade(stack);
            if (back != null) {
                return List.of();
            }
            ArrayList<T> recipes = new ArrayList<T>();
            Ingredient ingredient = Ingredient.of((ItemStack[])new ItemStack[]{stack});
            for (UpgradeInfo upgrade : this.pocketUpgrades) {
                if (upgrade.pocket == null) {
                    throw new NullPointerException();
                }
                recipes.add(this.pocket(upgrade.ingredient, ingredient, UpgradeRecipeGenerator.pocketWith(stack, UpgradeData.ofDefault(upgrade.pocket))));
            }
            return Collections.unmodifiableList(recipes);
        }
        List<UpgradeInfo> upgrades = this.upgradeItemLookup.get(stack.getItem());
        if (upgrades == null) {
            return List.of();
        }
        List recipes = null;
        boolean multiple = false;
        for (UpgradeInfo upgrade : upgrades) {
            ItemStack craftingStack = upgrade.stack;
            if (craftingStack.isEmpty() || craftingStack.getItem() != stack.getItem() || !upgrade.upgrade.isItemSuitable(stack)) continue;
            if (recipes == null) {
                recipes = upgrade.getRecipes();
                continue;
            }
            if (!multiple) {
                multiple = true;
                recipes = new ArrayList(recipes);
            }
            recipes.addAll(upgrade.getRecipes());
        }
        return recipes == null ? List.of() : Collections.unmodifiableList(recipes);
    }

    public List<T> findRecipesWithOutput(ItemStack stack) {
        if (stack.getItem() instanceof TurtleItem) {
            ArrayList<T> recipes = new ArrayList<T>(0);
            UpgradeData<ITurtleUpgrade> left = TurtleItem.getUpgradeWithData(stack, TurtleSide.LEFT);
            UpgradeData<ITurtleUpgrade> right = TurtleItem.getUpgradeWithData(stack, TurtleSide.RIGHT);
            if (left != null) {
                recipes.add(this.turtle(Ingredient.of((ItemStack[])new ItemStack[]{UpgradeRecipeGenerator.turtleWith(stack, null, right)}), Ingredient.of((ItemStack[])new ItemStack[]{left.getUpgradeItem()}), stack));
            }
            if (right != null) {
                recipes.add(this.turtle(Ingredient.of((ItemStack[])new ItemStack[]{right.getUpgradeItem()}), Ingredient.of((ItemStack[])new ItemStack[]{UpgradeRecipeGenerator.turtleWith(stack, left, null)}), stack));
            }
            return Collections.unmodifiableList(recipes);
        }
        if (stack.getItem() instanceof PocketComputerItem) {
            ArrayList<T> recipes = new ArrayList<T>(0);
            UpgradeData<IPocketUpgrade> back = PocketComputerItem.getUpgradeWithData(stack);
            if (back != null) {
                recipes.add(this.pocket(Ingredient.of((ItemStack[])new ItemStack[]{back.getUpgradeItem()}), Ingredient.of((ItemStack[])new ItemStack[]{UpgradeRecipeGenerator.pocketWith(stack, null)}), stack));
            }
            return Collections.unmodifiableList(recipes);
        }
        return List.of();
    }

    private static ItemStack turtleWith(ItemStack stack, @Nullable UpgradeData<ITurtleUpgrade> left, @Nullable UpgradeData<ITurtleUpgrade> right) {
        ItemStack newStack = stack.copyWithCount(1);
        newStack.set((DataComponentType)ModRegistry.DataComponents.LEFT_TURTLE_UPGRADE.get(), left);
        newStack.set((DataComponentType)ModRegistry.DataComponents.RIGHT_TURTLE_UPGRADE.get(), right);
        return newStack;
    }

    private static ItemStack pocketWith(ItemStack stack, @Nullable UpgradeData<IPocketUpgrade> back) {
        ItemStack newStack = stack.copyWithCount(1);
        newStack.set((DataComponentType)ModRegistry.DataComponents.POCKET_UPGRADE.get(), back);
        return newStack;
    }

    private T pocket(Ingredient upgrade, Ingredient pocketComputer, ItemStack result) {
        return this.wrap.apply(new ShapedRecipe("", CraftingBookCategory.MISC, new ShapedRecipePattern(1, 2, NonNullList.of((Object)Ingredient.EMPTY, (Object[])new Ingredient[]{upgrade, pocketComputer}), Optional.empty()), result));
    }

    private T turtle(Ingredient left, Ingredient right, ItemStack result) {
        return this.wrap.apply(new ShapedRecipe("", CraftingBookCategory.MISC, new ShapedRecipePattern(2, 1, NonNullList.of((Object)Ingredient.EMPTY, (Object[])new Ingredient[]{left, right}), Optional.empty()), result));
    }

    private class UpgradeInfo {
        final ItemStack stack;
        final Ingredient ingredient;
        @Nullable
        final Holder.Reference<ITurtleUpgrade> turtle;
        @Nullable
        final Holder.Reference<IPocketUpgrade> pocket;
        final UpgradeBase upgrade;
        @Nullable
        private ArrayList<T> recipes;

        UpgradeInfo(ItemStack stack, @Nullable UpgradeBase upgrade, @Nullable Holder.Reference<ITurtleUpgrade> turtle, Holder.Reference<IPocketUpgrade> pocket) {
            this.stack = stack;
            this.ingredient = Ingredient.of((ItemStack[])new ItemStack[]{stack});
            this.turtle = turtle;
            this.pocket = pocket;
            this.upgrade = upgrade;
        }

        List<T> getRecipes() {
            ArrayList<Object> recipes = this.recipes;
            if (recipes != null) {
                return recipes;
            }
            this.recipes = new ArrayList(4);
            recipes = this.recipes;
            if (this.turtle != null) {
                for (Supplier<IMedia> supplier : RecipeModHelpers.TURTLES) {
                    TurtleItem turtleItem = (TurtleItem)supplier.get();
                    recipes.add(UpgradeRecipeGenerator.this.turtle(this.ingredient, Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)turtleItem)}), DataComponentUtil.createStack((ItemLike)turtleItem, (DataComponentType)ModRegistry.DataComponents.RIGHT_TURTLE_UPGRADE.get(), UpgradeData.ofDefault(this.turtle))));
                }
            }
            if (this.pocket != null) {
                for (Supplier<IMedia> supplier : RecipeModHelpers.POCKET_COMPUTERS) {
                    PocketComputerItem pocketItem = (PocketComputerItem)supplier.get();
                    recipes.add(UpgradeRecipeGenerator.this.pocket(this.ingredient, Ingredient.of((ItemLike[])new ItemLike[]{pocketItem}), DataComponentUtil.createStack((ItemLike)pocketItem, (DataComponentType)ModRegistry.DataComponents.POCKET_UPGRADE.get(), UpgradeData.ofDefault(this.pocket))));
                }
            }
            recipes.trimToSize();
            return recipes;
        }
    }
}

