/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.impl;

import com.google.auto.service.AutoService;
import dan200.computercraft.api.detail.DetailRegistry;
import dan200.computercraft.impl.AbstractComputerCraftAPI;
import dan200.computercraft.impl.ComputerCraftAPIForgeService;
import dan200.computercraft.impl.ComputerCraftAPIService;
import dan200.computercraft.impl.Peripherals;
import dan200.computercraft.impl.detail.DetailRegistryImpl;
import dan200.computercraft.shared.details.FluidData;
import dan200.computercraft.shared.peripheral.generic.ComponentLookup;
import dan200.computercraft.shared.util.CapabilityUtil;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.fluids.FluidStack;

@AutoService(value={ComputerCraftAPIService.class})
public final class ComputerCraftAPIImpl
extends AbstractComputerCraftAPI
implements ComputerCraftAPIForgeService {
    private final DetailRegistry<FluidStack> fluidStackDetails = new DetailRegistryImpl<FluidStack>(FluidData::fillBasic);
    @Nullable
    private String version;

    @Override
    public String getInstalledVersion() {
        if (this.version != null) {
            return this.version;
        }
        this.version = ModList.get().getModContainerById("computercraft").map(x -> x.getModInfo().getVersion().toString()).orElse("unknown");
        return this.version;
    }

    @Override
    public void registerGenericCapability(BlockCapability<?, Direction> capability) {
        Objects.requireNonNull(capability, "Capability cannot be null");
        Peripherals.addGenericLookup(new CapabilityLookup(capability));
    }

    @Override
    public DetailRegistry<FluidStack> getFluidStackDetailRegistry() {
        return this.fluidStackDetails;
    }

    private record CapabilityLookup<T>(BlockCapability<T, Direction> capability) implements ComponentLookup
    {
        @Nullable
        public T find(ServerLevel level, BlockPos pos, BlockState state, BlockEntity blockEntity, Direction side) {
            return CapabilityUtil.getCapability(level, this.capability, pos, state, blockEntity, side);
        }
    }
}

