/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.data;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dan200.computercraft.api.ComputerCraftTags;
import dan200.computercraft.api.pocket.IPocketUpgrade;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.upgrades.UpgradeData;
import dan200.computercraft.core.util.Colour;
import dan200.computercraft.data.TurtleOverlays;
import dan200.computercraft.data.recipe.ShapedSpecBuilder;
import dan200.computercraft.data.recipe.ShapelessSpecBuilder;
import dan200.computercraft.shared.ModRegistry;
import dan200.computercraft.shared.common.ClearColourRecipe;
import dan200.computercraft.shared.common.ColourableRecipe;
import dan200.computercraft.shared.media.recipes.DiskRecipe;
import dan200.computercraft.shared.media.recipes.PrintoutRecipe;
import dan200.computercraft.shared.platform.PlatformHelper;
import dan200.computercraft.shared.platform.RecipeIngredients;
import dan200.computercraft.shared.pocket.items.PocketComputerItem;
import dan200.computercraft.shared.pocket.recipes.PocketComputerUpgradeRecipe;
import dan200.computercraft.shared.recipe.ImpostorShapedRecipe;
import dan200.computercraft.shared.recipe.ImpostorShapelessRecipe;
import dan200.computercraft.shared.recipe.ShapedRecipeSpec;
import dan200.computercraft.shared.recipe.ShapelessRecipeSpec;
import dan200.computercraft.shared.recipe.TransformShapedRecipe;
import dan200.computercraft.shared.recipe.TransformShapelessRecipe;
import dan200.computercraft.shared.recipe.function.CopyComponents;
import dan200.computercraft.shared.turtle.TurtleOverlay;
import dan200.computercraft.shared.turtle.items.TurtleItem;
import dan200.computercraft.shared.turtle.recipes.TurtleUpgradeRecipe;
import dan200.computercraft.shared.util.ColourUtils;
import dan200.computercraft.shared.util.DataComponentUtil;
import dan200.computercraft.shared.util.RegistryHelper;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;

final class RecipeProvider
extends net.minecraft.data.recipes.RecipeProvider {
    private final RecipeIngredients ingredients = PlatformHelper.get().getRecipeIngredients();
    private final CompletableFuture<HolderLookup.Provider> registries;

    RecipeProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries);
        this.registries = registries;
    }

    private HolderLookup.Provider registries() {
        try {
            return this.registries.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted");
        }
        catch (ExecutionException e) {
            RuntimeException rt;
            Throwable cause = e.getCause();
            throw cause instanceof RuntimeException ? (rt = (RuntimeException)cause) : new RuntimeException("Unexpected error", cause);
        }
    }

    public void buildRecipes(RecipeOutput add) {
        HolderLookup.Provider registries = this.registries();
        this.basicRecipes(add);
        this.diskColours(add);
        this.pocketUpgrades(add, registries);
        this.turtleUpgrades(add, registries);
        this.turtleOverlays(add, registries);
        RecipeProvider.addSpecial(add, new DiskRecipe(CraftingBookCategory.MISC));
        RecipeProvider.addSpecial(add, new ColourableRecipe(CraftingBookCategory.MISC));
        RecipeProvider.addSpecial(add, new ClearColourRecipe(CraftingBookCategory.MISC));
        RecipeProvider.addSpecial(add, new TurtleUpgradeRecipe(CraftingBookCategory.MISC));
        RecipeProvider.addSpecial(add, new PocketComputerUpgradeRecipe(CraftingBookCategory.MISC));
    }

    private void diskColours(RecipeOutput output) {
        for (Colour colour : Colour.VALUES) {
            ((ShapelessSpecBuilder)((ShapelessSpecBuilder)ShapelessSpecBuilder.shapeless(RecipeCategory.REDSTONE, DataComponentUtil.createStack((ItemLike)ModRegistry.Items.DISK.get(), DataComponents.DYED_COLOR, new DyedItemColor(colour.getHex(), false))).requires(this.ingredients.redstone()).requires((ItemLike)Items.PAPER).requires((ItemLike)DyeItem.byColor((DyeColor)RecipeProvider.ofColour(colour))).group("computercraft:disk")).unlockedBy("has_drive", RecipeProvider.inventoryChange((ItemLike)ModRegistry.Items.DISK_DRIVE.get()))).build(ImpostorShapelessRecipe::new).save(output, ResourceLocation.fromNamespaceAndPath((String)"computercraft", (String)("disk_" + (colour.ordinal() + 1))));
        }
    }

    private static List<TurtleItem> turtleItems() {
        return List.of((TurtleItem)ModRegistry.Items.TURTLE_NORMAL.get(), (TurtleItem)ModRegistry.Items.TURTLE_ADVANCED.get());
    }

    private void turtleUpgrades(RecipeOutput add, HolderLookup.Provider registries) {
        for (TurtleItem turtleItem : RecipeProvider.turtleItems()) {
            ResourceLocation name = RegistryHelper.getKeyOrThrow(BuiltInRegistries.ITEM, turtleItem);
            registries.lookupOrThrow(ITurtleUpgrade.REGISTRY).listElements().forEach(upgradeHolder -> {
                ITurtleUpgrade upgrade = (ITurtleUpgrade)upgradeHolder.value();
                ((ShapedSpecBuilder)((ShapedSpecBuilder)ShapedSpecBuilder.shaped(RecipeCategory.REDSTONE, DataComponentUtil.createStack((ItemLike)turtleItem, (DataComponentType)ModRegistry.DataComponents.RIGHT_TURTLE_UPGRADE.get(), UpgradeData.ofDefault(upgradeHolder))).group(name.toString())).pattern("#T").define('T', (ItemLike)turtleItem).define('#', (ItemLike)upgrade.getCraftingItem().getItem()).unlockedBy("has_items", RecipeProvider.inventoryChange(new ItemLike[]{turtleItem, upgrade.getCraftingItem().getItem()}))).build(ImpostorShapedRecipe::new).save(add, name.withSuffix(String.format("/%s/%s", upgradeHolder.key().location().getNamespace(), upgradeHolder.key().location().getPath())));
            });
        }
    }

    private static List<PocketComputerItem> pocketComputerItems() {
        return List.of((PocketComputerItem)ModRegistry.Items.POCKET_COMPUTER_NORMAL.get(), (PocketComputerItem)ModRegistry.Items.POCKET_COMPUTER_ADVANCED.get());
    }

    private void pocketUpgrades(RecipeOutput add, HolderLookup.Provider registries) {
        for (PocketComputerItem pocket : RecipeProvider.pocketComputerItems()) {
            ResourceLocation name = RegistryHelper.getKeyOrThrow(BuiltInRegistries.ITEM, pocket).withPath(x -> x.replace("pocket_computer_", "pocket_"));
            registries.lookupOrThrow(IPocketUpgrade.REGISTRY).listElements().forEach(upgradeHolder -> {
                IPocketUpgrade upgrade = (IPocketUpgrade)upgradeHolder.value();
                ((ShapedSpecBuilder)((ShapedSpecBuilder)ShapedSpecBuilder.shaped(RecipeCategory.REDSTONE, DataComponentUtil.createStack((ItemLike)pocket, (DataComponentType)ModRegistry.DataComponents.POCKET_UPGRADE.get(), UpgradeData.ofDefault(upgradeHolder))).group(name.toString())).pattern("#").pattern("P").define('P', (ItemLike)pocket).define('#', (ItemLike)upgrade.getCraftingItem().getItem()).unlockedBy("has_items", RecipeProvider.inventoryChange(new ItemLike[]{pocket, upgrade.getCraftingItem().getItem()}))).build(ImpostorShapedRecipe::new).save(add, name.withSuffix(String.format("/%s/%s", upgradeHolder.key().location().getNamespace(), upgradeHolder.key().location().getPath())));
            });
        }
    }

    private void turtleOverlays(RecipeOutput add, HolderLookup.Provider registries) {
        this.turtleOverlay(add, registries, TurtleOverlays.TRANS_FLAG, x -> ((ShapelessSpecBuilder)x.unlockedBy("has_dye", RecipeProvider.inventoryChange(RecipeProvider.itemPredicate(this.ingredients.dye())))).requires(ColourUtils.getDyeTag(DyeColor.LIGHT_BLUE)).requires(ColourUtils.getDyeTag(DyeColor.PINK)).requires(ColourUtils.getDyeTag(DyeColor.WHITE)).requires((ItemLike)Items.STICK));
        this.turtleOverlay(add, registries, TurtleOverlays.RAINBOW_FLAG, x -> ((ShapelessSpecBuilder)x.unlockedBy("has_dye", RecipeProvider.inventoryChange(RecipeProvider.itemPredicate(this.ingredients.dye())))).requires(ColourUtils.getDyeTag(DyeColor.RED)).requires(ColourUtils.getDyeTag(DyeColor.ORANGE)).requires(ColourUtils.getDyeTag(DyeColor.YELLOW)).requires(ColourUtils.getDyeTag(DyeColor.GREEN)).requires(ColourUtils.getDyeTag(DyeColor.BLUE)).requires(ColourUtils.getDyeTag(DyeColor.PURPLE)).requires((ItemLike)Items.STICK));
    }

    private void turtleOverlay(RecipeOutput add, HolderLookup.Provider registries, ResourceKey<TurtleOverlay> overlay, Consumer<ShapelessSpecBuilder> build) {
        Holder.Reference holder = registries.lookupOrThrow(overlay.registryKey()).getOrThrow(overlay);
        for (TurtleItem turtleItem : RecipeProvider.turtleItems()) {
            ResourceLocation name = RegistryHelper.getKeyOrThrow(BuiltInRegistries.ITEM, turtleItem);
            ShapelessSpecBuilder builder = (ShapelessSpecBuilder)((ShapelessSpecBuilder)ShapelessSpecBuilder.shapeless(RecipeCategory.REDSTONE, DataComponentUtil.createStack((ItemLike)turtleItem, (DataComponentType)ModRegistry.DataComponents.OVERLAY.get(), holder)).group(name.withSuffix("_overlay").toString())).unlockedBy("has_turtle", RecipeProvider.inventoryChange(new ItemLike[]{turtleItem}));
            build.accept(builder);
            builder.requires((ItemLike)turtleItem).build(s -> new TransformShapelessRecipe((ShapelessRecipeSpec)s, List.of(CopyComponents.builder((ItemLike)turtleItem).exclude((DataComponentType)ModRegistry.DataComponents.OVERLAY.get()).build()))).save(add, name.withSuffix("_overlays/" + overlay.location().getPath()));
        }
    }

    private void basicRecipes(RecipeOutput add) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)ModRegistry.Items.CABLE.get()), (int)6).pattern(" # ").pattern("#R#").pattern(" # ").define(Character.valueOf('#'), (ItemLike)Items.STONE).define(Character.valueOf('R'), this.ingredients.redstone()).unlockedBy("has_computer", RecipeProvider.inventoryChange(ComputerCraftTags.Items.COMPUTER)).unlockedBy("has_modem", RecipeProvider.inventoryChange(ComputerCraftTags.Items.WIRED_MODEM)).save(add);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)ModRegistry.Items.COMPUTER_NORMAL.get())).pattern("###").pattern("#R#").pattern("#G#").define(Character.valueOf('#'), (ItemLike)Items.STONE).define(Character.valueOf('R'), this.ingredients.redstone()).define(Character.valueOf('G'), this.ingredients.glassPane()).unlockedBy("has_redstone", RecipeProvider.inventoryChange(RecipeProvider.itemPredicate(this.ingredients.redstone()))).save(add);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)ModRegistry.Items.COMPUTER_ADVANCED.get())).pattern("###").pattern("#R#").pattern("#G#").define(Character.valueOf('#'), this.ingredients.goldIngot()).define(Character.valueOf('R'), this.ingredients.redstone()).define(Character.valueOf('G'), this.ingredients.glassPane()).unlockedBy("has_components", RecipeProvider.inventoryChange(RecipeProvider.itemPredicate(this.ingredients.redstone()), RecipeProvider.itemPredicate(this.ingredients.goldIngot()))).save(add);
        ((ShapedSpecBuilder)ShapedSpecBuilder.shaped(RecipeCategory.REDSTONE, (ItemLike)ModRegistry.Items.COMPUTER_ADVANCED.get()).pattern("###").pattern("#C#").pattern("# #").define('#', this.ingredients.goldIngot()).define('C', (ItemLike)ModRegistry.Items.COMPUTER_NORMAL.get()).unlockedBy("has_components", RecipeProvider.inventoryChange(RecipeProvider.itemPredicate((ItemLike)ModRegistry.Items.COMPUTER_NORMAL.get()), RecipeProvider.itemPredicate(this.ingredients.goldIngot())))).build(x -> new TransformShapedRecipe((ShapedRecipeSpec)x, List.of(new CopyComponents((ItemLike)ModRegistry.Items.COMPUTER_NORMAL.get())))).save(add, ResourceLocation.fromNamespaceAndPath((String)"computercraft", (String)"computer_advanced_upgrade"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)ModRegistry.Items.COMPUTER_COMMAND.get())).pattern("###").pattern("#R#").pattern("#G#").define(Character.valueOf('#'), this.ingredients.goldIngot()).define(Character.valueOf('R'), (ItemLike)Items.COMMAND_BLOCK).define(Character.valueOf('G'), this.ingredients.glassPane()).unlockedBy("has_components", RecipeProvider.inventoryChange(new ItemLike[]{Items.COMMAND_BLOCK})).save(add);
        ((ShapedSpecBuilder)ShapedSpecBuilder.shaped(RecipeCategory.REDSTONE, (ItemLike)ModRegistry.Items.TURTLE_NORMAL.get()).pattern("###").pattern("#C#").pattern("#I#").define('#', this.ingredients.ironIngot()).define('C', (ItemLike)ModRegistry.Items.COMPUTER_NORMAL.get()).define('I', this.ingredients.woodenChest()).unlockedBy("has_computer", RecipeProvider.inventoryChange((ItemLike)ModRegistry.Items.COMPUTER_NORMAL.get()))).build(x -> new TransformShapedRecipe((ShapedRecipeSpec)x, List.of(new CopyComponents((ItemLike)ModRegistry.Items.COMPUTER_NORMAL.get())))).save(add);
        ((ShapedSpecBuilder)ShapedSpecBuilder.shaped(RecipeCategory.REDSTONE, (ItemLike)ModRegistry.Items.TURTLE_ADVANCED.get()).pattern("###").pattern("#C#").pattern("#I#").define('#', this.ingredients.goldIngot()).define('C', (ItemLike)ModRegistry.Items.COMPUTER_ADVANCED.get()).define('I', this.ingredients.woodenChest()).unlockedBy("has_computer", RecipeProvider.inventoryChange((ItemLike)ModRegistry.Items.COMPUTER_NORMAL.get()))).build(x -> new TransformShapedRecipe((ShapedRecipeSpec)x, List.of(new CopyComponents((ItemLike)ModRegistry.Items.COMPUTER_ADVANCED.get())))).save(add);
        ((ShapedSpecBuilder)ShapedSpecBuilder.shaped(RecipeCategory.REDSTONE, (ItemLike)ModRegistry.Items.TURTLE_ADVANCED.get()).pattern("###").pattern("#C#").pattern(" B ").define('#', this.ingredients.goldIngot()).define('C', (ItemLike)ModRegistry.Items.TURTLE_NORMAL.get()).define('B', this.ingredients.goldBlock()).unlockedBy("has_components", RecipeProvider.inventoryChange(RecipeProvider.itemPredicate((ItemLike)ModRegistry.Items.TURTLE_NORMAL.get()), RecipeProvider.itemPredicate(this.ingredients.goldIngot())))).build(x -> new TransformShapedRecipe((ShapedRecipeSpec)x, List.of(new CopyComponents((ItemLike)ModRegistry.Items.TURTLE_NORMAL.get())))).save(add, ResourceLocation.fromNamespaceAndPath((String)"computercraft", (String)"turtle_advanced_upgrade"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)ModRegistry.Items.DISK_DRIVE.get())).pattern("###").pattern("#R#").pattern("#R#").define(Character.valueOf('#'), (ItemLike)Items.STONE).define(Character.valueOf('R'), this.ingredients.redstone()).unlockedBy("has_computer", RecipeProvider.inventoryChange(ComputerCraftTags.Items.COMPUTER)).save(add);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)ModRegistry.Items.MONITOR_NORMAL.get())).pattern("###").pattern("#G#").pattern("###").define(Character.valueOf('#'), (ItemLike)Items.STONE).define(Character.valueOf('G'), this.ingredients.glassPane()).unlockedBy("has_computer", RecipeProvider.inventoryChange(ComputerCraftTags.Items.COMPUTER)).save(add);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)ModRegistry.Items.MONITOR_ADVANCED.get()), (int)4).pattern("###").pattern("#G#").pattern("###").define(Character.valueOf('#'), this.ingredients.goldIngot()).define(Character.valueOf('G'), this.ingredients.glassPane()).unlockedBy("has_computer", RecipeProvider.inventoryChange(ComputerCraftTags.Items.COMPUTER)).save(add);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)ModRegistry.Items.POCKET_COMPUTER_NORMAL.get())).pattern("###").pattern("#A#").pattern("#G#").define(Character.valueOf('#'), (ItemLike)Items.STONE).define(Character.valueOf('A'), (ItemLike)Items.GOLDEN_APPLE).define(Character.valueOf('G'), this.ingredients.glassPane()).unlockedBy("has_computer", RecipeProvider.inventoryChange(ComputerCraftTags.Items.COMPUTER)).unlockedBy("has_apple", RecipeProvider.inventoryChange(new ItemLike[]{Items.GOLDEN_APPLE})).save(add);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)ModRegistry.Items.POCKET_COMPUTER_ADVANCED.get())).pattern("###").pattern("#A#").pattern("#G#").define(Character.valueOf('#'), this.ingredients.goldIngot()).define(Character.valueOf('A'), (ItemLike)Items.GOLDEN_APPLE).define(Character.valueOf('G'), this.ingredients.glassPane()).unlockedBy("has_computer", RecipeProvider.inventoryChange(ComputerCraftTags.Items.COMPUTER)).unlockedBy("has_apple", RecipeProvider.inventoryChange(new ItemLike[]{Items.GOLDEN_APPLE})).save(add);
        ((ShapedSpecBuilder)ShapedSpecBuilder.shaped(RecipeCategory.REDSTONE, (ItemLike)ModRegistry.Items.POCKET_COMPUTER_ADVANCED.get()).pattern("###").pattern("#C#").pattern("# #").define('#', this.ingredients.goldIngot()).define('C', (ItemLike)ModRegistry.Items.POCKET_COMPUTER_NORMAL.get()).unlockedBy("has_components", RecipeProvider.inventoryChange(RecipeProvider.itemPredicate((ItemLike)ModRegistry.Items.POCKET_COMPUTER_NORMAL.get()), RecipeProvider.itemPredicate(this.ingredients.goldIngot())))).build(x -> new TransformShapedRecipe((ShapedRecipeSpec)x, List.of(new CopyComponents((ItemLike)ModRegistry.Items.POCKET_COMPUTER_NORMAL.get())))).save(add, ResourceLocation.fromNamespaceAndPath((String)"computercraft", (String)"pocket_computer_advanced_upgrade"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)ModRegistry.Items.PRINTER.get())).pattern("###").pattern("#R#").pattern("#D#").define(Character.valueOf('#'), (ItemLike)Items.STONE).define(Character.valueOf('R'), this.ingredients.redstone()).define(Character.valueOf('D'), this.ingredients.dye()).unlockedBy("has_computer", RecipeProvider.inventoryChange(ComputerCraftTags.Items.COMPUTER)).save(add);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)ModRegistry.Items.SPEAKER.get())).pattern("###").pattern("#N#").pattern("#R#").define(Character.valueOf('#'), (ItemLike)Items.STONE).define(Character.valueOf('N'), (ItemLike)Items.NOTE_BLOCK).define(Character.valueOf('R'), this.ingredients.redstone()).unlockedBy("has_computer", RecipeProvider.inventoryChange(ComputerCraftTags.Items.COMPUTER)).save(add);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)ModRegistry.Items.WIRED_MODEM.get())).pattern("###").pattern("#R#").pattern("###").define(Character.valueOf('#'), (ItemLike)Items.STONE).define(Character.valueOf('R'), this.ingredients.redstone()).unlockedBy("has_computer", RecipeProvider.inventoryChange(ComputerCraftTags.Items.COMPUTER)).unlockedBy("has_cable", RecipeProvider.inventoryChange((ItemLike)ModRegistry.Items.CABLE.get())).save(add);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)ModRegistry.Items.WIRED_MODEM_FULL.get())).requires((ItemLike)ModRegistry.Items.WIRED_MODEM.get()).unlockedBy("has_modem", RecipeProvider.inventoryChange(ComputerCraftTags.Items.WIRED_MODEM)).save(add, ResourceLocation.fromNamespaceAndPath((String)"computercraft", (String)"wired_modem_full_from"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)ModRegistry.Items.WIRED_MODEM.get())).requires((ItemLike)ModRegistry.Items.WIRED_MODEM_FULL.get()).unlockedBy("has_modem", RecipeProvider.inventoryChange(ComputerCraftTags.Items.WIRED_MODEM)).save(add, ResourceLocation.fromNamespaceAndPath((String)"computercraft", (String)"wired_modem_full_to"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)ModRegistry.Items.WIRELESS_MODEM_NORMAL.get())).pattern("###").pattern("#E#").pattern("###").define(Character.valueOf('#'), (ItemLike)Items.STONE).define(Character.valueOf('E'), this.ingredients.enderPearl()).unlockedBy("has_computer", RecipeProvider.inventoryChange(ComputerCraftTags.Items.COMPUTER)).save(add);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)ModRegistry.Items.WIRELESS_MODEM_ADVANCED.get())).pattern("###").pattern("#E#").pattern("###").define(Character.valueOf('#'), this.ingredients.goldIngot()).define(Character.valueOf('E'), (ItemLike)Items.ENDER_EYE).unlockedBy("has_computer", RecipeProvider.inventoryChange(ComputerCraftTags.Items.COMPUTER)).unlockedBy("has_wireless", RecipeProvider.inventoryChange((ItemLike)ModRegistry.Items.WIRELESS_MODEM_NORMAL.get())).save(add);
        ((ShapelessSpecBuilder)ShapelessSpecBuilder.shapeless(RecipeCategory.DECORATIONS, RecipeProvider.playerHead("Cloudhunter", "6d074736-b1e9-4378-a99b-bd8777821c9c")).requires((TagKey<Item>)ItemTags.SKULLS).requires((ItemLike)ModRegistry.Items.MONITOR_NORMAL.get()).unlockedBy("has_monitor", RecipeProvider.inventoryChange((ItemLike)ModRegistry.Items.MONITOR_NORMAL.get()))).build().save(add, ResourceLocation.fromNamespaceAndPath((String)"computercraft", (String)"skull_cloudy"));
        ((ShapelessSpecBuilder)ShapelessSpecBuilder.shapeless(RecipeCategory.DECORATIONS, RecipeProvider.playerHead("dan200", "f3c8d69b-0776-4512-8434-d1b2165909eb")).requires((TagKey<Item>)ItemTags.SKULLS).requires((ItemLike)ModRegistry.Items.COMPUTER_ADVANCED.get()).unlockedBy("has_computer", RecipeProvider.inventoryChange((ItemLike)ModRegistry.Items.COMPUTER_ADVANCED.get()))).build().save(add, ResourceLocation.fromNamespaceAndPath((String)"computercraft", (String)"skull_dan200"));
        Ingredient pages = Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModRegistry.Items.PRINTED_PAGE.get(), (ItemLike)ModRegistry.Items.PRINTED_PAGES.get(), Items.PAPER});
        ((ShapelessSpecBuilder)ShapelessSpecBuilder.shapeless(RecipeCategory.REDSTONE, (ItemLike)ModRegistry.Items.PRINTED_PAGES.get()).requires(this.ingredients.string()).unlockedBy("has_printer", RecipeProvider.inventoryChange((ItemLike)ModRegistry.Items.PRINTER.get()))).build(x -> new PrintoutRecipe((ShapelessRecipeSpec)x, pages, 2)).save(add);
        ((ShapelessSpecBuilder)ShapelessSpecBuilder.shapeless(RecipeCategory.REDSTONE, (ItemLike)ModRegistry.Items.PRINTED_BOOK.get()).requires(this.ingredients.leather()).requires(this.ingredients.string()).unlockedBy("has_printer", RecipeProvider.inventoryChange((ItemLike)ModRegistry.Items.PRINTER.get()))).build(x -> new PrintoutRecipe((ShapelessRecipeSpec)x, pages, 1)).save(add);
    }

    private static DyeColor ofColour(Colour colour) {
        return DyeColor.byId((int)(15 - colour.ordinal()));
    }

    private static Criterion<InventoryChangeTrigger.TriggerInstance> inventoryChange(TagKey<Item> stack) {
        return InventoryChangeTrigger.TriggerInstance.hasItems((ItemPredicate[])new ItemPredicate[]{RecipeProvider.itemPredicate(stack)});
    }

    private static Criterion<InventoryChangeTrigger.TriggerInstance> inventoryChange(ItemLike ... stack) {
        return InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])stack);
    }

    private static Criterion<InventoryChangeTrigger.TriggerInstance> inventoryChange(ItemPredicate ... items) {
        return InventoryChangeTrigger.TriggerInstance.hasItems((ItemPredicate[])items);
    }

    private static ItemPredicate itemPredicate(ItemLike item) {
        return ItemPredicate.Builder.item().of(new ItemLike[]{item}).build();
    }

    private static ItemPredicate itemPredicate(TagKey<Item> item) {
        return ItemPredicate.Builder.item().of(item).build();
    }

    private static ItemPredicate itemPredicate(Ingredient ingredient) {
        JsonElement json = (JsonElement)Ingredient.CODEC_NONEMPTY.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)ingredient).getOrThrow();
        if (!(json instanceof JsonObject)) {
            throw new IllegalStateException("Unknown ingredient " + String.valueOf(json));
        }
        JsonObject object = (JsonObject)json;
        if (object.has("item")) {
            ItemStack item = (ItemStack)ItemStack.SIMPLE_ITEM_CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)object).getOrThrow();
            return RecipeProvider.itemPredicate((ItemLike)item.getItem());
        }
        if (object.has("tag")) {
            return RecipeProvider.itemPredicate((TagKey<Item>)TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.parse((String)GsonHelper.getAsString((JsonObject)object, (String)"tag"))));
        }
        throw new IllegalArgumentException("Unknown ingredient " + String.valueOf(json));
    }

    private static ItemStack playerHead(String name, String uuid) {
        return DataComponentUtil.createStack((ItemLike)Items.PLAYER_HEAD, DataComponents.PROFILE, new ResolvableProfile(new GameProfile(UUID.fromString(uuid), name)));
    }

    private static void addSpecial(RecipeOutput add, Recipe<?> recipe) {
        add.accept(RegistryHelper.getKeyOrThrow(BuiltInRegistries.RECIPE_SERIALIZER, recipe.getSerializer()), recipe, null);
    }
}

