/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.data;

import com.google.gson.JsonElement;
import dan200.computercraft.shared.util.RegistryHelper;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.models.BlockModelGenerators;
import net.minecraft.data.models.ItemModelGenerators;
import net.minecraft.data.models.blockstates.BlockStateGenerator;
import net.minecraft.data.models.model.DelegatedModel;
import net.minecraft.data.models.model.ModelLocationUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public class ModelProvider
implements DataProvider {
    private final PackOutput.PathProvider blockStatePath;
    private final PackOutput.PathProvider modelPath;
    private final Consumer<BlockModelGenerators> blocks;
    private final Consumer<ItemModelGenerators> items;

    public ModelProvider(PackOutput output, Consumer<BlockModelGenerators> blocks, Consumer<ItemModelGenerators> items) {
        this.blockStatePath = output.createPathProvider(PackOutput.Target.RESOURCE_PACK, "blockstates");
        this.modelPath = output.createPathProvider(PackOutput.Target.RESOURCE_PACK, "models");
        this.blocks = blocks;
        this.items = items;
    }

    public CompletableFuture<?> run(CachedOutput output) {
        HashMap blockStates = new HashMap();
        Consumer<BlockStateGenerator> addBlockState = generator -> {
            Block block = generator.getBlock();
            if (blockStates.containsKey(block)) {
                throw new IllegalStateException("Duplicate blockstate definition for " + String.valueOf(block));
            }
            blockStates.put(block, generator);
        };
        HashMap<ResourceLocation, DelegatedModel> models = new HashMap<ResourceLocation, DelegatedModel>();
        BiConsumer<ResourceLocation, Supplier> addModel = (id, contents) -> {
            if (models.containsKey(id)) {
                throw new IllegalStateException("Duplicate model definition for " + String.valueOf(id));
            }
            models.put((ResourceLocation)id, (DelegatedModel)contents);
        };
        HashSet explicitItems = new HashSet();
        this.blocks.accept(new BlockModelGenerators(addBlockState, addModel, explicitItems::add));
        this.items.accept(new ItemModelGenerators(addModel));
        for (Block block : BuiltInRegistries.BLOCK) {
            ResourceLocation model;
            Item item;
            if (!blockStates.containsKey(block) || (item = (Item)Item.BY_BLOCK.get(block)) == null || explicitItems.contains(item) || models.containsKey(model = ModelLocationUtils.getModelLocation((Item)item))) continue;
            models.put(model, new DelegatedModel(ModelLocationUtils.getModelLocation((Block)block)));
        }
        ArrayList futures = new ArrayList();
        this.saveCollection(output, futures, blockStates, x -> this.blockStatePath.json(RegistryHelper.getKeyOrThrow(BuiltInRegistries.BLOCK, x)));
        this.saveCollection(output, futures, models, arg_0 -> ((PackOutput.PathProvider)this.modelPath).json(arg_0));
        return Util.sequenceFailFast(futures);
    }

    private <T> void saveCollection(CachedOutput output, List<CompletableFuture<?>> futures, Map<T, ? extends Supplier<JsonElement>> items, Function<T, Path> getLocation) {
        for (Map.Entry<T, Supplier<JsonElement>> entry : items.entrySet()) {
            Path path = getLocation.apply(entry.getKey());
            futures.add(DataProvider.saveStable((CachedOutput)output, (JsonElement)entry.getValue().get(), (Path)path));
        }
    }

    public String getName() {
        return "Block State Definitions";
    }
}

