/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.data;

import com.mojang.serialization.Codec;
import dan200.computercraft.data.DataProviders;
import dan200.computercraft.data.PrettyDataProvider;
import dan200.computercraft.data.TagProvider;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.BlockTagsProvider;
import net.neoforged.neoforge.common.data.DatapackBuiltinEntriesProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.common.data.JsonCodecProvider;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class Generators {
    @SubscribeEvent
    public static void gather(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        DataProviders.add(new GeneratorFactoryImpl(generator.getVanillaPack(true), event.getExistingFileHelper(), event.getLookupProvider()));
    }

    private record GeneratorFactoryImpl(DataGenerator.PackGenerator generator, ExistingFileHelper existingFiles, CompletableFuture<HolderLookup.Provider> registries) implements DataProviders.GeneratorSink
    {
        @Override
        public <T extends DataProvider> T add(DataProvider.Factory<T> factory) {
            return ((PrettyDataProvider)this.generator.addProvider(p -> new PrettyDataProvider<DataProvider>(factory.create(p)))).provider();
        }

        @Override
        public <T> void addFromCodec(String name, PackType type, String directory, Codec<T> codec, final Consumer<BiConsumer<ResourceLocation, T>> output) {
            this.add(out -> {
                PackOutput.Target target = switch (type) {
                    default -> throw new MatchException(null, null);
                    case PackType.SERVER_DATA -> PackOutput.Target.DATA_PACK;
                    case PackType.CLIENT_RESOURCES -> PackOutput.Target.RESOURCE_PACK;
                };
                return new JsonCodecProvider<T>(this, out, target, directory, type, codec, this.registries, "computercraft", this.existingFiles){

                    protected void gather() {
                        output.accept((arg_0, arg_1) -> (this).unconditional(arg_0, arg_1));
                    }
                };
            });
        }

        @Override
        public TagsProvider<Block> blockTags(final Consumer<TagProvider.TagConsumer<Block>> tags) {
            return (TagsProvider)this.add(out -> new BlockTagsProvider(this, out, this.registries, "computercraft", this.existingFiles){

                protected void addTags(HolderLookup.Provider registries) {
                    tags.accept(x -> new TagProvider.TagAppender(BuiltInRegistries.BLOCK, this.getOrCreateRawBuilder(x)));
                }
            });
        }

        @Override
        public TagsProvider<Item> itemTags(final Consumer<TagProvider.ItemTagConsumer> tags, TagsProvider<Block> blocks) {
            return (TagsProvider)this.add(out -> new ItemTagsProvider(this, out, this.registries, blocks.contentsGetter(), "computercraft", this.existingFiles){

                protected void addTags(HolderLookup.Provider registries) {
                    final 3 self = this;
                    tags.accept(new TagProvider.ItemTagConsumer(){

                        @Override
                        public TagProvider.TagAppender<Item> tag(TagKey<Item> tag) {
                            return new TagProvider.TagAppender<Item>((Registry<Item>)BuiltInRegistries.ITEM, this.getOrCreateRawBuilder(tag));
                        }

                        @Override
                        public void copy(TagKey<Block> block, TagKey<Item> item) {
                            self.copy(block, item);
                        }
                    });
                }
            });
        }

        @Override
        public void registries(CompletableFuture<RegistrySetBuilder.PatchedRegistries> registries) {
            this.add(out -> new DatapackBuiltinEntriesProvider(out, registries, null));
        }
    }
}

