/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.api.turtle;

import javax.annotation.Nullable;

public final class TurtleCommandResult {
    private static final TurtleCommandResult EMPTY_SUCCESS = new TurtleCommandResult(true, null, null);
    private static final TurtleCommandResult EMPTY_FAILURE = new TurtleCommandResult(false, null, null);
    private final boolean success;
    @Nullable
    private final String errorMessage;
    @Nullable
    private final Object[] results;

    public static TurtleCommandResult success() {
        return EMPTY_SUCCESS;
    }

    public static TurtleCommandResult success(@Nullable Object[] results) {
        if (results == null || results.length == 0) {
            return EMPTY_SUCCESS;
        }
        return new TurtleCommandResult(true, null, results);
    }

    public static TurtleCommandResult failure() {
        return EMPTY_FAILURE;
    }

    public static TurtleCommandResult failure(@Nullable String errorMessage) {
        if (errorMessage == null) {
            return EMPTY_FAILURE;
        }
        return new TurtleCommandResult(false, errorMessage, null);
    }

    private TurtleCommandResult(boolean success, @Nullable String errorMessage, @Nullable Object[] results) {
        this.success = success;
        this.errorMessage = errorMessage;
        this.results = results;
    }

    public boolean isSuccess() {
        return this.success;
    }

    @Nullable
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Nullable
    public Object[] getResults() {
        return this.results;
    }
}

