/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.util;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.function.Function;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class CodecsExtras {
    public static final Codec<Long> NON_NEGATIVE_LONG = CodecsExtras.longRangeWithMessage(0L, Long.MAX_VALUE, l -> "Value must be non-negative: " + l);
    public static final Codec<Integer> NETWORK_ID = CodecsExtras.intRangeWithMessage(-1, Integer.MAX_VALUE, i -> "Invalid network ID: " + i);
    public static final Codec<Integer> INTEGER = CodecsExtras.intRangeWithMessage(Integer.MIN_VALUE, Integer.MAX_VALUE, i -> "Invalid integer value: " + i);

    private static Codec<Long> longRangeWithMessage(long min, long max, Function<Long, String> errorMessage) {
        return Codec.LONG.validate(value -> value.compareTo(min) >= 0 && value.compareTo(max) <= 0 ? DataResult.success((Object)value) : DataResult.error(() -> (String)errorMessage.apply((Long)value)));
    }

    private static Codec<Integer> intRangeWithMessage(int min, int max, Function<Integer, String> errorMessage) {
        return Codec.INT.validate(value -> value.compareTo(min) >= 0 && value.compareTo(max) <= 0 ? DataResult.success((Object)value) : DataResult.error(() -> (String)errorMessage.apply((Integer)value)));
    }
}

