/*
 * Decompiled with CFR 0.152.
 */
package dev.g_ab.neovelocity;

import dev.g_ab.neovelocity.NeoVelocity;
import dev.g_ab.neovelocity.NeoVelocityConfig;
import dev.g_ab.neovelocity.VelocityProxy;
import dev.g_ab.neovelocity.mixin.ConnectionAccessorMixin;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.network.Connection;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.login.ClientboundCustomQueryPacket;
import net.minecraft.network.protocol.login.ServerboundCustomQueryAnswerPacket;
import net.minecraft.network.protocol.login.ServerboundHelloPacket;
import net.minecraft.network.protocol.login.custom.CustomQueryAnswerPayload;
import net.minecraft.network.protocol.login.custom.CustomQueryPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.network.ServerLoginPacketListenerImpl;
import net.minecraft.util.StringUtil;
import net.neoforged.fml.ModList;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.NotNull;

public class VelocityLoginPacketListenerImpl
extends ServerLoginPacketListenerImpl {
    private int velocityLoginMessageId = -1;

    public VelocityLoginPacketListenerImpl(MinecraftServer server, Connection connection, boolean transferred) {
        super(server, connection, transferred);
    }

    public void handleHello(ServerboundHelloPacket pPacket) {
        Validate.validState((this.state == ServerLoginPacketListenerImpl.State.HELLO ? 1 : 0) != 0, (String)"Unexpected hello packet", (Object[])new Object[0]);
        Validate.validState((boolean)StringUtil.isValidPlayerName((String)pPacket.name()), (String)"Invalid characters in username", (Object[])new Object[0]);
        this.velocityLoginMessageId = ThreadLocalRandom.current().nextInt(1, Integer.MAX_VALUE);
        this.connection.send((Packet)new ClientboundCustomQueryPacket(this.velocityLoginMessageId, (CustomQueryPayload)new VelocityProxy.VersionPayload(1)));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handleCustomQueryPacket(@NotNull ServerboundCustomQueryAnswerPacket packet) {
        if (!NeoVelocityConfig.COMMON.secretValid) {
            this.disconnect((Component)Component.literal((String)"Invalid server secret configuration."));
            NeoVelocity.getLogger().warn("Invalid secret; failing integrity check.");
            return;
        }
        if (this.velocityLoginMessageId > 0 && packet.transactionId() == this.velocityLoginMessageId) {
            CustomQueryAnswerPayload customQueryAnswerPayload = packet.payload();
            if (customQueryAnswerPayload instanceof VelocityProxy.QueryAnswerPayload) {
                FriendlyByteBuf buffer;
                VelocityProxy.QueryAnswerPayload queryAnswerPayload = (VelocityProxy.QueryAnswerPayload)customQueryAnswerPayload;
                try {
                    FriendlyByteBuf friendlyByteBuf;
                    buffer = friendlyByteBuf = queryAnswerPayload.buffer();
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                if (!VelocityProxy.checkIntegrity(buffer)) {
                    this.disconnect((Component)Component.literal((String)"Unable to verify player details."));
                    NeoVelocity.getLogger().warn("Integrity check failed for {} (Invalid secret)", (Object)this.connection.getRemoteAddress());
                    return;
                }
                int version = buffer.readVarInt();
                if (version > 1) {
                    this.disconnect((Component)Component.literal((String)String.format("Unsupported forwarding version %d, supported up to %d", version, (byte)1)));
                    return;
                }
                SocketAddress listening = this.connection.getRemoteAddress();
                int port = 0;
                if (listening instanceof InetSocketAddress) {
                    port = ((InetSocketAddress)listening).getPort();
                }
                InetSocketAddress address = new InetSocketAddress(VelocityProxy.readAddress(buffer), port);
                ((ConnectionAccessorMixin)this.connection).neovelocity$setAddress(address);
                if (ModList.get().isLoaded("fabric_networking_api_v1")) {
                    this.fixFabricNetworkingIssue();
                }
                this.authenticatedProfile = VelocityProxy.createProfile(buffer);
                this.state = ServerLoginPacketListenerImpl.State.VERIFYING;
                NeoVelocity.getLogger().info("Authenticated {} ({}) via Velocity proxy", (Object)this.authenticatedProfile.getName(), (Object)this.authenticatedProfile.getId());
                return;
            }
            StringBuilder modDump = new StringBuilder("Mod List:\n\tName Version (Mod Id)");
            ModList.get().getMods().forEach(mod -> modDump.append("\n\t").append(mod.getDisplayName()).append(" ").append(mod.getVersion().toString()).append(" (").append(mod.getModId()).append(")"));
            if (((Boolean)NeoVelocityConfig.COMMON.LOGIN_CUSTOM_PACKET_CATCHALL.get()).booleanValue()) {
                this.disconnect((Component)Component.literal((String)"Incompatible mod detected during login.\nThis is a server-side issue. Please contact an administrator."));
                NeoVelocity.getLogger().error("Velocity authentication packets were modified unexpectedly. This is likely caused by an incompatible mod interfering with the login process. Please report this issue at https://github.com/Gabwasnt/NeoVelocity and include the following:\n{}", (Object)modDump);
                return;
            }
            this.disconnect((Component)Component.literal((String)"Unable to verify player details.\nor\nIncompatible mod detected during login.\nThis is a server-side issue. Please contact an administrator."));
            NeoVelocity.getLogger().error("Integrity check failed for {} (Invalid secret) or Velocity authentication packets were modified unexpectedly. This is likely caused by an incompatible mod interfering with the login process. Please report this issue at https://github.com/Gabwasnt/NeoVelocity and include the following:\n{}", (Object)this.connection.getRemoteAddress(), (Object)modDump);
            return;
        }
        super.handleCustomQueryPacket(packet);
    }

    private void fixFabricNetworkingIssue() {
        try {
            Class<?> extClass = Class.forName("net.fabricmc.fabric.impl.networking.NetworkHandlerExtensions");
            Method getAddon = extClass.getMethod("getAddon", new Class[0]);
            Object addon = getAddon.invoke((Object)this, new Object[0]);
            Class<?> addonClass = Class.forName("net.fabricmc.fabric.impl.networking.server.ServerLoginNetworkAddon");
            Field channelsField = addonClass.getDeclaredField("channels");
            channelsField.setAccessible(true);
            Map channels = (Map)channelsField.get(addon);
            channels.remove(this.velocityLoginMessageId);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException e) {
            this.disconnect((Component)Component.literal((String)"Server encountered an error applying the Fabric Networking API workaround.\nThis is a server-side issue. Please contact an administrator."));
            NeoVelocity.getLogger().error("Server-side compatibility workaround for Fabric Networking API v1 failed.", (Throwable)e);
        }
    }
}

