/*
 * Decompiled with CFR 0.152.
 */
package dev.g_ab.neovelocity;

import dev.g_ab.neovelocity.NeoVelocity;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class NeoVelocityConfig {
    public static final Common COMMON;
    static final ModConfigSpec commonSpec;

    public static void register(IEventBus bus, ModContainer mod) {
        bus.addListener(ModConfigEvent.Loading.class, loading -> COMMON.updateSecretFromConfig());
        bus.addListener(ModConfigEvent.Reloading.class, loading -> COMMON.updateSecretFromConfig());
        mod.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)commonSpec);
    }

    static {
        Pair specPair = new ModConfigSpec.Builder().configure(Common::new);
        commonSpec = (ModConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
    }

    public static class Common {
        private static final String PLACEHOLDER = "<YOUR_SECRET_HERE>";
        public final ModConfigSpec.BooleanValue LOGIN_CUSTOM_PACKET_CATCHALL;
        private final ModConfigSpec.ConfigValue<String> SECRET;
        private final ModConfigSpec.EnumValue<SecretType> TYPE;
        public boolean secretValid = false;
        public byte[] secret = new byte[0];

        Common(ModConfigSpec.Builder builder) {
            builder.comment("The forwarding secret is used to authenticate with your Velocity proxy.\nConfiguration for the forwarding secret:\n  - IN_LINE: Use the secret value directly.\n  - FILE   : Load secret from a UTF-8 encoded file, value is a path relative to run directory.");
            builder.push("forwarding");
            this.SECRET = builder.define("forwarding-secret", (Object)PLACEHOLDER);
            this.TYPE = builder.defineEnum("forwarding-secret-type", (Enum)SecretType.IN_LINE);
            builder.pop();
            builder.push("compatibility");
            this.LOGIN_CUSTOM_PACKET_CATCHALL = builder.comment("Configuration for login-custom-packet-catchall:\n  - true : NeoVelocity will treat all login packets as proxy authentication packets (recommended).\n  - false: Only packets signed with your secret are considered proxy authentication packets.\n           This allows unconventional login\u2011phase mods to work, but if your secret is wrong,\n           the server won\u2019t show a clear error.\nIf you see `Took too long to log in` errors, try setting it to `false` to see if it fixes the issue.").define("login-custom-packet-catchall", true);
            builder.pop();
        }

        private void updateSecretFromConfig() {
            block9: {
                this.secretValid = false;
                Arrays.fill(this.secret, (byte)0);
                SecretType type = (SecretType)((Object)this.TYPE.get());
                String raw = (String)this.SECRET.get();
                if (raw.equals(PLACEHOLDER)) {
                    NeoVelocity.getLogger().warn("Config key 'forwarding-secret' is still set to the placeholder default ({}) \u2013 please replace it with your actual Velocity forwarding secret.", (Object)PLACEHOLDER);
                    return;
                }
                if (raw.isEmpty()) {
                    NeoVelocity.getLogger().warn("Config key 'forwarding-secret' is empty \u2013 you must provide your Velocity forwarding secret in the config before running.");
                    return;
                }
                if (type == SecretType.FILE) {
                    try {
                        Path path = Path.of(raw, new String[0]);
                        if (Files.exists(path, new LinkOption[0])) {
                            String content = String.join((CharSequence)"", Files.readAllLines(path));
                            if (!content.isEmpty()) {
                                this.secret = content.getBytes(StandardCharsets.UTF_8);
                                this.secretValid = true;
                                NeoVelocity.getLogger().info("Loaded secret from file {}", (Object)path);
                            } else {
                                NeoVelocity.getLogger().warn("Secret file {} was empty!", (Object)path);
                            }
                            break block9;
                        }
                        NeoVelocity.getLogger().warn("The secret file at {} , is not present!", (Object)path);
                    }
                    catch (IOException | InvalidPathException e) {
                        NeoVelocity.getLogger().warn("Could not load secret from file {}: {}", (Object)raw, (Object)e.getMessage());
                    }
                } else {
                    this.secret = raw.getBytes(StandardCharsets.UTF_8);
                    this.secretValid = true;
                    NeoVelocity.getLogger().info("Loaded inline secret from config.");
                }
            }
        }
    }

    public static enum SecretType {
        IN_LINE,
        FILE;

    }
}

