/*
 * Decompiled with CFR 0.152.
 */
package com.github.talrey.createdeco.api;

import com.github.talrey.createdeco.BlockRegistry;
import com.github.talrey.createdeco.BlockStateGenerator;
import com.github.talrey.createdeco.api.CreateDecoTags;
import com.github.talrey.createdeco.blocks.CatwalkBlock;
import com.github.talrey.createdeco.blocks.CatwalkRailingBlock;
import com.github.talrey.createdeco.blocks.CatwalkStairBlock;
import com.github.talrey.createdeco.connected.CatwalkCTBehaviour;
import com.github.talrey.createdeco.connected.SpriteShifts;
import com.github.talrey.createdeco.items.CatwalkBlockItem;
import com.github.talrey.createdeco.items.CatwalkStairBlockItem;
import com.github.talrey.createdeco.items.RailingBlockItem;
import com.simibubi.create.AllTags;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateRecipeProvider;
import java.util.Locale;
import java.util.function.Supplier;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Direction;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;

public class Catwalks {
    public static BlockBuilder<CatwalkBlock, ?> build(CreateRegistrate reg, String metal) {
        return (BlockBuilder)((BlockBuilder)reg.block(metal.toLowerCase(Locale.ROOT).replaceAll(" ", "_") + "_catwalk", CatwalkBlock::new).properties(props -> props.strength(5.0f, 6.0f).requiresCorrectToolForDrops().noOcclusion().sound(SoundType.NETHERITE_BLOCK)).loot((table, block) -> {
            LootTable.Builder builder = LootTable.lootTable();
            LootPool.Builder catwalksPool = LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f));
            LootPool.Builder supportPool = LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f));
            LootPoolSingletonContainer.Builder catwalks = LootItem.lootTableItem((ItemLike)block);
            catwalks.apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)1.0f)));
            catwalksPool.add((LootPoolEntryContainer.Builder)catwalks);
            table.add((Block)block, builder.withPool(catwalksPool).withPool(supportPool));
        }).addLayer(() -> RenderType::cutoutMipped).tag(new TagKey[]{BlockTags.MINEABLE_WITH_PICKAXE}).tag(new TagKey[]{AllTags.AllBlockTags.FAN_TRANSPARENT.tag}).item(CatwalkBlockItem::new).properties(p -> metal.equals("Netherite") ? p.fireResistant() : p).model((ctx, prov) -> BlockStateGenerator.catwalkItem(metal, ctx, prov)).build()).blockstate((ctx, prov) -> BlockStateGenerator.catwalk(reg, metal, ctx, prov)).onRegister(CreateRegistrate.connectedTextures(new CatwalkCTBehaviour(SpriteShifts.CATWALK_TOPS.get(metal)).getSupplier()));
    }

    public static BlockBuilder<CatwalkStairBlock, ?> buildStair(CreateRegistrate reg, String metal) {
        String regName = metal.toLowerCase(Locale.ROOT).replaceAll(" ", "_");
        String texture = reg.getModid() + ":block/palettes/catwalks/" + regName + "_catwalk";
        return (BlockBuilder)reg.block(metal.toLowerCase(Locale.ROOT).replaceAll(" ", "_") + "_catwalk_stairs", p -> new CatwalkStairBlock((BlockBehaviour.Properties)p, metal)).properties(props -> props.strength(5.0f, 6.0f).requiresCorrectToolForDrops().noOcclusion().sound(SoundType.NETHERITE_BLOCK)).loot((table, block) -> {
            LootTable.Builder builder = LootTable.lootTable();
            LootPool.Builder stairsPool = LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f));
            LootPool.Builder railingsPool = LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f));
            LootPoolSingletonContainer.Builder stairs = LootItem.lootTableItem((ItemLike)block);
            stairs.apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)1.0f)));
            LootPoolSingletonContainer.Builder rails = LootItem.lootTableItem((ItemLike)((ItemLike)BlockRegistry.CATWALK_RAILINGS.get(metal)));
            rails.apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)0.0f)));
            rails.apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)1.0f), (boolean)true).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)CatwalkStairBlock.RAILING_LEFT, true))));
            rails.apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)1.0f), (boolean)true).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)CatwalkStairBlock.RAILING_RIGHT, true))));
            railingsPool.add((LootPoolEntryContainer.Builder)rails);
            stairsPool.add((LootPoolEntryContainer.Builder)stairs);
            table.add((Block)block, builder.withPool(stairsPool).withPool(railingsPool));
        }).addLayer(() -> RenderType::translucent).tag(new TagKey[]{BlockTags.MINEABLE_WITH_PICKAXE}).tag(new TagKey[]{AllTags.AllBlockTags.FAN_TRANSPARENT.tag}).blockstate((ctx, prov) -> BlockStateGenerator.catwalkStair(texture, ctx, prov)).item(CatwalkStairBlockItem::new).build();
    }

    public static BlockBuilder<CatwalkRailingBlock, ?> buildRailing(CreateRegistrate reg, String metal) {
        String regName = metal.toLowerCase(Locale.ROOT).replaceAll(" ", "_");
        String texture = reg.getModid() + ":block/palettes/catwalks/" + regName + "_catwalk";
        return (BlockBuilder)reg.block(metal.toLowerCase(Locale.ROOT).replaceAll(" ", "_") + "_catwalk_railing", CatwalkRailingBlock::new).properties(props -> props.strength(5.0f, 6.0f).requiresCorrectToolForDrops().noOcclusion().sound(SoundType.NETHERITE_BLOCK)).addLayer(() -> RenderType::translucent).tag(new TagKey[]{BlockTags.MINEABLE_WITH_PICKAXE}).tag(new TagKey[]{AllTags.AllBlockTags.FAN_TRANSPARENT.tag}).blockstate((ctx, prov) -> BlockStateGenerator.catwalkRailing(reg, metal, ctx, prov)).recipe((ctx, prov) -> {}).loot((table, block) -> {
            LootTable.Builder builder = LootTable.lootTable();
            LootPool.Builder pool = LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f));
            LootPoolSingletonContainer.Builder entry = LootItem.lootTableItem((ItemLike)block);
            entry.apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)0.0f)));
            for (Direction dir : BlockStateProperties.HORIZONTAL_FACING.getPossibleValues()) {
                entry.apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)1.0f), (boolean)true).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)CatwalkRailingBlock.fromDirection(dir), true))));
            }
            pool.add((LootPoolEntryContainer.Builder)entry);
            table.add((Block)block, builder.withPool(pool));
        }).item(RailingBlockItem::new).build();
    }

    public static <T extends Block> void recipeStonecutting(Supplier<Item> ingot, DataGenContext<Block, T> ctx, RegistrateRecipeProvider prov, int count) {
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ingot.get()}), (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ctx.get()), (int)count).unlockedBy("has_item", InventoryChangeTrigger.TriggerInstance.hasItems((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.item().of(new ItemLike[]{(ItemLike)ingot.get()}).build()})).save((RecipeOutput)prov, ctx.getName() + "_from_stonecutting");
    }

    public static <T extends Block> void recipeStairs(String metal, ItemLike barItem, DataGenContext<Block, T> ctx, RegistrateRecipeProvider prov) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ctx.get()), (int)2).pattern(" c").pattern("cb").define(Character.valueOf('c'), (ItemLike)BlockRegistry.CATWALKS.get(metal).get()).define(Character.valueOf('b'), barItem).unlockedBy("has_item", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)BlockRegistry.CATWALKS.get(metal).get()})).save((RecipeOutput)prov);
    }

    public static <T extends Block> void recipeCatwalk(String metal, ItemLike barItem, DataGenContext<Block, T> ctx, RegistrateRecipeProvider prov) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ctx.get()), (int)4).pattern(" p ").pattern("pBp").pattern(" p ").define(Character.valueOf('p'), CreateDecoTags.plate(metal)).define(Character.valueOf('B'), barItem).unlockedBy("has_item", InventoryChangeTrigger.TriggerInstance.hasItems((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.item().of(CreateDecoTags.plate(metal)).build()})).save((RecipeOutput)prov, ctx.getName() + "_forge");
    }

    public static <T extends Block> void recipeRailing(String metal, ItemLike barItem, DataGenContext<Block, T> ctx, RegistrateRecipeProvider prov) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ctx.get()), (int)8).pattern("ppp").pattern("B B").pattern("B B").define(Character.valueOf('p'), CreateDecoTags.plate(metal)).define(Character.valueOf('B'), barItem).unlockedBy("has_item", InventoryChangeTrigger.TriggerInstance.hasItems((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.item().of(CreateDecoTags.plate(metal)).build()})).save((RecipeOutput)prov, ctx.getName() + "_forge");
    }
}

