/*
 * Decompiled with CFR 0.152.
 */
package dev.averageanime.neoforge.fluid;

import com.mojang.blaze3d.shaders.FogShape;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.averageanime.neoforge.CreateFood;
import dev.averageanime.neoforge.block.ModBlocks;
import dev.averageanime.neoforge.fluid.ModFluids;
import dev.averageanime.neoforge.item.ModItems;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.util.function.Consumer;
import javax.imageio.ImageIO;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.common.SoundAction;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredItem;
import org.joml.Vector3f;

public class FluidEntry {
    private final String name;
    private Vector3f fogColor = null;
    private int density = 1400;
    private int viscosity = 1500;
    private int lightLevel = 0;
    private int slopeFindDistance = 4;
    private int levelDecreasePerBlock = 3;
    private SoundEvent drinkSound = SoundEvents.HONEY_DRINK;

    public FluidEntry(String name) {
        this.name = name;
    }

    public FluidEntry color(float r, float g, float b) {
        this.fogColor = new Vector3f(r, g, b);
        return this;
    }

    public FluidEntry color(Vector3f color) {
        this.fogColor = color;
        return this;
    }

    public FluidEntry physics(int density, int viscosity) {
        this.density = density;
        this.viscosity = viscosity;
        return this;
    }

    public FluidEntry flow(int slopeFindDistance, int levelDecreasePerBlock) {
        this.slopeFindDistance = slopeFindDistance;
        this.levelDecreasePerBlock = levelDecreasePerBlock;
        return this;
    }

    public FluidEntry lightLevel(int lightLevel) {
        this.lightLevel = lightLevel;
        return this;
    }

    public FluidEntry drinkSound(SoundEvent sound) {
        this.drinkSound = sound;
        return this;
    }

    public FluidType build() {
        Vector3f finalColor = this.fogColor;
        if (finalColor == null) {
            finalColor = FluidEntry.extractColorFromTexture(this.name);
        }
        FluidType.Properties properties = FluidType.Properties.create().lightLevel(this.lightLevel).sound(SoundAction.get((String)"drink"), this.drinkSound).density(this.density).viscosity(this.viscosity);
        return new FluidType(this.name, finalColor, properties, this.slopeFindDistance, this.levelDecreasePerBlock);
    }

    private static Vector3f extractColorFromTexture(String fluidName) {
        try {
            String texturePath = "/assets/createfood/textures/fluid/" + fluidName + "_still.png";
            InputStream stream = FluidEntry.class.getResourceAsStream(texturePath);
            if (stream == null) {
                CreateFood.LOGGER.warn("Could not find texture for fluid: {} at path: {}", (Object)fluidName, (Object)texturePath);
                return new Vector3f(1.0f, 1.0f, 1.0f);
            }
            BufferedImage image = ImageIO.read(stream);
            stream.close();
            if (image == null) {
                CreateFood.LOGGER.warn("Could not read texture for fluid: {}", (Object)fluidName);
                return new Vector3f(1.0f, 1.0f, 1.0f);
            }
            long totalR = 0L;
            long totalG = 0L;
            long totalB = 0L;
            long totalAlpha = 0L;
            int width = image.getWidth();
            int height = image.getHeight();
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    int pixel = image.getRGB(x, y);
                    int alpha = pixel >> 24 & 0xFF;
                    int red = pixel >> 16 & 0xFF;
                    int green = pixel >> 8 & 0xFF;
                    int blue = pixel & 0xFF;
                    totalR += (long)(red * alpha);
                    totalG += (long)(green * alpha);
                    totalB += (long)(blue * alpha);
                    totalAlpha += (long)alpha;
                }
            }
            if (totalAlpha == 0L) {
                CreateFood.LOGGER.warn("Texture for fluid {} is fully transparent", (Object)fluidName);
                return new Vector3f(1.0f, 1.0f, 1.0f);
            }
            float r = (float)(totalR / totalAlpha) / 255.0f;
            float g = (float)(totalG / totalAlpha) / 255.0f;
            float b = (float)(totalB / totalAlpha) / 255.0f;
            return new Vector3f(r, g, b);
        }
        catch (Exception e) {
            CreateFood.LOGGER.error("Error extracting color from texture for fluid: {}", (Object)fluidName, (Object)e);
            return new Vector3f(1.0f, 1.0f, 1.0f);
        }
    }

    public static class FluidType {
        public final DeferredHolder<net.neoforged.neoforge.fluids.FluidType, net.neoforged.neoforge.fluids.FluidType> FLUID_TYPE;
        public final DeferredHolder<Fluid, FlowingFluid> SOURCE;
        public final DeferredHolder<Fluid, FlowingFluid> FLOWING;
        public final DeferredBlock<LiquidBlock> BLOCK;
        public final DeferredItem<Item> BUCKET;
        private final ResourceLocation stillTexture;
        private final ResourceLocation flowingTexture;
        private final int slopeFindDistance;
        private final int levelDecreasePerBlock;

        public FluidType(String name, final Vector3f fogColor, FluidType.Properties fluidTypeProperties, int slopeFindDistance, int levelDecreasePerBlock) {
            this.stillTexture = ResourceLocation.fromNamespaceAndPath((String)"createfood", (String)("fluid/" + name + "_still"));
            this.flowingTexture = ResourceLocation.fromNamespaceAndPath((String)"createfood", (String)("fluid/" + name + "_flow"));
            this.slopeFindDistance = slopeFindDistance;
            this.levelDecreasePerBlock = levelDecreasePerBlock;
            this.FLUID_TYPE = ModFluids.FLUID_TYPES.register(name, () -> new net.neoforged.neoforge.fluids.FluidType(fluidTypeProperties){

                public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
                    consumer.accept(new IClientFluidTypeExtensions(){

                        public ResourceLocation getStillTexture() {
                            return stillTexture;
                        }

                        public ResourceLocation getFlowingTexture() {
                            return flowingTexture;
                        }

                        public Vector3f modifyFogColor(Camera camera, float partialTick, ClientLevel level, int renderDistance, float darkenWorldAmount, Vector3f fluidFogColor) {
                            return fogColor;
                        }

                        public void modifyFogRender(Camera camera, FogRenderer.FogMode mode, float renderDistance, float partialTick, float nearDistance, float farDistance, FogShape shape) {
                            RenderSystem.setShaderFogColor((float)fogColor.x(), (float)fogColor.y(), (float)fogColor.z());
                            RenderSystem.setShaderFogStart((float)0.5f);
                            RenderSystem.setShaderFogEnd((float)1.5f);
                            RenderSystem.setShaderFogShape((FogShape)FogShape.CYLINDER);
                        }
                    });
                }
            });
            this.SOURCE = ModFluids.FLUIDS.register(name, () -> new BaseFlowingFluid.Source(this.createFluidPropertiesInternal()));
            this.FLOWING = ModFluids.FLUIDS.register("flowing_" + name, () -> new BaseFlowingFluid.Flowing(this.createFluidPropertiesInternal()));
            this.BLOCK = ModBlocks.BLOCKS.register(name + "_block", () -> new LiquidBlock((FlowingFluid)this.SOURCE.get(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WATER)));
            this.BUCKET = ModItems.ITEMS.register(name + "_bucket", () -> new BucketItem((Fluid)this.SOURCE.get(), new Item.Properties().stacksTo(1).craftRemainder(Items.BUCKET)));
        }

        private BaseFlowingFluid.Properties createFluidPropertiesInternal() {
            return new BaseFlowingFluid.Properties(this.FLUID_TYPE, this.SOURCE, this.FLOWING).slopeFindDistance(this.slopeFindDistance).levelDecreasePerBlock(this.levelDecreasePerBlock).block(this.BLOCK).bucket(this.BUCKET).tickRate(25);
        }
    }
}

