/*
 * Decompiled with CFR 0.152.
 */
package dev.averageanime.neoforge.datagen.provider;

import dev.averageanime.neoforge.block.ModDisplayBlocks;
import dev.averageanime.neoforge.block.type.display.BottleFoodBlock;
import dev.averageanime.neoforge.block.type.display.BowlFoodBlock;
import dev.averageanime.neoforge.block.type.display.PlateFoodBlock;
import dev.averageanime.neoforge.block.type.display.SaladBowlFoodBlock;
import dev.averageanime.neoforge.block.type.display.SmallPlateFoodBlock;
import dev.averageanime.neoforge.block.type.display.plate.PlateBlock;
import java.util.Set;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.predicates.ExplosionCondition;
import net.minecraft.world.level.storage.loot.predicates.InvertedLootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.neoforged.neoforge.registries.DeferredBlock;

public class LootTablesProvider
extends BlockLootSubProvider {
    public LootTablesProvider(HolderLookup.Provider registries) {
        super(Set.of(), FeatureFlags.REGISTRY.allFlags(), registries);
    }

    protected void generate() {
        ModDisplayBlocks.BLOCKS.getEntries().forEach(blockEntry -> {
            Block block = (Block)blockEntry.get();
            if (block instanceof BottleFoodBlock) {
                this.bottleBlockLoot((DeferredBlock<Block>)((DeferredBlock)blockEntry));
            } else if (block instanceof BowlFoodBlock) {
                this.bowlBlockLoot((DeferredBlock<Block>)((DeferredBlock)blockEntry));
            } else if (block instanceof SaladBowlFoodBlock) {
                this.bowlBlockLoot((DeferredBlock<Block>)((DeferredBlock)blockEntry));
            } else if (block instanceof PlateFoodBlock) {
                this.bowlBlockLoot((DeferredBlock<Block>)((DeferredBlock)blockEntry));
            } else if (block instanceof SmallPlateFoodBlock) {
                this.smallPlateBlockLoot((DeferredBlock<Block>)((DeferredBlock)blockEntry));
            } else if (block instanceof PlateBlock) {
                this.plateBlockLoot((DeferredBlock<Block>)((DeferredBlock)blockEntry));
            }
        });
    }

    private void bottleBlockLoot(DeferredBlock<Block> block) {
        Block theBlock = (Block)block.get();
        if (theBlock instanceof BottleFoodBlock) {
            BottleFoodBlock bottleBlock = (BottleFoodBlock)theBlock;
            Item bottleItem = (Item)bottleBlock.displayItem.get();
            this.add(theBlock, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)theBlock)).when(ExplosionCondition.survivesExplosion())));
        }
    }

    private void bowlBlockLoot(DeferredBlock<Block> block) {
        Block theBlock = (Block)block.get();
        if (theBlock instanceof BowlFoodBlock) {
            BowlFoodBlock bowlBlock = (BowlFoodBlock)theBlock;
            Item bowlItem = (Item)bowlBlock.displayItem.get();
            this.add(theBlock, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)theBlock)).when(ExplosionCondition.survivesExplosion())));
        } else if (theBlock instanceof SaladBowlFoodBlock) {
            SaladBowlFoodBlock bowlBlock = (SaladBowlFoodBlock)theBlock;
            Item bowlItem = (Item)bowlBlock.displayItem.get();
            this.add(theBlock, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)theBlock)).when(ExplosionCondition.survivesExplosion())));
        } else if (theBlock instanceof PlateFoodBlock) {
            PlateFoodBlock bowlBlock = (PlateFoodBlock)theBlock;
            Item bowlItem = (Item)bowlBlock.displayItem.get();
            this.add(theBlock, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)theBlock)).when(ExplosionCondition.survivesExplosion())));
        }
    }

    private void smallPlateBlockLoot(DeferredBlock<Block> block) {
        Block theBlock = (Block)block.get();
        if (theBlock instanceof SmallPlateFoodBlock) {
            LootTable.Builder builder = LootTable.lootTable();
            builder.withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)theBlock)).when(ExplosionCondition.survivesExplosion()));
            this.add(theBlock, builder);
        }
    }

    private void plateBlockLoot(DeferredBlock<Block> block) {
        Block theBlock = (Block)block.get();
        if (theBlock instanceof PlateBlock) {
            PlateBlock plateBlock = (PlateBlock)theBlock;
            Item foodItem = (Item)plateBlock.displayItem.get();
            int maxStack = plateBlock.maxStackSize;
            LootTable.Builder builder = LootTable.lootTable();
            builder.withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)theBlock)).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)theBlock).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)PlateBlock.STACK_SIZE, maxStack))));
            for (int stack = 1; stack < maxStack; ++stack) {
                builder.withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)stack)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)foodItem)).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)theBlock).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)PlateBlock.STACK_SIZE, stack))));
            }
            builder.withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.BOWL)).when(InvertedLootItemCondition.invert((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)theBlock).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)PlateBlock.STACK_SIZE, maxStack)))));
            this.add(theBlock, builder);
        }
    }

    protected Iterable<Block> getKnownBlocks() {
        return ModDisplayBlocks.BLOCKS.getEntries().stream().map(holder -> (Block)holder.get()).toList();
    }
}

