/*
 * Decompiled with CFR 0.152.
 */
package dev.averageanime.neoforge.datagen.provider;

import dev.averageanime.neoforge.block.ModDisplayBlocks;
import dev.averageanime.neoforge.block.type.display.BottleFoodBlock;
import dev.averageanime.neoforge.block.type.display.BowlFoodBlock;
import dev.averageanime.neoforge.block.type.display.PlateFoodBlock;
import dev.averageanime.neoforge.block.type.display.SaladBowlFoodBlock;
import dev.averageanime.neoforge.block.type.display.SmallPlateFoodBlock;
import dev.averageanime.neoforge.block.type.display.plate.PlateBlock;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredBlock;

public class ItemModelProvider
extends net.neoforged.neoforge.client.model.generators.ItemModelProvider {
    public ItemModelProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "createfood", existingFileHelper);
    }

    protected void registerModels() {
        ModDisplayBlocks.BLOCKS.getEntries().forEach(blockEntry -> {
            Block block = (Block)blockEntry.get();
            if (block instanceof PlateBlock) {
                PlateBlock plateBlock = (PlateBlock)block;
                this.plateBlockItem((DeferredBlock<Block>)((DeferredBlock)blockEntry), plateBlock.maxStackSize);
            } else if (block instanceof BottleFoodBlock || block instanceof BowlFoodBlock || block instanceof SaladBowlFoodBlock || block instanceof SmallPlateFoodBlock || block instanceof PlateFoodBlock) {
                this.simpleBlockItem((DeferredBlock<Block>)((DeferredBlock)blockEntry));
            }
        });
    }

    private void simpleBlockItem(DeferredBlock<Block> block) {
        String name = block.getId().getPath();
        ((ItemModelBuilder)this.getBuilder(name)).parent((ModelFile)new ModelFile.UncheckedModelFile(ResourceLocation.fromNamespaceAndPath((String)"createfood", (String)("block/" + name))));
    }

    private void plateBlockItem(DeferredBlock<Block> block, int maxStack) {
        String name = block.getId().getPath();
        ((ItemModelBuilder)this.getBuilder(name)).parent((ModelFile)new ModelFile.UncheckedModelFile(ResourceLocation.fromNamespaceAndPath((String)"createfood", (String)("block/" + name + "_" + maxStack))));
    }
}

