/*
 * Decompiled with CFR 0.152.
 */
package dev.averageanime.neoforge.datagen.provider;

import dev.averageanime.neoforge.block.ModDisplayBlocks;
import dev.averageanime.neoforge.block.type.display.BottleFoodBlock;
import dev.averageanime.neoforge.block.type.display.BowlFoodBlock;
import dev.averageanime.neoforge.block.type.display.PlateFoodBlock;
import dev.averageanime.neoforge.block.type.display.SaladBowlFoodBlock;
import dev.averageanime.neoforge.block.type.display.SmallPlateFoodBlock;
import dev.averageanime.neoforge.block.type.display.plate.PlateBlock;
import net.minecraft.core.Direction;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.client.model.generators.VariantBlockStateBuilder;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredBlock;

public class BlockStateProvider
extends net.neoforged.neoforge.client.model.generators.BlockStateProvider {
    public BlockStateProvider(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, "createfood", exFileHelper);
    }

    protected void registerStatesAndModels() {
        ModDisplayBlocks.BLOCKS.getEntries().forEach(blockEntry -> {
            Block block = (Block)blockEntry.get();
            if (block instanceof BottleFoodBlock) {
                this.bottleBlock((DeferredBlock<Block>)((DeferredBlock)blockEntry));
            } else if (block instanceof BowlFoodBlock) {
                this.bowlBlock((DeferredBlock<Block>)((DeferredBlock)blockEntry));
            } else if (block instanceof SaladBowlFoodBlock) {
                this.bowlBlock((DeferredBlock<Block>)((DeferredBlock)blockEntry));
            } else if (block instanceof PlateFoodBlock) {
                this.bowlBlock((DeferredBlock<Block>)((DeferredBlock)blockEntry));
            } else if (block instanceof SmallPlateFoodBlock) {
                this.smallPlateBlock((DeferredBlock<Block>)((DeferredBlock)blockEntry));
            } else if (block instanceof PlateBlock) {
                this.plateBlock((DeferredBlock<Block>)((DeferredBlock)blockEntry));
            }
        });
    }

    private void bottleBlock(DeferredBlock<Block> block) {
        Block theBlock = (Block)block.get();
        String name = block.getId().getPath();
        VariantBlockStateBuilder builder = this.getVariantBuilder(theBlock);
        for (int stack = 1; stack <= 9; ++stack) {
            for (Direction facing : Direction.Plane.HORIZONTAL) {
                int yRot = this.getYRotation(facing);
                Object model = stack == 1 ? new ModelFile.UncheckedModelFile(ResourceLocation.fromNamespaceAndPath((String)"createfood", (String)("block/" + name))) : this.models().withExistingParent("empty_" + stack, "minecraft:block/air");
                builder.partialState().with((Property)BottleFoodBlock.FACING, (Comparable)facing).with((Property)BottleFoodBlock.STACK_SIZE, (Comparable)Integer.valueOf(stack)).setModels(ConfiguredModel.builder().modelFile((ModelFile)model).rotationY(yRot).build());
            }
        }
    }

    private void bowlBlock(DeferredBlock<Block> block) {
        Block theBlock = (Block)block.get();
        String name = block.getId().getPath();
        VariantBlockStateBuilder builder = this.getVariantBuilder(theBlock);
        for (int stack = 1; stack <= 9; ++stack) {
            for (Direction facing : Direction.Plane.HORIZONTAL) {
                int yRot = this.getYRotation(facing);
                Object model = stack == 1 ? new ModelFile.UncheckedModelFile(ResourceLocation.fromNamespaceAndPath((String)"createfood", (String)("block/" + name))) : this.models().withExistingParent("empty_bowl_" + stack, "minecraft:block/air");
                builder.partialState().with((Property)BowlFoodBlock.FACING, (Comparable)facing).with((Property)BowlFoodBlock.STACK_SIZE, (Comparable)Integer.valueOf(stack)).setModels(ConfiguredModel.builder().modelFile((ModelFile)model).rotationY(yRot).build());
            }
        }
    }

    private void smallPlateBlock(DeferredBlock<Block> block) {
        Block theBlock = (Block)block.get();
        String name = block.getId().getPath();
        VariantBlockStateBuilder builder = this.getVariantBuilder(theBlock);
        for (int stack = 1; stack <= 9; ++stack) {
            for (Direction facing : Direction.Plane.HORIZONTAL) {
                int yRot = this.getYRotation(facing);
                Object model = stack == 1 ? new ModelFile.UncheckedModelFile(ResourceLocation.fromNamespaceAndPath((String)"createfood", (String)("block/" + name))) : this.models().withExistingParent("empty_small_plate_" + stack, "minecraft:block/air");
                builder.partialState().with((Property)SmallPlateFoodBlock.FACING, (Comparable)facing).with((Property)SmallPlateFoodBlock.STACK_SIZE, (Comparable)Integer.valueOf(stack)).setModels(ConfiguredModel.builder().modelFile((ModelFile)model).rotationY(yRot).build());
            }
        }
    }

    private void plateBlock(DeferredBlock<Block> block) {
        Block theBlock = (Block)block.get();
        String name = block.getId().getPath();
        PlateBlock plateBlock = (PlateBlock)theBlock;
        int maxStack = plateBlock.maxStackSize;
        VariantBlockStateBuilder builder = this.getVariantBuilder(theBlock);
        for (int stack = 1; stack <= 9; ++stack) {
            for (Direction facing : Direction.Plane.HORIZONTAL) {
                int yRot = this.getYRotation(facing);
                Object model = stack <= maxStack ? new ModelFile.UncheckedModelFile(ResourceLocation.fromNamespaceAndPath((String)"createfood", (String)("block/" + name + "_" + stack))) : this.models().withExistingParent("empty_plate_" + stack, "minecraft:block/air");
                builder.partialState().with((Property)PlateBlock.FACING, (Comparable)facing).with((Property)PlateBlock.STACK_SIZE, (Comparable)Integer.valueOf(stack)).setModels(ConfiguredModel.builder().modelFile((ModelFile)model).rotationY(yRot).build());
            }
        }
    }

    private int getYRotation(Direction facing) {
        return switch (facing) {
            case Direction.SOUTH -> 0;
            case Direction.WEST -> 90;
            case Direction.NORTH -> 180;
            case Direction.EAST -> 270;
            default -> 0;
        };
    }
}

