/*
 * Decompiled with CFR 0.152.
 */
package dev.averageanime.neoforge.datagen;

import dev.averageanime.neoforge.datagen.provider.BlockStateProvider;
import dev.averageanime.neoforge.datagen.provider.ItemModelProvider;
import dev.averageanime.neoforge.datagen.provider.LootTablesProvider;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(modid="createfood", bus=EventBusSubscriber.Bus.MOD)
public class DataGen {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(event.includeClient(), (DataProvider)new BlockStateProvider(output, existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new ItemModelProvider(output, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new LootTableProvider(output, Collections.emptySet(), List.of(new LootTableProvider.SubProviderEntry(LootTablesProvider::new, LootContextParamSets.BLOCK)), lookupProvider));
    }
}

