/*
 * Decompiled with CFR 0.152.
 */
package dev.averageanime.neoforge.config.condition;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.averageanime.neoforge.config.ModConfig;
import java.util.List;
import net.neoforged.neoforge.common.conditions.ICondition;
import org.jetbrains.annotations.NotNull;

public record EnabledCondition(List<String> itemIds) implements ICondition
{
    public static final MapCodec<EnabledCondition> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Codec.STRING.listOf().optionalFieldOf("ids", List.of()).forGetter(EnabledCondition::itemIds), (App)Codec.STRING.optionalFieldOf("id", (Object)"").forGetter(c -> c.itemIds.isEmpty() ? "" : c.itemIds.getFirst())).apply((Applicative)builder, (ids, singleId) -> {
        List<String> finalIds = !ids.isEmpty() ? ids : (!singleId.isEmpty() ? List.of(singleId) : List.of());
        return new EnabledCondition(finalIds);
    }));

    public boolean test(@NotNull ICondition.IContext context) {
        if (this.itemIds.isEmpty()) {
            return true;
        }
        for (String itemId : this.itemIds) {
            if (ModConfig.isItemEnabled(itemId)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public MapCodec<? extends ICondition> codec() {
        return CODEC;
    }
}

