/*
 * Decompiled with CFR 0.152.
 */
package dev.averageanime.neoforge.config;

import java.util.List;
import net.neoforged.neoforge.common.ModConfigSpec;

public class ModConfig {
    public static final ModConfigSpec.Builder BUILDER = new ModConfigSpec.Builder();
    public static final ModConfigSpec.ConfigValue<List<? extends String>> DISABLE_ITEMS = BUILDER.defineListAllowEmpty("disable_items", List.of("beef_bun_peanut_butter", "beef_bun_peanut_butter_bacon", "bread_slice_peanut_butter", "caramel_popcorn", "cinnamon_sweet_roll_base", "coffee_toffee", "coffee_toffee_fudge", "corn_flour", "corn_stick", "dragon_bun", "dragon_bun_crimson_fungus", "dragon_bun_warped_fungus", "dragon_burger", "dragon_burger_crimson_fungus", "dragon_burger_warped_fungus", "dragon_patty", "dried_coffee_beans", "eggplant_bun", "eggplant_bun_cheese", "eggplant_bun_cheese_lettuce", "eggplant_bun_cheese_lettuce_tomato", "eggplant_bun_cheese_tomato", "eggplant_bun_lettuce", "eggplant_bun_lettuce_tomato", "eggplant_bun_tomato", "eggplant_burger", "eggplant_burger_lettuce", "eggplant_burger_tomato", "eggplant_cheeseburger", "eggplant_cheeseburger_lettuce", "eggplant_cheeseburger_lettuce_tomato", "eggplant_cheeseburger_tomato", "endermite_meatball", "endermite_meatball_sandwich", "endermite_meatball_stick_1", "endermite_meatball_stick_2", "endermite_meatball_stick_3", "espresso_powder", "ground_endermite", "hamburger_peanut_butter", "hamburger_peanut_butter_bacon", "marshmallow_coffee_toffee_fudge", "marshmallow_dark_chocolate", "minced_dragon", "paprika", "pasta_plate_eggplant", "pasta_plate_endermite_meatballs", "pasta_plate_endermite_meatballs_tomato_sauce", "pasta_plate_strider_meatballs", "pasta_plate_strider_meatballs_tomato_sauce", "peanut_butter_apple_jam_sandwich", "peanut_butter_chorus_fruit_jam_sandwich", "peanut_butter_melon_jam_sandwich", "raw_cinnamon_sweet_roll_base", "raw_endermite_meatball", "raw_flesh_cookie", "raw_ginger_cookie", "raw_green_tea_cookie", "raw_soul_berry_cookie", "raw_spider_eye_cookie", "raw_strider_meatball", "raw_sugar_cookie", "raw_ube_cake_base", "raw_ube_cookie", "small_endermite_meatballs", "small_strider_meatballs", "spicy_chicken_nuggets", "spicy_sausages", "strider_meatball", "strider_meatball_sandwich", "strider_meatball_stick_1", "strider_meatball_stick_2", "strider_meatball_stick_3", "tortilla_chip_bowl", "ube_cake_base", "ube_cream_frosting_bottle", "ube_cream_frosting_piping_bag", "ube_cream_ube_cake", "ube_cream_ube_cake_slice", "ube_sugar_dough"), () -> "item_id", obj -> obj instanceof String);
    public static final ModConfigSpec.ConfigValue<List<? extends String>> CUSTOM_TOOLTIPS;
    public static final ModConfigSpec.BooleanValue REQUIRE_SHIFT_FOR_TOOLTIPS;
    public static final ModConfigSpec.BooleanValue SHOW_COMPATIBILITY;
    public static final ModConfigSpec.BooleanValue SHOW_INGREDIENTS;

    public static boolean isItemEnabled(String itemId) {
        try {
            List disabledItems = (List)DISABLE_ITEMS.get();
            return !disabledItems.contains(itemId);
        }
        catch (IllegalStateException e) {
            return true;
        }
    }

    public static boolean isDisplayBlockEnabled(String blockId) {
        if (!ModConfig.isItemEnabled(blockId)) {
            return false;
        }
        String baseItemId = ModConfig.extractBaseItemId(blockId);
        return ModConfig.isItemEnabled(baseItemId);
    }

    private static String extractBaseItemId(String blockId) {
        return blockId.replace("_plate_block", "").replace("_small_plate_block", "").replace("_bowl_block", "").replace("_bottle_block", "").replace("_block", "");
    }

    static {
        BUILDER.push("tooltips");
        SHOW_COMPATIBILITY = BUILDER.define("show_compatibility", true);
        SHOW_INGREDIENTS = BUILDER.define("show_ingredients", true);
        REQUIRE_SHIFT_FOR_TOOLTIPS = BUILDER.define("require_shift", false);
        CUSTOM_TOOLTIPS = BUILDER.gameRestart().defineListAllowEmpty("custom_tooltips", List.of("create:chocolate_glazed_berries|chocolate", "create:honeyed_apple|honey", "create:sweet_roll|cream_frosting", "culturaldelights:avocado_toast|avocado", "culturaldelights:eggplant_burger|lettuce,tomato", "culturaldelights:mutton_sandwich|mutton,beetroot,fried_egg", "culturaldelights:pork_wrap|pork,apple,lettuce", "delightfulcreators:incomplete_chicken_sandwich|chicken", "delightfulcreators:incomplete_pasta_with_meatballs|beef_meatballs", "delightfulcreators:incomplete_pasta_with_mutton_chop|mutton", "delightfulcreators:incomplete_squid_ink_pasta|squid_ink", "displaydelight:ctd_plated_avocado_toast|avocado", "displaydelight:ctd_plated_eggplant_burger|lettuce,tomato", "displaydelight:ctd_plated_mutton_sandwich|mutton,fried_egg,beetroot", "displaydelight:ctd_plated_pork_wrap|pork,apple,lettuce", "displaydelight:ed_plated_berry_sweet_roll|cream_frosting,berry", "displaydelight:ed_plated_glow_berry_jelly_sandwich|peanut_butter,glow_berry", "displaydelight:ed_plated_glow_berry_sweet_roll|cream_frosting,glow_berry", "displaydelight:ed_plated_peanut_butter_honey_sandwich|peanut_butter", "displaydelight:ed_plated_sweet_berry_jelly_sandwich|peanut_butter,berry", "displaydelight:ed_plated_sweet_roll|cream_frosting", "displaydelight:mixed_salad|beetroot,tomato", "displaydelight:pasta_with_meatballs|tomato_sauce,beef_meatballs", "displaydelight:pasta_with_mutton_chop|tomato_sauce,mutton", "displaydelight:plated_bacon_sandwich|bacon,lettuce,tomato", "displaydelight:plated_chicken_sandwich|chicken,lettuce,carrot", "displaydelight:plated_egg_sandwich|fried_egg", "displaydelight:plated_hamburger|onion,lettuce,tomato", "displaydelight:plated_mutton_wrap|mutton,onion,lettuce", "displaydelight:small_plated_cake_slice|cream_frosting,berry", "displaydelight:squid_ink_pasta|squid_ink,fish", "expandeddelight:berry_sweet_roll|berry", "expandeddelight:glow_berry_jelly_sandwich|peanut_butter,glow_berry_jam", "expandeddelight:glow_berry_sweet_roll|glow_berry", "expandeddelight:peanut_butter_honey_sandwich|peanut_butter", "expandeddelight:sweet_berry_jelly_sandwich|peanut_butter,berry_jam", "farmersdelight:bacon_sandwich|bacon,lettuce,tomato", "farmersdelight:cake_slice|cream_frosting,berry", "farmersdelight:chicken_sandwich|chicken,lettuce,carrot", "farmersdelight:egg_sandwich|fried_egg", "farmersdelight:hamburger|onion,lettuce,tomato", "farmersdelight:mixed_salad|beetroot,tomato", "farmersdelight:mutton_wrap|mutton,onion,lettuce", "farmersdelight:pasta_with_meatballs|tomato_sauce,beef_meatballs", "farmersdelight:pasta_with_mutton_chop|tomato_sauce,mutton", "farmersdelight:squid_ink_pasta|squid_ink,fish", "farmersdelight:sweet_berry_cookie|berry", "minecraft:cake|cream_frosting,berry", "minecraft:cookie|chocolate_chips"), () -> "item_key|ingredients", obj -> obj instanceof String);
        BUILDER.pop();
    }
}

