/*
 * Decompiled with CFR 0.152.
 */
package dev.averageanime.neoforge.block.type.pie;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import vectorwing.farmersdelight.common.block.PieBlock;

public class ModPieBlock
extends PieBlock {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    protected static VoxelShape[] SHAPE_BY_BITE = new VoxelShape[]{Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)4.0, (double)14.0), Shapes.or((VoxelShape)Block.box((double)2.0, (double)0.0, (double)8.0, (double)8.0, (double)4.0, (double)14.0), (VoxelShape)Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)4.0, (double)8.0)), Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)4.0, (double)8.0), Block.box((double)8.0, (double)0.0, (double)2.0, (double)14.0, (double)4.0, (double)8.0)};

    public ModPieBlock(BlockBehaviour.Properties properties, Supplier<Item> pieSlice) {
        super(properties, pieSlice);
    }

    @NotNull
    public VoxelShape getShape(BlockState State, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        VoxelShape baseShape = SHAPE_BY_BITE[(Integer)State.getValue((Property)BITES)];
        Direction facing = (Direction)State.getValue((Property)FACING);
        if (facing == Direction.EAST) {
            return this.rotateShape(baseShape, Direction.EAST);
        }
        if (facing == Direction.SOUTH) {
            return this.rotateShape(baseShape, Direction.SOUTH);
        }
        if (facing == Direction.WEST) {
            return this.rotateShape(baseShape, Direction.WEST);
        }
        return baseShape;
    }

    private VoxelShape rotateShape(VoxelShape shape, Direction direction) {
        VoxelShape[] buffer = new VoxelShape[]{shape, Shapes.empty()};
        int times = (direction.get2DDataValue() - Direction.NORTH.get2DDataValue() + 4) % 4;
        for (int i = 0; i < times; ++i) {
            buffer[0].forAllBoxes((minX, minY, minZ, maxX, maxY, maxZ) -> {
                buffer[1] = Shapes.or((VoxelShape)buffer[1], (VoxelShape)Shapes.box((double)(1.0 - maxZ), (double)minY, (double)minX, (double)(1.0 - minZ), (double)maxY, (double)maxX));
            });
            buffer[0] = buffer[1];
            buffer[1] = Shapes.empty();
        }
        return buffer[0];
    }

    @NotNull
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, BITES});
    }
}

