/*
 * Decompiled with CFR 0.152.
 */
package dev.averageanime.neoforge.block.type.display.plate;

import dev.averageanime.neoforge.block.ModBlocks;
import dev.averageanime.neoforge.block.type.display.FoodBlock;
import dev.averageanime.neoforge.block.type.display.SmallPlateFoodBlock;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import vectorwing.farmersdelight.common.utility.ItemUtils;

public class SmallPlateBlock
extends Block {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    protected static final VoxelShape SHAPE = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)1.0, (double)12.0);

    public SmallPlateBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return SHAPE;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    @NotNull
    protected ItemInteractionResult useItemOn(@NotNull ItemStack heldStack, @NotNull BlockState state, Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hit) {
        if (player.isShiftKeyDown()) {
            if (level.isClientSide) {
                return ItemInteractionResult.SUCCESS;
            }
            BlockState normalPlate = ((Block)ModBlocks.PLATE_BLOCK.get()).defaultBlockState();
            if (normalPlate.hasProperty((Property)FACING)) {
                normalPlate = (BlockState)normalPlate.setValue((Property)FACING, (Comparable)((Direction)state.getValue((Property)FACING)));
            }
            level.setBlock(pos, normalPlate, 3);
            level.playSound(null, pos, SoundEvents.WOOD_PLACE, SoundSource.BLOCKS, 0.8f, 0.8f);
            return ItemInteractionResult.SUCCESS;
        }
        if (level.isClientSide) {
            if (FoodBlock.Registry.isRegistered(heldStack.getItem())) {
                return ItemInteractionResult.SUCCESS;
            }
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        List<Supplier<Block>> stackBlockSuppliers = FoodBlock.Registry.getAllBlocks(heldStack.getItem());
        if (stackBlockSuppliers != null && !stackBlockSuppliers.isEmpty()) {
            Block stackBlock = null;
            for (Supplier<Block> supplier : stackBlockSuppliers) {
                Block block = supplier.get();
                if (!(block instanceof SmallPlateFoodBlock)) continue;
                stackBlock = block;
                break;
            }
            if (stackBlock != null) {
                BlockState newState = stackBlock.defaultBlockState();
                if (newState.hasProperty((Property)FACING)) {
                    newState = (BlockState)newState.setValue((Property)FACING, (Comparable)((Direction)state.getValue((Property)FACING)));
                }
                if (newState.hasProperty((Property)FoodBlock.STACK_SIZE)) {
                    newState = (BlockState)newState.setValue((Property)FoodBlock.STACK_SIZE, (Comparable)Integer.valueOf(1));
                }
                level.setBlock(pos, newState, 3);
                if (!player.isCreative()) {
                    heldStack.shrink(1);
                }
                level.playSound(null, pos, SoundEvents.ITEM_FRAME_ADD_ITEM, SoundSource.BLOCKS, 1.0f, 1.0f);
                return ItemInteractionResult.SUCCESS;
            }
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    @NotNull
    protected InteractionResult useWithoutItem(@NotNull BlockState state, Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull BlockHitResult hit) {
        if (!level.isClientSide) {
            Direction direction = player.getDirection().getOpposite();
            ItemStack dropStack = new ItemStack((ItemLike)Items.BOWL);
            ItemUtils.spawnItemEntity((Level)level, (ItemStack)dropStack, (double)((double)pos.getX() + 0.5), (double)((double)pos.getY() + 0.3), (double)((double)pos.getZ() + 0.5), (double)((double)direction.getStepX() * 0.15), (double)0.05, (double)((double)direction.getStepZ() * 0.15));
            level.removeBlock(pos, false);
            level.playSound(null, pos, SoundEvents.ITEM_FRAME_REMOVE_ITEM, SoundSource.BLOCKS, 0.8f, 0.8f);
        }
        return InteractionResult.SUCCESS;
    }
}

