/*
 * Decompiled with CFR 0.152.
 */
package dev.averageanime.neoforge.block.type.display.plate;

import dev.averageanime.neoforge.CreateFood;
import dev.averageanime.neoforge.block.ModBlocks;
import dev.averageanime.neoforge.block.type.display.FoodBlock;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class ModPlateBlocks {
    private static final List<PlateEntry> COMPATIBLE_PLATES = new ArrayList<PlateEntry>();
    private static final List<PlateEntry> COMPATIBLE_SMALL_PLATES = new ArrayList<PlateEntry>();

    public static void registerCompatiblePlates() {
        int normalPlatesFound = 0;
        int smallPlatesFound = 0;
        for (PlateEntry entry : COMPATIBLE_PLATES) {
            if (!ModPlateBlocks.registerPlateEntry(entry, (Block)ModBlocks.PLATE_BLOCK.get(), "normal")) continue;
            ++normalPlatesFound;
        }
        for (PlateEntry entry : COMPATIBLE_SMALL_PLATES) {
            if (!ModPlateBlocks.registerPlateEntry(entry, (Block)ModBlocks.SMALL_PLATE_BLOCK.get(), "small")) continue;
            ++smallPlatesFound;
        }
        if (normalPlatesFound <= 0 && smallPlatesFound <= 0) {
            CreateFood.LOGGER.debug("No compatible plate items from other mods found");
        }
    }

    private static boolean registerPlateEntry(PlateEntry entry, Block targetBlock, String plateType) {
        Block plateBlock;
        boolean registered = false;
        Item plateItem = ModPlateBlocks.getItemIfExists(entry.modId, entry.itemName);
        if (plateItem != null && plateItem != Items.AIR) {
            FoodBlock.Registry.registerEmptyPlateItem(() -> plateItem);
            FoodBlock.Registry.register(() -> plateItem, () -> targetBlock);
            registered = true;
        }
        if ((plateBlock = ModPlateBlocks.getBlockIfExists(entry.modId, entry.blockName)) != null && plateBlock != Blocks.AIR) {
            FoodBlock.Registry.registerCompatBlock(plateBlock, () -> targetBlock);
            registered = true;
        }
        return registered;
    }

    private static Item getItemIfExists(String modId, String itemName) {
        try {
            ResourceLocation itemRL = ResourceLocation.fromNamespaceAndPath((String)modId, (String)itemName);
            Item item = (Item)BuiltInRegistries.ITEM.get(itemRL);
            return item != null && item != Items.AIR ? item : null;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Block getBlockIfExists(String modId, String blockName) {
        try {
            ResourceLocation blockRL = ResourceLocation.fromNamespaceAndPath((String)modId, (String)blockName);
            Block block = (Block)BuiltInRegistries.BLOCK.get(blockRL);
            return block != null && block != Blocks.AIR ? block : null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean registerPlate(String modId, String itemName, String blockName, boolean isSmallPlate) {
        Block targetBlock = isSmallPlate ? (Block)ModBlocks.SMALL_PLATE_BLOCK.get() : (Block)ModBlocks.PLATE_BLOCK.get();
        PlateEntry entry = new PlateEntry(modId, itemName, blockName);
        return ModPlateBlocks.registerPlateEntry(entry, targetBlock, isSmallPlate ? "small" : "normal");
    }

    static {
        COMPATIBLE_PLATES.add(new PlateEntry("displaydelight", "food_plate", "food_plate"));
        COMPATIBLE_SMALL_PLATES.add(new PlateEntry("displaydelight", "small_food_plate", "small_food_plate"));
    }

    private static class PlateEntry {
        final String modId;
        final String itemName;
        final String blockName;

        PlateEntry(String modId, String itemName, String blockName) {
            this.modId = modId;
            this.itemName = itemName;
            this.blockName = blockName;
        }
    }
}

