/*
 * Decompiled with CFR 0.152.
 */
package dev.averageanime.neoforge.block.type.display.plate;

import dev.averageanime.neoforge.block.ModBlocks;
import dev.averageanime.neoforge.block.type.display.FoodBlock;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.UseItemOnBlockEvent;

@EventBusSubscriber(modid="createfood", bus=EventBusSubscriber.Bus.GAME)
public class BowlBlock {
    @SubscribeEvent
    public static void onUseItemOnBlock(UseItemOnBlockEvent event) {
        BlockState placeState;
        BlockPos placePos;
        BlockPos clickedPos;
        UseOnContext context = event.getUseOnContext();
        Item heldItem = context.getItemInHand().getItem();
        boolean isBowl = heldItem == Items.BOWL;
        boolean isRegisteredPlate = FoodBlock.Registry.isEmptyPlateItem(heldItem);
        if (!isBowl && !isRegisteredPlate) {
            return;
        }
        if (context.getPlayer() == null || !context.getPlayer().isShiftKeyDown()) {
            return;
        }
        Level level = context.getLevel();
        BlockState clickedState = level.getBlockState(clickedPos = context.getClickedPos());
        if (clickedState.is((Block)ModBlocks.PLATE_BLOCK.get()) || clickedState.is((Block)ModBlocks.SMALL_PLATE_BLOCK.get())) {
            return;
        }
        if (clickedState.canBeReplaced()) {
            placePos = clickedPos;
            placeState = clickedState;
        } else {
            placePos = clickedPos.relative(context.getClickedFace());
            placeState = level.getBlockState(placePos);
        }
        if (!placeState.canBeReplaced()) {
            return;
        }
        if (!level.isClientSide()) {
            List<Supplier<Block>> registeredBlocks;
            Block blockToPlace = isBowl ? (Block)ModBlocks.PLATE_BLOCK.get() : ((registeredBlocks = FoodBlock.Registry.getAllBlocks(heldItem)) != null && !registeredBlocks.isEmpty() ? registeredBlocks.get(0).get() : (Block)ModBlocks.PLATE_BLOCK.get());
            level.setBlock(placePos, (BlockState)blockToPlace.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)context.getHorizontalDirection()), 3);
            level.playSound(null, placePos, SoundEvents.WOOD_PLACE, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (context.getPlayer() != null && !context.getPlayer().isCreative()) {
                context.getItemInHand().shrink(1);
            }
        }
        event.cancelWithResult(ItemInteractionResult.sidedSuccess((boolean)level.isClientSide()));
    }
}

